/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MGraph;
import chemaxon.clustering.gui.MWrapNode;
import chemaxon.clustering.gui.component.ClusterViewer;
import chemaxon.clustering.gui.component.TreeRenderer;
import chemaxon.clustering.gui.component.TreeRendererModel;
import chemaxon.clustering.gui.component.TreeTableEditorFactory;
import chemaxon.clustering.gui.component.TreeTableModel;
import chemaxon.clustering.gui.component.TreeTableRendererFactory;
import chemaxon.clustering.gui.component.TreeTableResizer;
import chemaxon.clustering.gui.component.TreeTableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class TreeTable
extends JTable {
    public static final int DEFAULT_ROW_HEIGHT = 100;
    public static final int DEFAULT_COLUMN_BASE_WIDTH = 80;
    public static final int DEFAULT_COLUMN_SPECIAL_WIDTH = 120;
    private ClusterViewer clusterViewer;
    private MouseMotionListener mml = null;
    private int activeRow = -1;
    private TreeRenderer tree;
    private TreeRendererModel treeModel;
    private TreeTableResizer resizer;
    private TreeTableSorter sorter = new TreeTableSorter();
    private TreeTableRendererFactory rendererFactory;
    private TreeTableEditorFactory editorFactory;
    private int columnBaseWidth = 80;
    private int columnSpecialWidth = 120;
    private int rowHeight = 100;
    public static Color shadeColor = new Color(240, 240, 240);

    public TreeTable() {
        this.createMouseMotionListener();
        this.addMouseMotionListener(this.mml);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.resizer = new TreeTableResizer(this);
        this.setAutoResizeMode(0);
        this.rendererFactory = new TreeTableRendererFactory(this);
        this.editorFactory = new TreeTableEditorFactory(this);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.rowHeight);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    for (int i = minIndex; i <= maxIndex; ++i) {
                        if (!lsm.isSelectedIndex(i)) continue;
                        MWrapNode wn = (MWrapNode)TreeTable.this.tree.getPathForRow(i + 1).getLastPathComponent();
                    }
                }
            }
        });
    }

    public TreeTable(MGraph g) {
        this();
        this.setGraph(g);
    }

    public void setClusterViewer(ClusterViewer clusterViewer) {
        this.clusterViewer = clusterViewer;
    }

    public void clear() {
        if (this.treeModel != null) {
            this.treeModel.onRemove();
            this.treeModel = null;
        }
        if (this.tree != null) {
            this.tree.onRemove();
            this.tree = null;
        }
    }

    public void setGraph(MGraph g) {
        this.clear();
        this.treeModel = new TreeRendererModel(g);
        this.tree = new TreeRenderer(this.treeModel, this);
        this.sorter.setTableHeader(this.getTableHeader());
        this.sorter.setTableModel(new TreeTableModel(this.tree));
        this.setModel(this.sorter);
        this.tree.setSelectionModel(null);
        this.rendererFactory.setTreeRenderer(this.tree);
        this.editorFactory.setTreeEditor(this.tree);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getModel().getColumnClass(i) == String.class) {
                this.getColumnModel().getColumn(i).setPreferredWidth(this.columnBaseWidth);
                continue;
            }
            this.getColumnModel().getColumn(i).setPreferredWidth(this.columnSpecialWidth);
        }
        this.rendererFactory.setCompoundCountRenderer(g, false);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.tree != null && this.columnModel.getColumnCount() > 0) {
            int width = this.tree.getPreferredSize().width + 40;
            width = width < 120 ? 120 : width;
            this.columnModel.getColumn(0).setPreferredWidth(width);
        }
        super.tableChanged(e);
    }

    private void createMouseMotionListener() {
        this.mml = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TreeTable.this.clusterViewer == null) {
                    return;
                }
                int r = TreeTable.this.rowAtPoint(e.getPoint());
                if (r != TreeTable.this.activeRow) {
                    TreeTable.this.activeRow = r;
                    MWrapNode wn = (MWrapNode)TreeTable.this.tree.getPathForRow(TreeTable.this.activeRow + 1).getLastPathComponent();
                    TreeTable.this.clusterViewer.setActiveNode(wn.getNode());
                }
            }
        };
    }

    public void scrollRectToVisible(MWrapNode node) {
        int row = this.tree.getRowForPath(new TreePath(node));
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeRenderer.class || this.getColumnClass(this.editingColumn) == String.class ? -1 : this.editingRow;
    }

    public void onRemove() {
        this.rendererFactory.onRemove();
        this.rendererFactory = null;
        this.editorFactory.onRemove();
        this.editorFactory = null;
        if (this.tree != null) {
            ((TreeRendererModel)this.tree.getModel()).onRemove();
            this.tree.onRemove();
            this.tree = null;
        }
        this.resizer.unregister();
        this.resizer = null;
        this.sorter = null;
        this.clusterViewer = null;
        this.removeAll();
        this.mml = null;
    }

    public synchronized void sortByProperty(String propertyKey) {
        if (this.tree == null) {
            return;
        }
        ((TreeRendererModel)this.tree.getModel()).sortByProperty(propertyKey);
        this.tree.updateUI();
    }

    public synchronized void sortBySize() {
        if (this.tree == null) {
            return;
        }
        ((TreeRendererModel)this.tree.getModel()).sortBySize();
        this.tree.updateUI();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                if (index == -1) {
                    return "";
                }
                return this.columnModel.getColumn(index).getHeaderValue().toString();
            }
        };
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (this.isRowSelected(rowIndex)) {
            c.setBackground(ClusterViewer.MARK_COLOR_SHADE);
        } else if (rowIndex % 2 == 0) {
            c.setBackground(shadeColor);
        } else {
            c.setBackground(Color.white);
        }
        return c;
    }
}

