/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.gui.component;

import chemaxon.clustering.MBaseNode;
import chemaxon.clustering.gui.MWrapNode;
import chemaxon.clustering.gui.component.ChartPanel;
import chemaxon.clustering.gui.component.TreeRenderer;
import chemaxon.marvin.beans.MViewPane;
import chemaxon.struc.Molecule;
import java.text.DecimalFormat;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;

public class TreeTableModel
extends AbstractTableModel
implements TreeExpansionListener {
    private static final int CONSTANT_COLUMNS_COUNT = 3;
    private static final int ID_COLUMN = 0;
    private static final int COMPOUND_COUNT_COLUMN = 1;
    private static final int VIEWER_COLUMN = 2;
    private static final int MIN_COLUMN = 3;
    private static final int MAX_COLUMN = 4;
    private static final int AVG_COLUMN = 5;
    private static final int DST_COLUMN = 6;
    public static final int DEFAULT_PRECISION = 2;
    private int precision = 2;
    private String[] columnNames = null;
    private Class[] columnClasses = null;
    private JTree tree;
    private static DecimalFormat dformat = new DecimalFormat();

    public TreeTableModel(JTree t) {
        int colIdx;
        int i;
        dformat.setMaximumFractionDigits(this.precision);
        MWrapNode root = (MWrapNode)t.getModel().getRoot();
        int numOfRangeProperties = root.getPropertyCount();
        this.columnNames = new String[3 + numOfRangeProperties * 4];
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Compounds";
        this.columnNames[2] = "Structure";
        for (i = 0; i < numOfRangeProperties; ++i) {
            colIdx = this.getColumnIndex(i);
            String propKey = root.getPropertyKey(i);
            this.columnNames[colIdx] = "Min(" + propKey + ")";
            this.columnNames[colIdx + 1] = "Max(" + propKey + ")";
            this.columnNames[colIdx + 2] = "Avg(" + propKey + ")";
            this.columnNames[colIdx + 3] = "Dist(" + propKey + ")";
        }
        this.columnClasses = new Class[3 + numOfRangeProperties * 4];
        this.columnClasses[0] = TreeRenderer.class;
        this.columnClasses[1] = String.class;
        this.columnClasses[2] = MViewPane.class;
        for (i = 0; i < numOfRangeProperties; ++i) {
            colIdx = this.getColumnIndex(i);
            this.columnClasses[colIdx] = String.class;
            this.columnClasses[colIdx + 1] = String.class;
            this.columnClasses[colIdx + 2] = String.class;
            this.columnClasses[colIdx + 3] = ChartPanel.class;
        }
        this.tree = t;
        this.tree.addTreeExpansionListener(this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.tree.removeTreeExpansionListener(this);
        this.tree = null;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.fireTableDataChanged();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount() - 1;
    }

    public static String format(Object o) {
        if (o == null) {
            return "";
        }
        try {
            return dformat.format(o);
        }
        catch (Exception e) {
            return o.toString();
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        this.precision = p;
        dformat.setMaximumFractionDigits(this.precision);
    }

    @Override
    public Object getValueAt(int row, int col) {
        MWrapNode tmpwrapnod;
        MBaseNode tmpnod;
        Molecule tmpmol;
        if ((tmpmol = (tmpnod = (tmpwrapnod = (MWrapNode)this.tree.getPathForRow(++row).getLastPathComponent()).getNode()).getMolecule()) == null) {
            return null;
        }
        int propIdx = col > 2 ? this.getPropertyIndex(col) : -1;
        switch (this.getColumnIdentifier(col)) {
            case 0: {
                String tmp = tmpnod.hasChildren() ? String.valueOf(tmpnod.getID()) : tmpnod.getProperty("ID");
                return tmp == null ? "" : tmp;
            }
            case 1: {
                return String.valueOf(tmpnod.getLeafNodeCount());
            }
            case 2: {
                return tmpwrapnod.getViewPane();
            }
            case 3: {
                try {
                    return tmpwrapnod.getChildCount() != 0 ? TreeTableModel.format(tmpwrapnod.getPropertyMin(propIdx)) : "";
                }
                catch (IllegalArgumentException e) {
                    return "";
                }
            }
            case 4: {
                try {
                    return tmpwrapnod.getChildCount() != 0 ? TreeTableModel.format(tmpwrapnod.getPropertyMax(propIdx)) : "";
                }
                catch (IllegalArgumentException e) {
                    return "";
                }
            }
            case 5: {
                try {
                    return tmpwrapnod.getChildCount() != 0 ? TreeTableModel.format(tmpwrapnod.getPropertyAverage(propIdx)) : TreeTableModel.format(tmpwrapnod.getProperty(propIdx));
                }
                catch (IllegalArgumentException e) {
                    return "";
                }
            }
            case 6: {
                return new ChartPanel(tmpwrapnod, propIdx);
            }
        }
        return null;
    }

    private int getPropertyIndex(int columnIndex) {
        return (columnIndex - 3) / 4;
    }

    private int getColumnIndex(int propertyIndex) {
        return propertyIndex * 4 + 3;
    }

    private int getColumnIdentifier(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        int c = (columnIndex - 3) % 4;
        switch (c) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 6;
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getColumnClass(column) != String.class;
    }

    public void destroyModel() {
        this.tree = null;
    }
}

