/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.server;

import chemaxon.clustering.server.ServerConnection;
import chemaxon.clustering.tools.simplexml.create.HTMLCreator;
import chemaxon.clustering.tools.simplexml.create.Printer;
import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.util.U;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Server<S extends Session> {
    Log log = LogFactory.getLog(Server.class);
    Vector<StaticMap> staticMaps = new Vector();
    Vector<String> staticActionPrefix = new Vector();
    Vector<Action> staticAction = new Vector();
    String emptyRedirect = null;
    S session;
    NewSessionCallback<S> nscb;
    int state = 0;
    LinkTransformer tpagelink = new IdentityLinkTransformer();
    LinkTransformer tlink = new IdentityLinkTransformer();

    public LinkTransformer getTPageLink() {
        return this.tpagelink;
    }

    public LinkTransformer getTlink() {
        return this.tlink;
    }

    public void setTPageLink(LinkTransformer t) {
        this.tpagelink = t;
    }

    public void setTLink(LinkTransformer t) {
        this.tlink = t;
    }

    public Server(NewSessionCallback<S> nscb) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Server constructed.");
        }
        this.nscb = nscb;
        this.session = this.nscb != null ? nscb.initSession(this) : null;
        this.setStaticMapping("static/style.css", "/chemaxon/clustering/server/content/style.css", true, new SimpleProcessor(){
            Session s = null;

            @Override
            public void printLine(Printer wr, String line) {
                if (line.indexOf("/* THIS_LINE_CONTAINS_BODY_FONTSIZE */") >= 0) {
                    wr.println("\tfont-size: " + this.s.bodyFontSize.getCurrentValue() + "px; /* replaced font size */");
                } else {
                    super.printLine(wr, line);
                }
            }

            @Override
            public void process(BufferedReader rd, Printer wr, Session s) {
                this.s = s;
                super.process(rd, wr, s);
            }
        });
        this.setStaticMapping("static/", "/chemaxon/clustering/server/content/", false, null);
        this.setStaticMapping("favicon.ico", "/chemaxon/clustering/server/content/favicon.ico", true, null);
        this.setStaticAction("exit", new ActionExit());
    }

    public void setEmptyRedirect(String addr) {
        this.emptyRedirect = addr;
    }

    public void setStaticMapping(String prefix, String mount, boolean completeMatch, TextProcessor proc) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Add static map \"" + prefix + "\" mapped to \"" + mount + "\" complete: " + completeMatch));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException();
        }
        StaticMap map = new StaticMap(prefix, mount, completeMatch, proc);
        this.staticMaps.add(map);
    }

    public void setStaticAction(String prefix, Action action) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Add static action map \"" + prefix + "\" to \"" + action));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException();
        }
        action.prefix = prefix;
        action.registerServer(this);
        if (this.staticActionPrefix.contains(prefix)) {
            int i = this.staticActionPrefix.indexOf(prefix);
            this.staticActionPrefix.remove(i);
            this.staticAction.remove(i);
        }
        this.staticActionPrefix.add(prefix);
        this.staticAction.add(action);
    }

    public void stopListening() {
        this.state = 2;
    }

    StaticMap.MapResult<S> getStaticMapping(String req) throws UnsupportedEncodingException {
        while (req.startsWith("/")) {
            req = req.substring(1);
        }
        for (int i = 0; i < this.staticMaps.size(); ++i) {
            StaticMap smi = this.staticMaps.get(i);
            String p = smi.prefix;
            if (smi.complete) {
                if (!req.equals(p)) continue;
                StaticMap.MapResult ret = new StaticMap.MapResult();
                ret.mapped = smi.mount;
                ret.processor = smi.processor;
                ret.session = this.session;
                return ret;
            }
            if (!req.startsWith(p)) continue;
            String m = smi.mount;
            StaticMap.MapResult ret = new StaticMap.MapResult();
            ret.mapped = URLDecoder.decode(m + req.substring(p.length()), "UTF-8");
            ret.processor = smi.processor;
            ret.session = this.session;
            return ret;
        }
        return null;
    }

    Action getStaticAction(String req) {
        while (req.startsWith("/")) {
            req = req.substring(1);
        }
        for (int i = 0; i < this.staticActionPrefix.size(); ++i) {
            String p = this.staticActionPrefix.get(i);
            if (!req.startsWith(p)) continue;
            Action a = this.staticAction.get(i).getClone(this.session);
            a.reset();
            int qmi = req.indexOf(63);
            if (qmi >= 0) {
                String params = req.substring(qmi + 1);
                StringTokenizer tok = new StringTokenizer(params, "&");
                while (tok.hasMoreTokens()) {
                    String nt;
                    String pn = nt = tok.nextToken();
                    String pv = null;
                    int eqi = nt.indexOf("=");
                    if (eqi > 0) {
                        pn = nt.substring(0, eqi);
                        pv = nt.substring(eqi + 1);
                    }
                    if (this.session != null && ((Action)this.session).setParam(pn, pv)) continue;
                    a.setParam(pn, pv);
                }
            }
            return a;
        }
        return null;
    }

    public void runListeningLoop(int port) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("run listening loop on port " + port));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException();
        }
        this.state = 1;
        ServerSocket srv = new ServerSocket(port);
        while (this.state == 1) {
            Socket s = srv.accept();
            new ServerConnection(this, s).start();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"listening loop finished");
        }
    }

    public static class RequestFromSocket
    implements Request {
        Log log = LogFactory.getLog(RequestFromSocket.class);
        String method;
        boolean head;
        boolean get;
        String req;

        public RequestFromSocket(Socket sock) throws Exception {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(sock.getInputStream(), "8859_1"));
                String request = in.readLine();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Request received: " + request));
                }
                StringTokenizer tok = new StringTokenizer(request);
                this.method = tok.nextToken();
                this.get = this.method.equals("GET");
                this.head = this.method.equals("HEAD");
                this.req = tok.nextToken();
                while (this.req.startsWith("/")) {
                    this.req = this.req.substring(1);
                }
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Error processing request", (Throwable)e);
                }
                throw e;
            }
        }

        @Override
        public boolean isEmbedRequired() {
            return false;
        }

        @Override
        public String getRequestURI() {
            return this.req;
        }

        @Override
        public String getMethod() {
            return this.method;
        }

        @Override
        public boolean isGet() {
            return this.get;
        }

        @Override
        public boolean isHead() {
            return this.head;
        }
    }

    public static class ResponseFromSocket
    implements Response {
        Log log = LogFactory.getLog(ResponseFromSocket.class);
        OutputStream out;
        String contentType = null;
        states state;
        PrintWriter w = null;
        public static final String ctypeTextHtml = "text/html";

        public ResponseFromSocket(Socket s) throws Exception {
            this.out = s.getOutputStream();
            this.state = states.constructed;
        }

        @Override
        public void sendRedirect(String target) {
            if (this.state != states.constructed) {
                throw new IllegalStateException("State is " + (Object)((Object)this.state));
            }
            this.setContentType(ctypeTextHtml);
            PrintWriter pw = this.getWriter();
            pw.print("<HTML>\n<HEAD>\n<TITLE>Redirect to start page</TITLE>\n<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL=" + target + "\">" + "</HEAD>\n" + "<BODY>" + "You are being redirected to <A HREF=\"" + target + "\">" + target + "</A>" + "</BODY>" + "</HTML>");
            this.close();
        }

        @Override
        public void setCSS(String url) {
        }

        @Override
        public void setTitle(String title) {
        }

        @Override
        public void sendError(int code, String msg) {
            block3: {
                if (this.state != states.constructed) {
                    throw new IllegalStateException("State is " + (Object)((Object)this.state));
                }
                try {
                    PrintWriter w = this.constructPW();
                    w.print(code);
                    w.print(' ');
                    w.println(msg);
                    this.close();
                }
                catch (UnsupportedEncodingException e) {
                    if (!this.log.isErrorEnabled()) break block3;
                    this.log.error((Object)"Exception", (Throwable)e);
                }
            }
        }

        @Override
        public void setContentType(String contentType) {
            this.contentType = contentType;
            this.state = states.ctypeset;
        }

        PrintWriter constructPW() throws UnsupportedEncodingException {
            return new PrintWriter((Writer)new OutputStreamWriter(this.out, "8859_1"), true);
        }

        @Override
        public PrintWriter getWriter() {
            if (this.state != states.ctypeset) {
                throw new IllegalStateException("State is " + (Object)((Object)this.state));
            }
            try {
                this.state = states.streamRequested;
                this.w = this.constructPW();
                this.w.print("HTTP/1.0 200 OK\r\n");
                this.w.print("Content-type: ");
                this.w.print(this.contentType);
                this.w.print("\r\n\r\n");
                return this.w;
            }
            catch (UnsupportedEncodingException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Exception", (Throwable)ex);
                }
                return null;
            }
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.state != states.ctypeset) {
                throw new IllegalStateException("State is " + (Object)((Object)this.state));
            }
            this.state = states.streamRequested;
            try {
                this.out.write("HTTP/1.0 200 OK\r\n".getBytes());
                this.out.write("Content-type: ".getBytes());
                this.out.write(this.contentType.getBytes());
                this.out.write("\r\n\r\n".getBytes());
                return this.out;
            }
            catch (IOException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Exception", (Throwable)e);
                }
                this.close();
                return null;
            }
        }

        @Override
        public void close() {
            block3: {
                try {
                    if (this.w != null) {
                        this.w.flush();
                        this.w.close();
                    }
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException e) {
                    if (!this.log.isErrorEnabled()) break block3;
                    this.log.error((Object)"Exception", (Throwable)e);
                }
            }
            this.state = states.closed;
        }

        static enum states {
            constructed,
            ctypeset,
            closed,
            streamRequested;

        }
    }

    public static interface Response {
        public void sendRedirect(String var1);

        public void setCSS(String var1);

        public void setTitle(String var1);

        public void sendError(int var1, String var2);

        public void setContentType(String var1);

        public PrintWriter getWriter();

        public OutputStream getOutputStream();

        public void close();
    }

    public static interface Request {
        public boolean isEmbedRequired();

        public String getRequestURI();

        public String getMethod();

        public boolean isHead();

        public boolean isGet();
    }

    public static class StaticMap {
        String prefix;
        String mount;
        boolean complete;
        TextProcessor processor;

        public StaticMap(String prefix, String mount, boolean complete, TextProcessor proc) {
            this.prefix = prefix;
            this.mount = mount;
            this.complete = complete;
            this.processor = proc;
        }

        public static class MapResult<S extends Session> {
            public String mapped = null;
            public TextProcessor processor = null;
            public S session = null;
        }
    }

    public static class PackerLinkTransformer
    implements LinkTransformer {
        String prefix;

        public PackerLinkTransformer(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String encode(String link) {
            try {
                return this.prefix + URLEncoder.encode(link, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LogFactory.getLog(PackerLinkTransformer.class).error((Object)("Error packing link " + link), (Throwable)ex);
                return null;
            }
        }

        @Override
        public String decode(String link) {
            if (link == null) {
                link = "";
            }
            try {
                return URLDecoder.decode(link, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LogFactory.getLog(PackerLinkTransformer.class).error((Object)("Error unpacking link " + link), (Throwable)ex);
                return null;
            }
        }
    }

    public static class IdentityLinkTransformer
    implements LinkTransformer {
        @Override
        public String encode(String link) {
            return link;
        }

        @Override
        public String decode(String link) {
            return link;
        }
    }

    public static interface LinkTransformer {
        public String encode(String var1);

        public String decode(String var1);
    }

    public static interface NewSessionCallback<S extends Session> {
        public S initSession(Server var1);
    }

    public static class SimpleProcessor
    implements TextProcessor {
        public void printLine(Printer wr, String line) {
            wr.println(line);
        }

        @Override
        public void process(BufferedReader rd, Printer wr, Session s) {
            try {
                String l;
                while ((l = rd.readLine()) != null) {
                    this.printLine(wr, l);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static interface TextProcessor {
        public void process(BufferedReader var1, Printer var2, Session var3);
    }

    public static class Session
    extends Action {
        Action.IParamDescriptor bodyFontSize;

        public Session(Server server) {
            this.registerServer(server);
            this.bodyFontSize = this.addIParamDescriptor("bodyFontSize", 10);
        }

        @Override
        public Action initClone() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void execute(ServerConnection conn) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        Action getActionForNewPD() {
            return null;
        }

        @Override
        void postProcessNewPD(Action.ParamDescriptorBase d) {
            super.postProcessNewPD(d);
            d.reset();
        }

        public String fontSizeChangeLinks(Action a) {
            int cv = this.bodyFontSize.getCurrentValue();
            int lv = cv - 1;
            int hv = cv + 1;
            if (lv < 1) {
                lv = 1;
            }
            if (hv > 1000) {
                hv = 1000;
            }
            return "<a href=\"" + this.bodyFontSize.getChangedLink(a, "" + lv) + "\">" + "" + "<img src=\"" + this.server.getTlink().encode("/static/icons/decfs16.png") + "\" border=\"0\" style=\"vertical-align:middle;\" alt=\"Decrease font size\"/>" + "</a>&nbsp;<a href=\"" + this.bodyFontSize.getChangedLink(a, "" + hv) + "\">" + "<img src=\"" + this.server.getTlink().encode("/static/icons/incfs16.png") + "\" border=\"0\" style=\"vertical-align:middle;\" alt=\"Increase font size\"/>" + "" + "</a>";
        }
    }

    public static abstract class Action<S extends Session> {
        String name = null;
        String prefix = null;
        S session = null;
        Server server = null;
        Vector<ParamDescriptor> pds = null;

        final void registerServer(Server server) {
            this.server = server;
        }

        public Server getServer() {
            return this.server;
        }

        public IParamDescriptor addIParamDescriptor(String name, int defv) {
            if (this.pds == null) {
                this.pds = new Vector();
            }
            IParamDescriptor ret = new IParamDescriptor(name, defv, this.getActionForNewPD());
            this.pds.add(ret);
            this.postProcessNewPD(ret);
            return ret;
        }

        public DParamDescriptor addDParamDescriptor(String name, double defv) {
            if (this.pds == null) {
                this.pds = new Vector();
            }
            DParamDescriptor ret = new DParamDescriptor(name, defv, this.getActionForNewPD());
            this.pds.add(ret);
            this.postProcessNewPD(ret);
            return ret;
        }

        public IAParamDescriptor addIAParamDescriptor(String name, int[] defv, boolean strict) {
            if (this.pds == null) {
                this.pds = new Vector();
            }
            IAParamDescriptor ret = new IAParamDescriptor(name, defv, this.getActionForNewPD(), strict);
            this.pds.add(ret);
            this.postProcessNewPD(ret);
            return ret;
        }

        public abstract Action initClone();

        void postProcessNewPD(ParamDescriptorBase d) {
        }

        Action getActionForNewPD() {
            return this;
        }

        public final Action getClone(S session) {
            Action ret = this.initClone();
            ret.prefix = this.prefix;
            ret.session = session;
            ret.server = this.server;
            return ret;
        }

        public boolean isSingle() {
            return false;
        }

        public void reset() {
            this.name = null;
            if (this.pds != null) {
                for (int i = 0; i < this.pds.size(); ++i) {
                    this.pds.get(i).reset();
                }
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLink() {
            return this.getLink((ParamDescriptor)null, null);
        }

        void appendActionLink(StringBuffer b) {
            b.append('/');
            b.append(this.prefix);
        }

        public S getSession() {
            return this.session;
        }

        void appendSingleParameter(StringBuffer b, ParamDescriptor param, String newValue) {
            if (b.indexOf("?") < 0) {
                b.append('?');
            } else {
                b.append('&');
            }
            b.append(param.getName());
            b.append('=');
            if (newValue == null) {
                b.append(param.getValueString());
            } else {
                b.append(newValue);
            }
        }

        void appendActionParameters(StringBuffer b, ParamDescriptor changed, String newValue) {
            boolean paramAppended = false;
            if (this.pds != null && this.pds.size() > 0) {
                for (int i = 0; i < this.pds.size(); ++i) {
                    ParamDescriptor pd = this.pds.get(i);
                    if (changed != null && changed == pd) continue;
                    if (paramAppended) {
                        b.append('&');
                    } else {
                        paramAppended = true;
                        b.append('?');
                    }
                    b.append(pd.getName());
                    b.append('=');
                    b.append(pd.getValueString());
                }
            }
            if (changed != null) {
                if (paramAppended) {
                    b.append('&');
                } else {
                    paramAppended = true;
                    b.append('?');
                }
                b.append(changed.getName());
                b.append('=');
                b.append(newValue);
            }
        }

        void appendActionParameters(StringBuffer b, ParamDescriptor[] changed, String[] newValue) {
            int i;
            boolean paramAppended = false;
            if (this.pds != null && this.pds.size() > 0) {
                for (i = 0; i < this.pds.size(); ++i) {
                    ParamDescriptor pd = this.pds.get(i);
                    if (changed != null) {
                        boolean c = false;
                        for (int j = 0; j < changed.length; ++j) {
                            if (changed[j] != pd) continue;
                            c = true;
                            break;
                        }
                        if (c) continue;
                    }
                    if (paramAppended) {
                        b.append('&');
                    } else {
                        paramAppended = true;
                        b.append('?');
                    }
                    b.append(pd.getName());
                    b.append('=');
                    b.append(pd.getValueString());
                }
            }
            if (changed != null) {
                for (i = 0; i < changed.length; ++i) {
                    if (paramAppended) {
                        b.append('&');
                    } else {
                        paramAppended = true;
                        b.append('?');
                    }
                    b.append(changed[i].getName());
                    b.append('=');
                    b.append(newValue[i]);
                }
            }
        }

        public String getLink(ParamDescriptor changed, String newValue) {
            StringBuffer b = new StringBuffer();
            this.appendActionLink(b);
            this.appendActionParameters(b, changed, newValue);
            return this.server.tpagelink.encode(b.toString());
        }

        public String getLink(ParamDescriptor[] changed, String[] newValue) {
            StringBuffer b = new StringBuffer();
            this.appendActionLink(b);
            this.appendActionParameters(b, changed, newValue);
            return this.server.tpagelink.encode(b.toString());
        }

        public boolean setParam(String name, String value) {
            if (this.pds == null || name == null) {
                return false;
            }
            for (int i = 0; i < this.pds.size(); ++i) {
                ParamDescriptor pd = this.pds.get(i);
                if (!name.equals(pd.getName())) continue;
                pd.parse(value);
                return true;
            }
            return false;
        }

        public abstract void execute(ServerConnection var1);

        public void executeHead(ServerConnection conn) {
            conn.respondHTMLFull(null);
        }

        public static class DParamDescriptor
        extends ParamDescriptorBase {
            final double defaultValue;
            double currentValue = 0.0;

            public String getChangedLink(double newValue) {
                return this.getChangedLink("" + newValue);
            }

            @Override
            public String getValueString() {
                return "" + this.currentValue;
            }

            public DParamDescriptor(String name, double defaultValue, Action a) {
                super(a, name);
                this.defaultValue = defaultValue;
            }

            public double getCurrentValue() {
                return this.currentValue;
            }

            public void setCurrentValue(double v) {
                this.currentValue = v;
            }

            @Override
            public void reset() {
                this.currentValue = this.defaultValue;
            }

            @Override
            public void parse(String s) {
                try {
                    this.currentValue = Double.parseDouble(s);
                }
                catch (Exception e) {
                    this.reset();
                }
            }

            @Override
            public ParamDescriptor getClone(Action clonedA) {
                return new DParamDescriptor(this.name, this.defaultValue, clonedA);
            }
        }

        public static class IParamDescriptor
        extends ParamDescriptorBase {
            final int defaultValue;
            int currentValue = 0;

            public String getChangedLink(int newValue) {
                return this.getChangedLink("" + newValue);
            }

            public String getChangedLink(Action a, int newValue) {
                return this.getChangedLink(a, "" + newValue);
            }

            @Override
            public String getValueString() {
                return "" + this.currentValue;
            }

            @Override
            public ParamDescriptor getClone(Action clonedA) {
                return new IParamDescriptor(this.name, this.defaultValue, clonedA);
            }

            public IParamDescriptor(String name, int defaultValue, Action a) {
                super(a, name);
                this.defaultValue = defaultValue;
            }

            public int getCurrentValue() {
                return this.currentValue;
            }

            public void setCurrentValue(int v) {
                this.currentValue = v;
            }

            @Override
            public void reset() {
                this.currentValue = this.defaultValue;
            }

            @Override
            public void parse(String s) {
                try {
                    this.currentValue = Integer.parseInt(s);
                }
                catch (Exception e) {
                    this.reset();
                }
            }
        }

        public static class IAParamDescriptor
        extends ParamDescriptorBase {
            int[] defaults;
            int[] values;
            boolean fixedSize;

            public IAParamDescriptor(String name, int[] defaultValues, Action a, boolean fixedSize) {
                super(a, name);
                this.defaults = defaultValues;
                this.values = new int[this.defaults.length];
                this.fixedSize = fixedSize;
            }

            public int[] getCurrentValue() {
                return this.values;
            }

            public int[] getCurrentValueClone() {
                return U.clone(this.getCurrentValue());
            }

            public static String getValueString(int[] a, int pos, int posv) {
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < a.length; ++i) {
                    if (i != 0) {
                        b.append(',');
                    }
                    if (i == pos) {
                        b.append(posv);
                        continue;
                    }
                    b.append(a[i]);
                }
                if (pos == a.length) {
                    if (a.length > 0) {
                        b.append(',');
                    }
                    b.append(posv);
                }
                return b.toString();
            }

            @Override
            public String getValueString() {
                return IAParamDescriptor.getValueString(this.values, -1, -1);
            }

            public String getValueString(int pos, int newV) {
                return IAParamDescriptor.getValueString(this.values, pos, newV);
            }

            public String getValueString(int append) {
                return IAParamDescriptor.getValueString(this.values, this.values.length, append);
            }

            public String getChangedLink(int[] newValues) {
                return this.getChangedLink(IAParamDescriptor.getValueString(newValues, -1, 0));
            }

            @Override
            public void parse(String s) {
                try {
                    StringTokenizer tok = new StringTokenizer(s, ",");
                    if (this.fixedSize) {
                        for (int i = 0; i < this.values.length; ++i) {
                            this.values[i] = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
                        }
                    } else {
                        IntVector v = new IntVector();
                        while (tok.hasMoreTokens()) {
                            v.add(Integer.parseInt(tok.nextToken()));
                        }
                        this.values = v.toArray();
                    }
                }
                catch (Exception e) {
                    this.reset();
                }
            }

            @Override
            public void reset() {
                if (this.defaults.length != this.values.length) {
                    this.values = U.clone(this.defaults);
                } else {
                    for (int i = 0; i < this.defaults.length; ++i) {
                        this.values[i] = this.defaults[i];
                    }
                }
            }

            @Override
            public ParamDescriptor getClone(Action clonedA) {
                return new IAParamDescriptor(this.name, this.defaults, clonedA, this.fixedSize);
            }
        }

        public static abstract class ParamDescriptorBase
        implements ParamDescriptor {
            final Action action;
            final String name;

            public ParamDescriptorBase(Action action, String name) {
                this.action = action;
                this.name = name;
            }

            @Override
            public String getChangedLink(String changedValue) {
                return this.getChangedLink(null, changedValue);
            }

            @Override
            public String getChangedLink(Action a, String changedValue) {
                if (a == null && this.action == null) {
                    throw new NullPointerException();
                }
                if (a != null && this.action != null) {
                    throw new UnsupportedOperationException();
                }
                Action aa = a == null ? this.action : a;
                return aa.getLink(this, changedValue);
            }

            @Override
            public String getName() {
                return this.name;
            }
        }

        public static interface ParamDescriptor {
            public String getName();

            public String getValueString();

            public void parse(String var1);

            public void reset();

            public ParamDescriptor getClone(Action var1);

            public String getChangedLink(String var1);

            public String getChangedLink(Action var1, String var2);
        }
    }

    public static class ActionExternalRedirect
    extends Action {
        String target;

        public ActionExternalRedirect(String target) {
            this.target = target;
        }

        @Override
        public Action initClone() {
            return new ActionExternalRedirect(this.target);
        }

        @Override
        public void execute(ServerConnection conn) {
            conn.response.sendRedirect(this.target);
        }
    }

    public class ActionExit
    extends Action {
        boolean confirmed = false;

        @Override
        public void reset() {
            super.reset();
        }

        @Override
        public boolean setParam(String name, String value) {
            if (name.equals("confirm") && value.equals("true")) {
                this.confirmed = true;
                return true;
            }
            return false;
        }

        @Override
        public void execute(ServerConnection conn) {
            if (Server.this.state == 2 || this.confirmed) {
                Server.this.state = 2;
                HTMLCreator resp = conn.respondHTMLCreator("Stop server");
                resp.h1("Stop server");
                resp.text("Server stop requested");
                resp.p("Please refresh data");
                resp.close();
            } else {
                HTMLCreator resp = conn.respondHTMLCreator("Stop server");
                resp.h1("Stop server");
                resp.p("Stop server?");
                resp.text("<center><a href=\"" + conn.getTPLink().encode("/exit?confirm=true") + "\">Stop</A> | <a href=\"" + conn.getTPLink().encode("/") + "\">No, take me to the start page</a></center>");
                resp.close();
            }
        }

        @Override
        public Action initClone() {
            return new ActionExit();
        }
    }
}

