/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.server.clustorServer;

import chemaxon.clustering.backend.Entity;
import chemaxon.clustering.backend.EntityGroup;
import chemaxon.clustering.backend.HC;
import chemaxon.clustering.backend.HierarchicEntityGroup;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.Filter;
import chemaxon.clustering.util.RAIterator;
import chemaxon.clustering.util.RandomAccess;
import chemaxon.clustering.util.SimpleRAIterator;

class GroupCache {
    private HC hc;
    private static final int TYPE_ALL_NATURAL = 0;
    private static final int TYPE_ALL_DESC_LEAVESIZE = 1;
    private static final int TYPE_ALL_ASC_LEAVESIZE = 2;
    private static final int TYPE_NOSINGLETONS_NATURAL = 3;
    private static final int TYPE_NOSINGLETONS_DESC_LEAVESIZE = 4;
    private static final int TYPE_NOSINGLETONS_ASC_LEAVESIZE = 5;
    private static final int TYPE_SINGLETONS = 6;
    private static final int TYPES_BOTTOMLEVEL = 7;
    private static final int TYPE_ALL_DESC_SUBTREECOUNT = 7;
    private static final int TYPE_ALL_ASC_SUBTREECOUNT = 8;
    private static final int TYPE_NOSINGLETONS_DESC_SUBTREECOUNT = 9;
    private static final int TYPE_NOSINGLETONS_ASC_SUBTREECOUNT = 10;
    private static final int TYPES_UPPERLEVELS = 11;
    RAIterator<Entity> leaveLevel;
    RAIterator<EntityGroup>[] bottomLevels;
    RAIterator<EntityGroup>[][] upperLevels;
    int levels;
    static final Filter<EntityGroup> FILTER_SINGLETONGROUP = new Filter<EntityGroup>(){

        @Override
        public boolean match(EntityGroup t) {
            return t.size() == 1;
        }
    };
    static final Filter<EntityGroup> FILTER_NONSINGLETONGROUP = new Filter<EntityGroup>(){

        @Override
        public boolean match(EntityGroup t) {
            return t.size() > 1;
        }
    };
    static final Comparator<EntityGroup> COMPARATOR_ASCENDING_LEAVESIZE = new Comparator<EntityGroup>(){

        @Override
        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
            return t1.size() > t2.size();
        }
    };
    static final Comparator<EntityGroup> COMPARATOR_DESCENDING_LEAVESIZE = new Comparator<EntityGroup>(){

        @Override
        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
            return t1.size() < t2.size();
        }
    };
    static final Comparator<EntityGroup> COMPARATOR_ASCENDING_SUBTREECOUNT = new Comparator<EntityGroup>(){

        @Override
        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
            HierarchicEntityGroup h1 = t1.getHierarchic();
            HierarchicEntityGroup h2 = t2.getHierarchic();
            if (h1 == null || h2 == null) {
                return false;
            }
            return h1.getSubtreeCount() > h2.getSubtreeCount();
        }
    };
    static final Comparator<EntityGroup> COMPARATOR_DESCENDING_SUBTREECOUNT = new Comparator<EntityGroup>(){

        @Override
        public boolean isGreater(EntityGroup t1, EntityGroup t2) {
            HierarchicEntityGroup h1 = t1.getHierarchic();
            HierarchicEntityGroup h2 = t2.getHierarchic();
            if (h1 == null || h2 == null) {
                return false;
            }
            return h1.getSubtreeCount() < h2.getSubtreeCount();
        }
    };

    GroupCache(HC hc) {
        this.hc = hc;
        this.levels = hc.getLevelCount();
        this.bottomLevels = new RAIterator[7];
        this.upperLevels = new RAIterator[this.levels - 2][11];
        this.leaveLevel = new SimpleRAIterator<Entity>(new RandomAccess<Entity>(){

            @Override
            public int size() {
                return GroupCache.this.hc.getLeavesCount();
            }

            @Override
            public Entity get(int i) {
                return GroupCache.this.hc.getTree().getLeaf(i);
            }

            @Override
            public int indexOf(Entity e) {
                return e.getIndex();
            }

            @Override
            public int getCC() {
                return 0;
            }

            @Override
            public boolean isGetSupported() {
                return true;
            }
        });
    }

    public int getLevelCount() {
        return this.levels;
    }

    public RAIterator<EntityGroup> getFilteredGroup(int level, int ftype) {
        if (level <= 0) {
            throw new IndexOutOfBoundsException("Invalid level " + level);
        }
        if (level >= this.getLevelCount()) {
            throw new IndexOutOfBoundsException("Invalid level " + level);
        }
        if (ftype < 0) {
            throw new IndexOutOfBoundsException("Invalid filter type " + ftype);
        }
        if (level == 1 && ftype >= 7) {
            throw new IndexOutOfBoundsException("Invalid filter type for bottom level " + ftype);
        }
        if (level > 1 && ftype >= 11) {
            throw new IndexOutOfBoundsException("Invalid filter type " + ftype);
        }
        if (level == 1) {
            if (this.bottomLevels[ftype] == null) {
                Filter<EntityGroup> filter = null;
                Comparator<EntityGroup> comparator = null;
                switch (ftype) {
                    case 2: {
                        comparator = COMPARATOR_ASCENDING_LEAVESIZE;
                        break;
                    }
                    case 1: {
                        comparator = COMPARATOR_DESCENDING_LEAVESIZE;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 5: {
                        comparator = COMPARATOR_ASCENDING_LEAVESIZE;
                        filter = FILTER_NONSINGLETONGROUP;
                        break;
                    }
                    case 4: {
                        comparator = COMPARATOR_DESCENDING_LEAVESIZE;
                        filter = FILTER_NONSINGLETONGROUP;
                        break;
                    }
                    case 3: {
                        filter = FILTER_NONSINGLETONGROUP;
                        break;
                    }
                    case 6: {
                        filter = FILTER_SINGLETONGROUP;
                    }
                }
                this.bottomLevels[ftype] = this.hc.getGroups(1, comparator, filter);
            }
            return this.bottomLevels[ftype];
        }
        if (this.upperLevels[level - 2][ftype] == null) {
            Filter<EntityGroup> filter = null;
            Comparator<EntityGroup> comparator = null;
            switch (ftype) {
                case 2: {
                    comparator = COMPARATOR_ASCENDING_LEAVESIZE;
                    break;
                }
                case 1: {
                    comparator = COMPARATOR_DESCENDING_LEAVESIZE;
                    break;
                }
                case 8: {
                    comparator = COMPARATOR_ASCENDING_SUBTREECOUNT;
                    break;
                }
                case 7: {
                    comparator = COMPARATOR_DESCENDING_SUBTREECOUNT;
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    comparator = COMPARATOR_ASCENDING_LEAVESIZE;
                    filter = FILTER_NONSINGLETONGROUP;
                    break;
                }
                case 4: {
                    comparator = COMPARATOR_DESCENDING_LEAVESIZE;
                    filter = FILTER_NONSINGLETONGROUP;
                    break;
                }
                case 10: {
                    comparator = COMPARATOR_ASCENDING_SUBTREECOUNT;
                    filter = FILTER_NONSINGLETONGROUP;
                    break;
                }
                case 9: {
                    comparator = COMPARATOR_DESCENDING_SUBTREECOUNT;
                    filter = FILTER_NONSINGLETONGROUP;
                    break;
                }
                case 3: {
                    filter = FILTER_NONSINGLETONGROUP;
                    break;
                }
                case 6: {
                    filter = FILTER_SINGLETONGROUP;
                }
            }
            this.upperLevels[level - 2][ftype] = this.hc.getGroups(level, comparator, filter);
        }
        return this.upperLevels[level - 2][ftype];
    }
}

