/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simpleeval;

import chemaxon.clustering.tools.simpleeval.OperatorDouble;

public class DoubleVariable
implements OperatorDouble {
    String name;
    double value = 0.0;
    boolean used = false;
    boolean constant;

    public DoubleVariable(String name) {
        this.name = name;
        this.constant = false;
    }

    public DoubleVariable(double value) {
        this.name = null;
        this.value = value;
        this.constant = true;
    }

    @Override
    public String toString(boolean symbolic) {
        if (symbolic && !this.constant) {
            return this.name;
        }
        return "" + this.value;
    }

    @Override
    public Double evaluate() {
        return new Double(this.value);
    }

    @Override
    public double evaluateDouble() {
        return this.value;
    }

    public double set(double value) {
        if (!this.constant) {
            this.value = value;
        }
        return value;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void clearUsage() {
        this.used = false;
    }

    @Override
    public void setUsage() {
        this.used = true;
    }

    @Override
    public void checkUsage() {
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }
}

