/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simplexml.create;

import chemaxon.clustering.tools.simplexml.create.NodeData;
import chemaxon.clustering.tools.simplexml.create.Printer;
import chemaxon.clustering.tools.simplexml.create.SimpleXMLNode;
import chemaxon.clustering.tools.simplexml.create.XMLNode;
import chemaxon.clustering.tools.simplexml.create.XMLNodeAdmin;

public class HTMLCreator {
    XMLNode root;
    XMLNode body;

    public HTMLCreator(String title, String css, Printer ps) {
        SimpleXMLNode root;
        this.root = root = new SimpleXMLNode("html", true);
        root.hintAttributesDone();
        SimpleXMLNode.Updater<Printer> updater = new SimpleXMLNode.Updater<Printer>(root, ps);
        updater.setClosedCallback(new XMLNodeAdmin.Pinger(){

            @Override
            public void ping() {
                HTMLCreator.this.closed();
            }
        });
        ps.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        updater.ping();
        SimpleXMLNode head = new SimpleXMLNode("head", true);
        head.hintAttributesDone();
        root.addChild(head);
        head.addChild(new NodeData(title, "title", false, false));
        if (css != null) {
            SimpleXMLNode cssl = new SimpleXMLNode("link", true);
            cssl.addAttribute("href", css);
            cssl.addAttribute("rel", "stylesheet");
            cssl.addAttribute("type", "text/css");
            cssl.hintAttributesDone();
            head.addChild(cssl);
            cssl.close();
        }
        head.close();
        this.body = new SimpleXMLNode("body", true);
        this.body.hintAttributesDone();
        root.addChild(this.body);
    }

    public void tag(String tag, String s) {
        this.body.addChild(new NodeData(s, tag, false, false));
    }

    public void p(String s) {
        this.tag("p", s);
    }

    public void text(String s) {
        this.body.addChild(new NodeData(s, null, false, false));
    }

    public void h1(String s) {
        this.tag("h1", s);
    }

    public void h2(String s) {
        this.tag("h2", s);
    }

    public TablePrinter table() {
        return this.table(HAlign.def);
    }

    public TablePrinter table(HAlign halign) {
        return this.table(halign, null);
    }

    public TablePrinter table(HAlign halign, String width) {
        final SimpleXMLNode table = new SimpleXMLNode("table", true);
        table.addAttribute("border", "0");
        switch (halign) {
            case center: {
                table.addAttribute("align", "center");
            }
        }
        if (width != null && width.length() > 0) {
            table.addAttribute("width", width);
        }
        table.hintAttributesDone();
        this.body.addChild(table);
        return new TablePrinter(){

            TableRow row(String n) {
                final SimpleXMLNode row = new SimpleXMLNode(n, true);
                row.hintAttributesDone();
                table.addChild(row);
                return new TableRow(){

                    @Override
                    public void cell(String c) {
                        row.addChild(new NodeData(c, "td", false, false));
                    }

                    public void cell(int colspan, int rowspan, HAlign halign, String tagname, String cl, String c) {
                        SimpleXMLNode cell = new SimpleXMLNode(tagname, false);
                        row.addChild(cell);
                        if (halign != null && halign != HAlign.def) {
                            String as = null;
                            switch (halign) {
                                case center: {
                                    as = "center";
                                    break;
                                }
                                case left: {
                                    as = "left";
                                    break;
                                }
                                case right: {
                                    as = "right";
                                }
                            }
                            cell.addAttribute("align", as);
                        }
                        if (cl != null) {
                            cell.addAttribute("id", cl);
                        }
                        if (rowspan > 1) {
                            cell.addAttribute("rowspan", "" + rowspan);
                        }
                        if (colspan > 1) {
                            cell.addAttribute("colspan", "" + colspan);
                        }
                        cell.hintAttributesDone();
                        cell.addChild(new NodeData(c == null ? "&nbsp;" : c, null, false, false));
                        cell.close();
                    }

                    @Override
                    public void cell(HAlign halign, String c) {
                        this.cell(1, 1, halign, "td", null, c);
                    }

                    @Override
                    public void hcell(HAlign halign, String c) {
                        this.cell(1, 1, halign, "th", null, c);
                    }

                    @Override
                    public void cell(int colspan, int rowspan, HAlign halign, String c) {
                        this.cell(colspan, rowspan, halign, "td", null, c);
                    }

                    @Override
                    public void hcell(int colspan, int rowspan, HAlign halign, String c) {
                        this.cell(colspan, rowspan, halign, "th", null, c);
                    }

                    @Override
                    public void ecell(int colspan, int rowspan, HAlign halign, String c) {
                        this.cell(colspan, rowspan, halign, "td", "nobg", c);
                    }

                    @Override
                    public void hcell(String c) {
                        row.addChild(new NodeData(c, "th", false, false));
                    }

                    @Override
                    public void close() {
                        row.close();
                    }
                };
            }

            @Override
            public void close() {
                table.close();
            }

            @Override
            public TableRow row() {
                return this.row("tr");
            }
        };
    }

    public void close() {
        this.root.close();
    }

    public void closed() {
    }

    public static enum HAlign {
        def,
        left,
        center,
        right;

    }

    public static interface TableRow {
        public void cell(String var1);

        public void cell(HAlign var1, String var2);

        public void cell(int var1, int var2, HAlign var3, String var4);

        public void ecell(int var1, int var2, HAlign var3, String var4);

        public void hcell(String var1);

        public void hcell(HAlign var1, String var2);

        public void hcell(int var1, int var2, HAlign var3, String var4);

        public void close();
    }

    public static interface TablePrinter {
        public TableRow row();

        public void close();
    }
}

