/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simplexml.create;

import chemaxon.clustering.tools.simplexml.create.Printer;
import chemaxon.clustering.tools.simplexml.create.XMLNode;
import chemaxon.clustering.tools.simplexml.create.XMLNodeAdmin;

public class NodeData<S extends Printer>
implements XMLNodeAdmin<S> {
    String data;
    String name;
    boolean cdata;
    boolean newline;
    S stream = null;
    String[] attrNames = null;
    String[] attrValues = null;

    public NodeData(String data, String name, boolean cdata, boolean newline) {
        if (name == null && data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.cdata = cdata;
        this.name = name;
        this.newline = newline;
    }

    public NodeData(String name, String[] attrNV) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.data = null;
        this.cdata = false;
        this.newline = true;
        if (attrNV != null) {
            this.attrNames = new String[attrNV.length / 2];
            this.attrValues = new String[this.attrNames.length];
            for (int i = 0; i < this.attrNames.length; ++i) {
                this.attrNames[i] = attrNV[2 * i];
                this.attrValues[i] = attrNV[2 * i + 1];
            }
        }
    }

    @Override
    public void addAttribute(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(XMLNode<S> child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void hintAttributesDone() {
    }

    @Override
    public void hintChildsDone() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "***UNNAMED***";
    }

    @Override
    public void setStream(S stream) {
        this.stream = stream;
    }

    @Override
    public void setPinger(XMLNodeAdmin.Pinger pinger) {
    }

    @Override
    public XMLNodeAdmin.updateState writeStream() {
        if (this.data == null && this.name == null) {
            throw new UnsupportedOperationException();
        }
        if (this.newline) {
            this.stream.println();
        }
        if (this.name != null) {
            this.stream.print('<');
            this.stream.print(this.name);
            if (this.attrNames != null) {
                for (int i = 0; i < this.attrNames.length; ++i) {
                    this.stream.print(' ');
                    this.stream.print(this.attrNames[i]);
                    this.stream.print('=');
                    this.stream.print('\"');
                    this.stream.print(this.attrValues[i]);
                    this.stream.print('\"');
                }
            }
            if (this.data == null) {
                this.stream.print("/>");
            } else {
                this.stream.print('>');
            }
        }
        if (this.data != null) {
            if (this.cdata) {
                this.stream.print("<![CDATA[");
            }
            this.stream.print(this.data);
            if (this.cdata) {
                this.stream.print("]]>");
            }
        }
        if (this.name != null && this.data != null) {
            this.stream.print("</");
            this.stream.print(this.name);
            this.stream.print('>');
        }
        this.data = null;
        return XMLNodeAdmin.updateState.writeFinished;
    }

    @Override
    public XMLNodeAdmin<S> getNextChild() {
        throw new UnsupportedOperationException();
    }
}

