/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.tools.simplexml.parse;

import chemaxon.clustering.tools.simplexml.parse.Callback;
import chemaxon.clustering.tools.simplexml.parse.SimpleNodeImpl;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleParser {
    Log log = LogFactory.getLog(SimpleParser.class);
    Vector<SimpleNodeImpl> path = new Vector();
    Callback callback;
    readstate state = readstate.start;
    StringBuffer buf = new StringBuffer();
    String attrname;
    String errmsg;

    private void error(String msg) {
        this.errmsg = msg;
        this.state = readstate.error;
        this.callback.error(msg);
    }

    public SimpleParser(Callback callback) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Constructed");
        }
        this.callback = callback;
    }

    private void charRead(char c) {
        if (this.state == readstate.error) {
            return;
        }
        switch (this.state) {
            case start: {
                if (c == '<') {
                    this.state = readstate.tagnameparsing;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.path.isEmpty()) {
                    if (Character.isWhitespace(c)) break;
                    this.error("Invalid character " + c);
                    break;
                }
                this.path.lastElement().appendDataChar(c);
                break;
            }
            case tagnameparsing: {
                if (Character.isWhitespace(c)) {
                    SimpleNodeImpl sn = new SimpleNodeImpl(this.buf.toString());
                    this.path.add(sn);
                    this.state = readstate.tagparsing;
                    break;
                }
                if (c == '>') {
                    String s = this.buf.toString();
                    if (s.charAt(0) == '/') {
                        if (this.path.size() == 0) {
                            this.error("Unexpected closing tag: s");
                            break;
                        }
                        if (!s.equals("/" + this.path.lastElement().getName())) {
                            this.error("Closing tag name mismatch: " + s + " expecting " + this.path.lastElement().getName());
                            break;
                        }
                        this.callback.nodeClosed(this.path.lastElement(), this.path.size() > 1 ? this.path.get(this.path.size() - 2) : null);
                        this.path.remove(this.path.size() - 1);
                        this.state = readstate.start;
                        break;
                    }
                    if (s.endsWith("/")) {
                        SimpleNodeImpl sn = new SimpleNodeImpl(s.substring(0, s.length() - 1));
                        this.callback.nodeOpened(sn, this.path.isEmpty() ? null : this.path.lastElement());
                        this.callback.nodeClosed(sn, this.path.isEmpty() ? null : this.path.lastElement());
                        this.state = readstate.start;
                        break;
                    }
                    SimpleNodeImpl sn = new SimpleNodeImpl(s);
                    this.path.add(sn);
                    this.callback.nodeOpened(sn, this.path.size() == 1 ? null : this.path.lastElement());
                    this.state = readstate.start;
                    break;
                }
                this.buf.append(c);
                if (this.buf.length() != 3 || !this.buf.toString().equals("!--")) break;
                this.state = readstate.commentparsing0;
                break;
            }
            case commentparsing0: {
                if (c != '-') break;
                this.state = readstate.commentparsing1;
                break;
            }
            case commentparsing1: {
                if (c == '-') {
                    this.state = readstate.commentparsing2;
                    break;
                }
                this.state = readstate.commentparsing0;
                break;
            }
            case commentparsing2: {
                if (c == '>') {
                    this.state = readstate.start;
                    break;
                }
                if (c == '-') break;
                this.state = readstate.commentparsing0;
                break;
            }
            default: {
                throw new UnsupportedOperationException("State: " + this.state.toString());
            }
        }
    }

    public void nlRead() {
        if (this.state == readstate.error) {
            return;
        }
        this.charRead(' ');
    }

    public void eof() {
        if (this.state == readstate.error) {
            return;
        }
    }

    public void lineRead(String line) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Line read: " + line));
        }
        if (this.state == readstate.error) {
            return;
        }
        for (int i = 0; i < line.length(); ++i) {
            this.charRead(line.charAt(i));
        }
        this.nlRead();
    }

    static enum readstate {
        error,
        start,
        commentparsing0,
        commentparsing1,
        commentparsing2,
        tagnameparsing,
        tagparsing,
        shortcloseparsing,
        closetagnameparsing,
        attrnameparsing,
        attrvalueparsing;

    }
}

