/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.clustering.util.IntPermutation;
import chemaxon.marvin.modelling.util.U;

public class IntPermutationImpl
implements IntPermutation {
    private int[] from2to = null;
    private int[] to2from = null;
    private static IntPermutation identityMapping = null;

    public IntPermutationImpl(int maxKeyValue) {
        this.from2to = new int[maxKeyValue + 1];
        this.to2from = new int[maxKeyValue + 1];
        U.fill(this.from2to, -1);
        U.fill(this.to2from, -1);
    }

    public IntPermutationImpl(int[] fromValues, int[] toValues) {
        this(Math.max(U.max(fromValues), U.max(toValues)));
        if (fromValues.length != toValues.length) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < fromValues.length; ++i) {
            this.add(fromValues[i], toValues[i]);
        }
    }

    public IntPermutationImpl() {
        this(10);
    }

    private int[] realloc(int[] arr, int length) {
        int[] ret = new int[length];
        System.arraycopy(arr, 0, ret, 0, arr.length);
        for (int i = arr.length; i < ret.length; ++i) {
            ret[i] = -1;
        }
        return ret;
    }

    private void ensureKeyValue(int value) {
        if (this.from2to.length <= value) {
            this.from2to = this.realloc(this.from2to, value + 1);
            this.to2from = this.realloc(this.to2from, value + 1);
        }
    }

    @Override
    public boolean canAdd(int from, int to) {
        if (this.getFrom(to) != -1 && this.getFrom(to) != from) {
            return false;
        }
        return this.getTo(from) == -1 || this.getTo(from) == to;
    }

    @Override
    public void add(int from, int to) {
        this.ensureKeyValue(Math.max(to, from));
        if (this.to2from[to] != -1 || this.from2to[from] != -1) {
            throw new IndexOutOfBoundsException();
        }
        this.to2from[to] = from;
        this.from2to[from] = to;
    }

    @Override
    public int getTo(int from) {
        if (from >= this.from2to.length) {
            return -1;
        }
        return this.from2to[from];
    }

    @Override
    public int getFrom(int to) {
        if (to >= this.to2from.length) {
            return -1;
        }
        return this.to2from[to];
    }

    @Override
    public void add(int[] from, int[] to) {
        if (from.length != to.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureKeyValue(Math.max(U.max(from), U.max(to)));
        for (int i = 0; i < from.length; ++i) {
            this.add(from[i], to[i]);
        }
    }

    @Override
    public boolean canAdd(int[] from, int[] to) {
        if (from.length != to.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < from.length; ++i) {
            if (this.canAdd(from[i], to[i])) continue;
            return false;
        }
        return !U.hasCommon(from) && !U.hasCommon(to);
    }

    public static IntPermutation getUniversalIdentityMapping() {
        if (identityMapping == null) {
            identityMapping = new IntPermutation(){

                @Override
                public void add(int from, int to) {
                    if (from != to) {
                        throw new UnsupportedOperationException();
                    }
                }

                @Override
                public int getTo(int from) {
                    return from;
                }

                @Override
                public int getFrom(int to) {
                    return to;
                }

                @Override
                public boolean canAdd(int from, int to) {
                    return from == to;
                }

                @Override
                public void add(int[] from, int[] to) {
                    if (!U.equals(from, to)) {
                        throw new UnsupportedOperationException();
                    }
                }

                @Override
                public boolean canAdd(int[] from, int[] to) {
                    if (from.length != to.length) {
                        throw new UnsupportedOperationException();
                    }
                    return U.equals(from, to);
                }
            };
        }
        return identityMapping;
    }

    public static IntPermutation checkIdentityMapping(int[] fromValues, int[] toValues) {
        if (U.equals(fromValues, toValues)) {
            return IntPermutationImpl.getUniversalIdentityMapping();
        }
        return new IntPermutationImpl(fromValues, toValues);
    }
}

