/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.clustering.util.IntegerIterator;
import chemaxon.clustering.util.IntegerSet;
import chemaxon.marvin.modelling.util.U;
import java.util.ConcurrentModificationException;

public class SimpleIntegerSet
implements IntegerSet {
    public int[] storage = null;
    private static final int IDX_SIZE = 0;
    private static final int IDX_MODCC = 1;
    private static final int IDX_FIRSTITEM = 2;

    public SimpleIntegerSet() {
    }

    public SimpleIntegerSet(int initialSize, int initialRange) {
        this();
        this.ensureCapacity(initialSize, initialRange);
    }

    @Override
    public int size() {
        if (this.storage == null) {
            return 0;
        }
        return this.storage[0];
    }

    private int getCC() {
        if (this.storage == null) {
            return -1;
        }
        return this.storage[1];
    }

    private int incCC() {
        if (this.storage == null) {
            throw new NullPointerException();
        }
        this.storage[1] = this.storage[1] + 1;
        return this.storage[1];
    }

    @Override
    public void add(int value) {
        this.ensureCapacity(1, value);
        int n = this.storage[0];
        this.storage[0] = n + 1;
        this.storage[2 + n] = value;
        this.incCC();
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.storage[index + 2];
    }

    @Override
    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public void removeElementAt(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.storage, index + 2 + 1, this.storage, index + 2, this.size() - index - 1);
        this.storage[0] = this.storage[0] - 1;
        this.incCC();
    }

    @Override
    public boolean remove(int value) {
        int idx = this.indexOf(value);
        if (idx < 0) {
            return false;
        }
        this.removeElementAt(idx);
        return true;
    }

    @Override
    public int removeFirst() {
        int ret = this.get(0);
        this.removeElementAt(0);
        return ret;
    }

    @Override
    public int removeLast() {
        int ret = this.get(this.size() - 1);
        this.removeElementAt(this.size() - 1);
        return ret;
    }

    @Override
    public IntegerIterator iterator() {
        return new IntegerIterator(){
            int lastRetIndex = -1;
            int nextToRet = 0;
            int cc = SimpleIntegerSet.access$000(SimpleIntegerSet.this);

            private void checkCC() {
                if (SimpleIntegerSet.this.getCC() != this.cc) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public int nextInteger() {
                this.checkCC();
                if (this.nextToRet >= SimpleIntegerSet.this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                this.lastRetIndex = this.nextToRet;
                return SimpleIntegerSet.this.get(this.nextToRet++);
            }

            @Override
            public boolean hasNext() {
                this.checkCC();
                return this.nextToRet < SimpleIntegerSet.this.size();
            }

            @Override
            public void remove() {
                this.checkCC();
                if (this.lastRetIndex == -1) {
                    throw new IndexOutOfBoundsException();
                }
                SimpleIntegerSet.this.removeElementAt(this.lastRetIndex);
                --this.nextToRet;
                this.lastRetIndex = -1;
            }

            @Override
            public Integer next() {
                this.checkCC();
                return new Integer(this.nextInteger());
            }
        };
    }

    @Override
    public int indexOf(int value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.storage[i + 2] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int[] toIntArray() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public String dump() {
        if (this.storage == null) {
            return "Storage: null";
        }
        return "Storage: " + U.sel(this.storage);
    }

    @Override
    public void addInterval(int lowest, int highest) {
        int i;
        this.incCC();
        if (lowest > highest) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(highest - lowest + 1, highest);
        for (i = 0; i < this.size(); ++i) {
            int xi = this.get(i);
            if (xi < lowest || xi > highest) continue;
            throw new UnsupportedOperationException();
        }
        i = lowest;
        while (i <= highest) {
            int n = this.storage[0];
            this.storage[0] = n + 1;
            this.storage[2 + n] = i++;
        }
    }

    @Override
    public void ensureCapacity(int itemCount, int itemRange) {
        if (this.storage == null) {
            this.storage = new int[Math.max(5, itemCount) + 2];
        }
        if (this.storage.length - 2 <= this.storage[0] + itemCount) {
            int newItemCount = Math.max(10, itemCount);
            int newLengthC1 = this.storage[0] + 2 + newItemCount;
            int newLengthC2 = (int)((double)this.storage.length * 1.1);
            int newLength = Math.max(newLengthC1, newLengthC2);
            int[] news = new int[newLength];
            System.arraycopy(this.storage, 0, news, 0, this.storage.length);
            this.storage = news;
        }
    }

    @Override
    public int max() {
        if (this.size() == 0) {
            return 0;
        }
        int ret = this.get(0);
        for (int i = 1; i < this.size(); ++i) {
            if (this.get(i) <= ret) continue;
            ret = this.get(i);
        }
        return ret;
    }

    @Override
    public void removeAll() {
        this.incCC();
        if (this.storage == null) {
            return;
        }
        this.storage[0] = 0;
    }
}

