/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.clustering.util;

import chemaxon.calculations.clean.Optimization;
import chemaxon.clustering.util.Comparator;
import chemaxon.clustering.util.IterateAccess;
import chemaxon.clustering.util.RAIterator;
import java.util.ConcurrentModificationException;
import java.util.Vector;

public class SimpleRAIterateAccess<E>
implements RAIterator<E> {
    IterateAccess<E> base;
    int ccexp;
    Vector<E> cache = null;
    E nextE = null;
    boolean lastReached = false;
    int i = -1;
    int rc = 0;

    public SimpleRAIterateAccess(IterateAccess<E> base, final Comparator<E> comp) {
        this.base = base;
        this.ccexp = base.getCC();
        if (comp != null && this.size() > 0) {
            final Vector<E> cf = this.cache;
            Optimization.quickSort(0, cf.size() - 1, new Optimization.Sortable(){

                @Override
                public boolean isGreater(int i, int j) {
                    return comp.isGreater(cf.get(i), cf.get(j));
                }

                @Override
                public void swap(int i, int j) {
                    Object tmp = cf.get(i);
                    cf.setElementAt(cf.get(j), i);
                    cf.setElementAt(tmp, j);
                }
            });
        }
    }

    public SimpleRAIterateAccess(IterateAccess<E> base) {
        this(base, null);
    }

    void checkCC() {
        if (this.base.getCC() != this.ccexp) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void reset() {
        this.checkCC();
        if (this.i != -1) {
            this.i = 0;
        } else {
            this.base.reset();
            this.nextE = null;
            this.lastReached = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.checkCC();
        if (this.i != -1) {
            return this.i < this.cache.size();
        }
        if (this.lastReached) {
            return false;
        }
        if (this.nextE == null) {
            this.nextE = this.base.fetchNext();
        }
        if (this.nextE == null) {
            this.lastReached = true;
        }
        return this.nextE != null;
    }

    @Override
    public E next() {
        this.checkCC();
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.i != -1) {
            return this.cache.get(this.i++);
        }
        if (this.nextE == null) {
            throw new UnsupportedOperationException();
        }
        E ret = this.nextE;
        this.nextE = null;
        ++this.rc;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int size() {
        E n;
        this.checkCC();
        if (this.i != -1) {
            return this.cache.size();
        }
        this.base.reset();
        this.cache = new Vector();
        while ((n = this.base.fetchNext()) != null) {
            this.cache.add(n);
        }
        this.i = this.rc;
        return this.cache.size();
    }

    @Override
    public E get(int i) {
        this.checkCC();
        if (i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.cache.get(i);
    }

    @Override
    public int getCC() {
        this.checkCC();
        return this.base.getCC();
    }

    @Override
    public int indexOf(E e) {
        this.checkCC();
        int s = this.size();
        for (int ii = 0; ii < s; ++ii) {
            if (e != this.get(ii)) continue;
            return ii;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isGetSupported() {
        return true;
    }
}

