/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    private static final byte[] CHARS64 = new byte[64];
    private OutputStream outputStream;
    private byte[] bufferedInput = new byte[3];
    private byte[] bufferedOutput = new byte[4];
    private int bufferedInputCount = 0;
    private long encodedCharCount = 0L;
    private boolean breakLines = true;

    public Base64OutputStream(OutputStream os) {
        this(os, true);
    }

    public Base64OutputStream(OutputStream os, boolean bl) {
        this.outputStream = os;
        this.breakLines = bl;
    }

    public byte[] convertBase64(byte[] b, int l) {
        byte[] out = this.bufferedOutput;
        int b0 = b[0] & 0xFF;
        out[0] = CHARS64[b0 >> 2];
        if (l == 2) {
            int b1 = b[1] & 0xFF;
            out[1] = CHARS64[b0 << 4 & 0x30 | b1 >> 4 & 0xF];
            out[2] = CHARS64[b1 << 2 & 0x3C];
            out[3] = 61;
        } else if (l == 1) {
            out[1] = CHARS64[b0 << 4 & 0x30];
            out[2] = 61;
            out[3] = 61;
        } else {
            int b1 = b[1] & 0xFF;
            int b2 = b[2] & 0xFF;
            out[1] = CHARS64[b0 << 4 & 0x30 | b1 >> 4 & 0xF];
            out[2] = CHARS64[b1 << 2 & 0x3C | b2 >> 6 & 3];
            out[3] = CHARS64[b2 & 0x3F];
        }
        return out;
    }

    @Override
    public void write(int b) throws IOException {
        this.bufferedInput[this.bufferedInputCount++] = (byte)b;
        if (this.bufferedInputCount == 3) {
            byte[] out = this.bufferedOutput;
            int b0 = this.bufferedInput[0] & 0xFF;
            int b1 = this.bufferedInput[1] & 0xFF;
            int b2 = this.bufferedInput[2] & 0xFF;
            out[0] = CHARS64[b0 >> 2];
            out[1] = CHARS64[b0 << 4 & 0x30 | b1 >> 4 & 0xF];
            out[2] = CHARS64[b1 << 2 & 0x3C | b2 >> 6 & 3];
            out[3] = CHARS64[b2 & 0x3F];
            this.outputStream.write(out);
            this.bufferedInputCount = 0;
            this.encodedCharCount += 4L;
            if (this.breakLines && this.encodedCharCount % 76L == 0L) {
                this.outputStream.write(10);
            }
        }
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.bufferedInputCount > 0) {
            this.write(data[off++]);
            --len;
            if (this.bufferedInputCount == 2) {
                if (len == 0) {
                    return;
                }
                this.write(data[off++]);
                --len;
            }
        }
        if (len == 0) {
            return;
        }
        int ni0 = 3 * (len / 3);
        int nout = 4 * (len / 3);
        if (this.breakLines) {
            nout = (int)((long)nout + ((this.encodedCharCount + (long)nout) / 76L - this.encodedCharCount / 76L));
        }
        byte[] out = this.convertBase64(off, data, ni0, nout, this.breakLines);
        this.outputStream.write(out);
        if (len == ni0 + 2) {
            this.write(data[off + ni0]);
            this.write(data[off + ni0 + 1]);
        } else if (len == ni0 + 1) {
            this.write(data[off + ni0]);
        }
    }

    @Override
    public void close() throws IOException {
        byte[] out = this.bufferedOutput;
        if (this.bufferedInputCount == 2) {
            out = this.convertBase64(this.bufferedInput, this.bufferedInputCount);
            this.bufferedInputCount = 0;
            this.outputStream.write(out);
            if (this.breakLines) {
                this.outputStream.write(10);
            }
        } else if (this.bufferedInputCount == 1) {
            out = this.convertBase64(this.bufferedInput, this.bufferedInputCount);
            this.bufferedInputCount = 0;
            this.outputStream.write(out);
            if (this.breakLines) {
                this.outputStream.write(10);
            }
        } else if (this.breakLines && this.encodedCharCount % 76L != 0L) {
            this.outputStream.write(10);
        }
    }

    public byte[] convertBase64(int off, byte[] data, int ni0, int nout, boolean newline) {
        byte[] out = new byte[nout];
        int j = 0;
        for (int i = 0; i < ni0; i += 3) {
            int b0 = data[off + i] & 0xFF;
            int b1 = data[off + i + 1] & 0xFF;
            int b2 = data[off + i + 2] & 0xFF;
            out[j++] = CHARS64[b0 >> 2];
            out[j++] = CHARS64[b0 << 4 & 0x30 | b1 >> 4 & 0xF];
            out[j++] = CHARS64[b1 << 2 & 0x3C | b2 >> 6 & 3];
            out[j++] = CHARS64[b2 & 0x3F];
            this.encodedCharCount += 4L;
            if (!newline || this.encodedCharCount % 76L != 0L) continue;
            out[j++] = 10;
        }
        return out;
    }

    static {
        String s = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        for (int i = 0; i < 64; ++i) {
            Base64OutputStream.CHARS64[i] = (byte)s.charAt(i);
        }
    }
}

