/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class BasicEnvironment {
    public static final boolean LINUX;
    public static final boolean MACOS;
    public static final boolean MSWINDOWS;
    public static final boolean UNTRUSTED;
    public static final boolean APPLET;
    public static final boolean LIKELY_COMMAND_LINE;
    public static final boolean JAVAWEBSTART;
    public static final boolean JAVA14_COMPATIBLE;
    public static final boolean JAVA142_COMPATIBLE;
    public static final boolean JAVA15_COMPATIBLE;
    public static final boolean JAVA16_COMPATIBLE;
    public static final boolean IMAGECOPY_ENABLED;
    protected static URL codeBase;
    protected static boolean safariOnMac;

    public static InputStream getResourceAsStream(Class<?> cl, String filename, boolean ignoreCache) {
        InputStream resource;
        try {
            resource = cl.getResourceAsStream(filename);
        }
        catch (Exception ex) {
            resource = null;
        }
        if (resource == null && codeBase != null) {
            try {
                URL url = new URL(codeBase, filename.charAt(0) != '/' ? filename : filename.substring(1));
                URLConnection conn = url.openConnection();
                conn.setUseCaches(!ignoreCache);
                resource = conn.getInputStream();
            }
            catch (Exception e) {
                resource = null;
            }
        }
        return resource;
    }

    public static InputStream getResourceAsStream(Class<?> cl, String filename) {
        return BasicEnvironment.getResourceAsStream(cl, filename, false);
    }

    protected static boolean checkCommandLine() {
        try {
            String home = System.getProperty("user.home");
            String cwd = System.getProperty("user.dir");
            if (home == null || cwd == null || home.equals(cwd)) {
                return false;
            }
            String shell = System.getenv("SHELL");
            if (shell == null) {
                return false;
            }
            if (shell.equals("/bin/sh")) {
                return false;
            }
            if (!MACOS || MACOS && System.getenv("TERM") != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSafariOnMac() {
        return MACOS && APPLET && safariOnMac;
    }

    static {
        codeBase = null;
        safariOnMac = false;
        String os = System.getProperty("os.name");
        LINUX = os.startsWith("Linux");
        MACOS = os.startsWith("Mac OS");
        MSWINDOWS = os.startsWith("Windows");
        boolean b = false;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertyAccess("user.home");
            }
        }
        catch (Throwable thw) {
            b = true;
        }
        UNTRUSTED = b;
        if (UNTRUSTED) {
            b = true;
        } else {
            b = false;
            String s = System.getProperty("os.name.applet");
            if (s != null && s.equals("true")) {
                b = true;
            }
        }
        APPLET = b;
        b = false;
        if (!APPLET) {
            try {
                b = System.getProperty("deployment.javaws.version") != null || System.getProperty("javawebstart.version") != null;
            }
            catch (Throwable thw) {
                // empty catch block
            }
        }
        JAVAWEBSTART = b;
        String jver = System.getProperty("java.version");
        JAVA14_COMPATIBLE = !jver.startsWith("1.3") && !jver.startsWith("1.2") && !jver.startsWith("1.1") && !jver.startsWith("1.0");
        JAVA142_COMPATIBLE = JAVA14_COMPATIBLE && !jver.startsWith("1.4.1");
        JAVA15_COMPATIBLE = JAVA142_COMPATIBLE && !jver.startsWith("1.4");
        JAVA16_COMPATIBLE = JAVA15_COMPATIBLE && !jver.startsWith("1.5");
        IMAGECOPY_ENABLED = JAVA14_COMPATIBLE && !UNTRUSTED;
        LIKELY_COMMAND_LINE = BasicEnvironment.checkCommandLine();
    }
}

