/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import java.io.Serializable;
import java.util.NoSuchElementException;

public final class DoubleVector
implements Cloneable,
Serializable {
    public double[] elementData;
    private int expectedElementCount = 0;
    protected int elementCount;
    protected int capacityIncrement;

    public DoubleVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new double[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public DoubleVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public DoubleVector() {
        this(10);
    }

    public DoubleVector(double[] anArray) {
        this(anArray.length);
        System.arraycopy(anArray, 0, this.elementData, 0, anArray.length);
        this.elementCount = anArray.length;
    }

    public final void copyInto(double[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final double[] toArray() {
        double[] anArray = new double[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            double[] oldData = this.elementData;
            this.elementData = new double[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    public void setExpectedSize(int size) {
        this.expectedElementCount = size;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        double[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 3 / 2 + 1;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (this.expectedElementCount > 0 && newCapacity > this.expectedElementCount && minCapacity <= this.expectedElementCount) {
            newCapacity = this.expectedElementCount;
        }
        this.elementData = new double[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0.0;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(double elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(double elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(double elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(double elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(double elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final double elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final double firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final double lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(double obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
    }

    public final void insertElementAt(double obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final void addElement(double obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public final void addElements(double[] array) {
        this.addElements(array, 0, array.length);
    }

    public final void addElements(double[] array, int offset, int length) {
        int srcEnd = Math.min(offset + length, array.length);
        int numOfAdded = srcEnd - offset;
        int newLength = numOfAdded + this.elementCount;
        this.ensureCapacity(newLength);
        System.arraycopy(array, offset, this.elementData, this.elementCount, numOfAdded);
        this.elementCount = newLength;
    }

    public final boolean removeElement(double obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        this.elementCount = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        DoubleVector v = (DoubleVector)super.clone();
        v.elementData = new double[this.elementCount];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
        return v;
    }

    public boolean addAll(DoubleVector other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        this.addElements(other.elementData, 0, other.elementCount);
        return true;
    }

    public void fill(int value) {
        for (int x = 0; x < this.elementCount; ++x) {
            this.elementData[x] = value;
        }
    }

    public void sort() {
        if (this.elementCount > 1) {
            DoubleVector.sort1(this.elementData, 0, this.elementCount);
        }
    }

    private static void sort1(double[] x, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    DoubleVector.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = DoubleVector.med3(x, l, l + s, l + 2 * s);
                m = DoubleVector.med3(x, m - s, m, m + s);
                n = DoubleVector.med3(x, n - 2 * s, n - s, n);
            }
            m = DoubleVector.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    DoubleVector.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    DoubleVector.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleVector.swap(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        DoubleVector.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        DoubleVector.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            DoubleVector.sort1(x, off, s);
        }
        if ((s = d - c) > 1) {
            DoubleVector.sort1(x, n - s, s);
        }
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecswap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            DoubleVector.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }
}

