/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import chemaxon.common.util.IntSet;
import java.util.Arrays;

public class IntArrayIntSet
implements IntSet {
    private static final int SEARCH_LIMIT = 8;
    private static final int INITIAL_CAPACITY = 10;
    private int capacity;
    private int[] data;
    private int size;
    private boolean sorted;

    public IntArrayIntSet() {
        this(10);
    }

    public IntArrayIntSet(int initialCapacity) {
        this.capacity = initialCapacity;
        this.data = new int[this.capacity];
        this.size = 0;
        this.sorted = false;
    }

    public void ensureCapacity(int capacity) {
        if (this.capacity < capacity) {
            this.ensureCapacityHelper(capacity);
        }
    }

    private void ensureCapacityHelper(int newCapacity) {
        assert (this.size <= newCapacity);
        if (this.size > 0) {
            int[] newData = new int[newCapacity];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
            this.capacity = newCapacity;
        } else {
            this.capacity = newCapacity;
            this.data = new int[this.capacity];
            this.sorted = false;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int value) {
        if (this.capacity == this.size) {
            this.ensureCapacityHelper(this.calculateNewCapacity(this.capacity));
        }
        this.data[this.size++] = value;
        if (this.size == 1) {
            this.sorted = true;
        } else if (this.data[this.size - 2] > value) {
            this.sorted = false;
        }
    }

    private int calculateNewCapacity(int capacity) {
        return capacity * 3 / 2 + 1;
    }

    @Override
    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    private int indexOf(int value) {
        if (this.size >= 8 && this.sorted) {
            return Arrays.binarySearch(this.data, 0, this.size, value);
        }
        return this.indexOfLinear(value);
    }

    private int indexOfLinear(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove(int value) {
        int pos = this.indexOf(value);
        if (pos >= 0) {
            if (pos + 1 < this.size) {
                System.arraycopy(this.data, pos + 1, this.data, pos, this.size - pos - 1);
            }
            --this.size;
        }
    }

    public void compact() {
        if (this.calculateNewCapacity(this.size) < this.capacity) {
            this.ensureCapacityHelper(this.calculateNewCapacity(this.size));
        }
        if (this.size >= 8 && !this.sorted) {
            Arrays.sort(this.data, 0, this.size);
            this.sorted = true;
        }
    }

    @Override
    public int[] toArray() {
        int[] elements = new int[this.size];
        System.arraycopy(this.data, 0, elements, 0, this.size);
        return elements;
    }
}

