/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.FloatVector;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class IntVector
implements Cloneable,
Serializable {
    public int[] elementData;
    private int expectedElementCount = 0;
    protected int elementCount;
    protected int capacityIncrement;

    public IntVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public IntVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntVector() {
        this(10);
    }

    public IntVector(int[] anArray) {
        this(anArray.length);
        System.arraycopy(anArray, 0, this.elementData, 0, anArray.length);
        this.elementCount = anArray.length;
    }

    public final void copyInto(int[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public final int[] toArray() {
        int[] anArray = new int[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public final void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            int[] oldData = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    public void setExpectedSize(int size) {
        this.expectedElementCount = size;
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        int[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 3 / 2 + 1;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        if (this.expectedElementCount > 0 && newCapacity > this.expectedElementCount && minCapacity <= this.expectedElementCount) {
            newCapacity = this.expectedElementCount;
        }
        this.elementData = new int[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOfWithBinarySearch(int num) {
        int idx = ArrayTools.binarySearch(this.elementData, num, 0, this.elementCount - 1);
        return idx >= 0 ? idx : -1;
    }

    public final int indexOf(int elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final int lastIndexOf(int elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int get(int index) {
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.format("%d index is invalid, element count is %d ", index, this.elementCount));
        }
    }

    public final void set(int index, int v) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = v;
    }

    public final void add(int v) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = v;
    }

    public final void add(int index, int v) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = v;
        ++this.elementCount;
    }

    public boolean addAll(IntVector other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        this.addElements(other.elementData, 0, other.elementCount);
        return true;
    }

    public final int remove(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int old = this.elementData[index];
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        return old;
    }

    public final int removeLast() {
        return this.remove(this.elementCount - 1);
    }

    public final void clear() {
        this.elementCount = 0;
    }

    public final int elementAt(int index) {
        return this.get(index);
    }

    public final int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final void setElementAt(int v, int index) {
        this.set(index, v);
    }

    public final void removeElementAt(int index) {
        this.remove(index);
    }

    public final void insertElementAt(int v, int index) {
        this.add(index, v);
    }

    public final void addElement(int v) {
        this.add(v);
    }

    public final void addElements(int[] array) {
        this.addElements(array, 0, array.length);
    }

    public final void addElements(int[] array, int offset, int length) {
        int srcEnd = Math.min(offset + length, array.length);
        int numOfAdded = srcEnd - offset;
        int newLength = numOfAdded + this.elementCount;
        this.ensureCapacity(newLength);
        System.arraycopy(array, offset, this.elementData, this.elementCount, numOfAdded);
        this.elementCount = newLength;
    }

    public final boolean removeElement(int obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        this.clear();
    }

    public Object clone() {
        return this.cloneIntVector();
    }

    public IntVector cloneIntVector() {
        IntVector v;
        try {
            v = (IntVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        v.elementData = new int[this.elementCount];
        System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
        return v;
    }

    public void fill(int value) {
        for (int x = 0; x < this.elementCount; ++x) {
            this.elementData[x] = value;
        }
    }

    public int count(int value) {
        int res = 0;
        int i = this.elementCount;
        while (--i >= 0) {
            if (this.elementData[i] != value) continue;
            ++res;
        }
        return res;
    }

    public boolean hasSeveralValues() {
        if (this.elementCount == 0) {
            return false;
        }
        int firstValue = this.elementData[0];
        for (int i = 1; i < this.elementCount; ++i) {
            if (this.elementData[i] == firstValue) continue;
            return true;
        }
        return false;
    }

    public void reverse() {
        int i = this.elementCount / 2;
        while (--i >= 0) {
            int j = this.elementCount - 1 - i;
            int tmp = this.elementData[j];
            this.elementData[j] = this.elementData[i];
            this.elementData[i] = tmp;
        }
    }

    public void sortWithFloatVector(FloatVector d) {
        if (d == null || this.elementCount != d.elementCount) {
            throw new IllegalArgumentException("Sort is impossible: double array is null or arrays have different size!");
        }
        if (this.elementCount > 1) {
            IntVector.sort1(this.elementData, 0, this.elementCount, d);
        }
    }

    public void sort() {
        if (this.elementCount > 1) {
            IntVector.sort1(this.elementData, 0, this.elementCount, null);
        }
    }

    private static void sort1(int[] x, int off, int len, FloatVector floatVector) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    IntVector.swap(x, j, j - 1, floatVector);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = IntVector.med3(x, l, l + s, l + 2 * s);
                m = IntVector.med3(x, m - s, m, m + s);
                n = IntVector.med3(x, n - 2 * s, n - s, n);
            }
            m = IntVector.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    IntVector.swap(x, a++, b, floatVector);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    IntVector.swap(x, c, d--, floatVector);
                }
                --c;
            }
            if (b > c) break;
            IntVector.swap(x, b++, c--, floatVector);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        IntVector.vecswap(x, off, b - s, s, floatVector);
        s = Math.min(d - c, n - d - 1);
        IntVector.vecswap(x, b, n - s, s, floatVector);
        s = b - a;
        if (s > 1) {
            IntVector.sort1(x, off, s, floatVector);
        }
        if ((s = d - c) > 1) {
            IntVector.sort1(x, n - s, s, floatVector);
        }
    }

    private static void swap(int[] x, int a, int b, FloatVector d) {
        IntVector.swap0(x, a, b);
        if (d != null) {
            IntVector.swap0(d, a, b);
        }
    }

    private static void swap0(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap0(FloatVector x, int a, int b) {
        float t = x.elementData[a];
        x.elementData[a] = x.elementData[b];
        x.elementData[b] = t;
    }

    private static void vecswap(int[] x, int a, int b, int n, FloatVector floatVector) {
        int i = 0;
        while (i < n) {
            IntVector.swap(x, a, b, floatVector);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.size() * 3);
        res.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                res.append(',');
            }
            res.append(this.get(i));
        }
        res.append(']');
        return res.toString();
    }
}

