/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.common.util.text;

public final class SimpleTeX {
    public static final int SUBSCRIPT = 1;
    public static final int SUPERSCRIPT = 2;
    public static final int SMALL = 4;
    public static final int ITALIC = 8;
    public static final int NL = 16;
    public static final int NL2 = 32;
    public static final int F_MDL = 1;
    public static final int NLMASK = 48;
    private static boolean[] CHAR_AFTER_SUP_CHARGE;
    private String[] data = new String[1];
    private int[] attrs = new int[1];
    private int length = 0;
    private int alignStringIndex;
    private int alignCharIndex;

    public SimpleTeX(String str) {
        this(str, -1);
    }

    public SimpleTeX(String str, int alignPos) {
        int n = str.length();
        char[] tmpchars = new char[n];
        int m = 0;
        int k = 0;
        int[] modestk = new int[256];
        int modestkptr = 0;
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                int nlflags = 16;
                if (i < str.length() - 1 && str.charAt(i + 1) == '\n') {
                    ++i;
                    nlflags |= 0x20;
                }
                this.add(new String(tmpchars, 0, k), m | nlflags);
                k = 0;
                continue;
            }
            if (c == '_' || c == '^') {
                int m2;
                if (k > 0) {
                    this.add(new String(tmpchars, 0, k), m);
                    k = 0;
                }
                int n2 = m2 = c == '_' ? 1 : 2;
                if (i + 1 == n) break;
                if (str.charAt(i + 1) == '{') {
                    modestk[++modestkptr] = m |= m2;
                    ++i;
                    continue;
                }
                k = this.addScript(i + 1, str, tmpchars, alignPos);
                i += k;
                this.add(new String(tmpchars, 0, k), m | m2);
                k = 0;
                continue;
            }
            if (c == '\\') {
                if (str.substring(i).startsWith("\\italic{")) {
                    if (k > 0) {
                        this.add(new String(tmpchars, 0, k), m);
                        k = 0;
                    }
                    i += 7;
                    modestk[++modestkptr] = m |= 8;
                    continue;
                }
                if (str.substring(i).startsWith("\\small{")) {
                    if (k > 0) {
                        this.add(new String(tmpchars, 0, k), m);
                        k = 0;
                    }
                    i += 6;
                    modestk[++modestkptr] = m |= 4;
                    continue;
                }
                if (i < str.length() - 1 && SimpleTeX.isEscapable(str.charAt(i + 1))) {
                    c = str.charAt(++i);
                }
            } else if (c == '}') {
                if (modestkptr == 0) {
                    throw new IllegalArgumentException("Closing brace ('}') without opening");
                }
                if (k > 0) {
                    this.add(new String(tmpchars, 0, k), m);
                    k = 0;
                }
                m = modestk[--modestkptr];
                continue;
            }
            if (alignPos >= 0 && i == alignPos) {
                this.alignStringIndex = this.length;
                this.alignCharIndex = k;
            }
            tmpchars[k++] = c;
        }
        if (k > 0) {
            this.add(new String(tmpchars, 0, k), m);
        }
        this.trim();
    }

    private int addScript(int i, String str, char[] tmpchars, int alignPos) {
        char c = str.charAt(i);
        boolean isdigit = c >= '0' && c <= '9';
        tmpchars[0] = c;
        int k = 1;
        if (i == alignPos) {
            this.alignStringIndex = this.length;
            this.alignCharIndex = 0;
        }
        if (SimpleTeX.isCharge(str, i)) {
            int end = SimpleTeX.indexOfChargeEnd(str, i);
            for (int j = i + 1; j < end; ++j) {
                char c1 = str.charAt(j);
                if (j == alignPos) {
                    this.alignStringIndex = this.length;
                    this.alignCharIndex = k;
                }
                tmpchars[k++] = c1;
            }
        } else {
            for (int j = i + 1; j < str.length(); ++j) {
                boolean isdigit1;
                char c1 = str.charAt(j);
                boolean bl = isdigit1 = c1 >= '0' && c1 <= '9';
                if (isdigit && !isdigit1 || !isdigit && isdigit1) {
                    return k;
                }
                if (j == alignPos) {
                    this.alignStringIndex = this.length;
                    this.alignCharIndex = k;
                }
                tmpchars[k++] = c1;
            }
        }
        return k;
    }

    public int getStringCount() {
        return this.length;
    }

    public String getString(int i) {
        return this.data[i];
    }

    public int getAttributes(int i) {
        return this.attrs[i];
    }

    public int getAlignStringIndex() {
        return this.alignStringIndex;
    }

    public int getAlignCharIndex() {
        return this.alignCharIndex;
    }

    public String convertToShort(int opts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            boolean previsdigit;
            String s = this.getString(i);
            char c = s.charAt(0);
            boolean isdigit = c >= '0' && c <= '9';
            int attr = this.getAttributes(i);
            String prevs = i > 0 ? this.getString(i - 1) : null;
            int prevattr = i > 0 ? this.getAttributes(i - 1) : 0;
            int c1 = prevs != null ? (int)prevs.charAt(prevs.length() - 1) : 0;
            boolean bl = previsdigit = c1 >= 48 && c1 <= 57;
            if ((attr & 1) != 0) {
                if ((prevattr & 1) == 0 && (!isdigit || previsdigit)) {
                    sb.append("\\s");
                }
                sb.append(s);
                continue;
            }
            if ((attr & 2) != 0) {
                boolean autocharge = false;
                if ((opts & 1) == 0) {
                    autocharge = this.isAutoSuperscriptedCharge(i);
                }
                if ((prevattr & 2) == 0 && !autocharge) {
                    sb.append("\\S");
                }
                sb.append(s);
                continue;
            }
            if ((opts & 1) == 0 && this.isAutoSuperscriptedCharge(i - 1)) {
                sb.append(s);
                continue;
            }
            if ((isdigit || !previsdigit && (prevattr & 3) != 0) && ((opts & 1) != 0 || i > 0)) {
                sb.append("\\n");
            }
            sb.append(s.charAt(0));
            for (int j = 1; j < s.length(); ++j) {
                c1 = s.charAt(j - 1);
                c = s.charAt(j);
                previsdigit = c1 >= 48 && c1 <= 57;
                boolean bl2 = isdigit = c >= '0' && c <= '9';
                if (isdigit && !previsdigit) {
                    sb.append("\\n");
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private boolean isAutoSuperscriptedCharge(int i) {
        char c2;
        if (i == -1) {
            return false;
        }
        String s = this.getString(i);
        if (!SimpleTeX.isCharge(s) || (this.getAttributes(i) & 2) == 0) {
            return false;
        }
        String prev = i > 0 ? this.getString(i - 1) : null;
        char prevc = prev != null ? prev.charAt(prev.length() - 1) : (char)'\u0000';
        char lastc = s.charAt(s.length() - 1);
        boolean previsdigit = prevc >= '0' && prevc <= '9';
        String next = i < this.length - 1 ? this.getString(i + 1) : null;
        char c = c2 = next != null ? next.charAt(0) : (char)'\u0000';
        return !previsdigit && (c2 >= '\u0000' && c2 < '\u0100' && CHAR_AFTER_SUP_CHARGE[c2] || lastc == '+' && c2 >= 'A' && c2 <= 'Z');
    }

    public static String convertTeX2Short(String str, int opts) {
        if (str == null) {
            return null;
        }
        SimpleTeX tex = new SimpleTeX(str);
        return tex.convertToShort(opts);
    }

    public static String convertShort2TeX(String str, int opts) {
        if (str == null) {
            return null;
        }
        boolean previsdigit = false;
        int prevcontrol = -1;
        StringBuffer sb = new StringBuffer();
        int currentmode = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean isdigit = c >= '0' && c <= '9';
            int control = -1;
            if (c == '\\' && i < str.length() - 1) {
                char c1 = str.charAt(i + 1);
                if (c1 == 'n') {
                    control = 0;
                    ++i;
                } else if (c1 == 's') {
                    control = 1;
                    ++i;
                } else if (c1 == 'S') {
                    control = 2;
                    ++i;
                } else if (SimpleTeX.isEscapable(c1)) {
                    c = c1;
                }
            }
            if (control != -1) {
                if (control == 0) {
                    if (currentmode != 0) {
                        sb.append("}");
                        currentmode = 0;
                    }
                } else if (control == 1) {
                    if (currentmode != 1) {
                        if (currentmode == 0) {
                            sb.append("_{");
                        } else if (currentmode == 2) {
                            sb.append("}_{");
                        }
                        currentmode = 1;
                    }
                } else if (control == 2 && currentmode != 2) {
                    if (currentmode == 0) {
                        sb.append("^{");
                    } else if (currentmode == 1) {
                        sb.append("}^{");
                    }
                    currentmode = 2;
                }
            } else if ((opts & 1) == 0 && SimpleTeX.isCharge(str, i) && prevcontrol == -1) {
                if ((currentmode & 2) == 0) {
                    sb.append("^{");
                    currentmode = 2;
                }
                SimpleTeX.addChar(sb, c);
                if (SimpleTeX.indexOfChargeEnd(str, i) == i + 1) {
                    sb.append("}");
                    currentmode = 0;
                }
                isdigit = false;
            } else if (isdigit && !previsdigit && prevcontrol == -1) {
                if ((opts & 1) == 0 && i == 0) {
                    SimpleTeX.addChar(sb, c);
                } else {
                    sb.append("_{");
                    SimpleTeX.addChar(sb, c);
                    currentmode = 1;
                }
            } else if (previsdigit && !isdigit && control == -1) {
                if (currentmode != 0) {
                    sb.append("}");
                    currentmode = 0;
                }
                SimpleTeX.addChar(sb, c);
            } else {
                SimpleTeX.addChar(sb, c);
            }
            previsdigit = isdigit;
            prevcontrol = control;
        }
        if (currentmode != 0) {
            sb.append('}');
        }
        return sb.toString();
    }

    private static boolean isCharge(String str) {
        if (str.equals("++") || str.equals("--")) {
            return true;
        }
        if (str.endsWith("-") || str.endsWith("+")) {
            for (int i = 0; i < str.length() - 1; ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isCharge(String str, int i) {
        return SimpleTeX.indexOfChargeEnd(str, i) > i;
    }

    private static int indexOfChargeEnd(String str, int index) {
        int i = index;
        char c = str.charAt(i);
        if ((c == '-' || c == '+') && i < str.length() - 1 && str.charAt(i + 1) == c) {
            c = str.charAt(++i);
        } else {
            while (c >= '0' && c <= '9' && i < str.length() - 1) {
                c = str.charAt(++i);
            }
        }
        char c2 = i + 1 < str.length() ? str.charAt(i + 1) : (char)'\u0000';
        return (c == '-' || c == '+') && (c2 >= '\u0000' && c2 < '\u0100' && CHAR_AFTER_SUP_CHARGE[c2] || c == '+' && str.charAt(i + 1) >= 'A' && str.charAt(i + 1) <= 'Z') ? i + 1 : -1;
    }

    private static boolean isEscapable(char c) {
        return c == '_' || c == '^' || c == '{' || c == '}';
    }

    private static void addChar(StringBuffer sb, char c) {
        if (SimpleTeX.isEscapable(c)) {
            sb.append('\\');
        }
        sb.append(c);
    }

    private void add(String s, int a) {
        if (this.length >= this.data.length) {
            int n = (this.length * 3 + 2) / 2;
            String[] tmps = new String[n];
            int[] tmpn = new int[n];
            System.arraycopy(this.data, 0, tmps, 0, this.length);
            System.arraycopy(this.attrs, 0, tmpn, 0, this.length);
            this.data = tmps;
            this.attrs = tmpn;
        }
        this.data[this.length] = s;
        this.attrs[this.length] = a;
        ++this.length;
    }

    private void trim() {
        if (this.length < this.data.length) {
            String[] tmps = new String[this.length];
            int[] tmpn = new int[this.length];
            System.arraycopy(this.data, 0, tmps, 0, this.length);
            System.arraycopy(this.attrs, 0, tmpn, 0, this.length);
            this.data = tmps;
            this.attrs = tmpn;
        }
    }

    static {
        boolean[] afterchg = new boolean[256];
        afterchg[0] = true;
        afterchg[125] = true;
        afterchg[9] = true;
        afterchg[32] = true;
        afterchg[13] = true;
        afterchg[10] = true;
        CHAR_AFTER_SUP_CHARGE = afterchg;
    }
}

