/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import chemaxon.config.MarvinFrame;
import chemaxon.config.struct.MolTextBox;
import chemaxon.marvin.beans.MViewPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class EditorPanel
extends JPanel
implements ActionListener {
    private Element schemaElement;
    private Element instanceEl;
    private Vector attributeObjs = new Vector();
    private Hashtable buttonTextHash = new Hashtable();

    public EditorPanel(Element schemaEl) {
        String name = schemaEl.attributeValue("name");
        Element instanceEl = DocumentHelper.createElement((String)name);
        List attList = this.getChildAttributes(schemaEl);
        this.schemaElement = schemaEl;
        this.setBackground(Color.white);
        this.setMinimumSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(600, 800));
        if (attList.size() == 0) {
            this.setLayout(new BorderLayout());
            JLabel msg = new JLabel("This section does not contain editable data.  Please select a subsection to continue");
            this.add((Component)msg, "North");
            return;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 10, 10, 10);
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridy = 0;
        JLabel lblTitle = new JLabel(name + " options", 0);
        this.add((Component)lblTitle, gbc);
        boolean needsViewer = false;
        gbc.insets = new Insets(5, 5, 2, 2);
        gbc.anchor = 18;
        for (int i = 0; i < attList.size(); ++i) {
            gbc.gridy = i + 1;
            String attName = ((Element)attList.get(i)).attributeValue("name");
            String attType = ((Element)attList.get(i)).attributeValue("type");
            AttGuiObject ago = new AttGuiObject(attName);
            this.attributeObjs.add(ago);
            JComponent cPane = this.makeControl((Element)attList.get(i), ago);
            if (cPane == null) continue;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.add((Component)new JLabel(attName), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            cPane.setBackground(Color.white);
            this.add((Component)cPane, gbc);
        }
        JPanel spaceFill = new JPanel();
        gbc.gridy = attList.size() + 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        spaceFill.setBackground(Color.white);
        this.add((Component)spaceFill, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.white);
        buttonPanel.setLayout(new FlowLayout(2));
        JButton btnOk = new JButton("OK");
        JButton btnCancel = new JButton("Cancel");
        btnOk.setActionCommand("okattribute");
        btnCancel.setActionCommand("cancelattribute");
        btnOk.addActionListener(this);
        btnCancel.addActionListener(this);
        buttonPanel.add(btnOk);
        buttonPanel.add(btnCancel);
        gbc.gridy = attList.size() + 2;
        gbc.fill = 2;
        gbc.weighty = 0.1;
        this.add((Component)buttonPanel, gbc);
    }

    public void setInstance(Element iEl) {
        this.instanceEl = iEl;
        for (int i = 0; i < this.attributeObjs.size(); ++i) {
            AttGuiObject ago = (AttGuiObject)this.attributeObjs.get(i);
            ago.setValue(iEl);
        }
    }

    private JComponent makeControl(Element att, AttGuiObject ago) {
        String name = att.attributeValue("name");
        String type = att.attributeValue("type");
        String defVal = att.attributeValue("default");
        String fixVal = att.attributeValue("fixed");
        if (type.equals("xsd:boolean")) {
            JRadioButton vrai = new JRadioButton("True");
            JRadioButton faux = new JRadioButton("False");
            vrai.setActionCommand("true");
            faux.setActionCommand("false");
            vrai.setBackground(Color.white);
            faux.setBackground(Color.white);
            ButtonGroup bool = new ButtonGroup();
            bool.add(vrai);
            bool.add(faux);
            ago.setComponent(bool);
            JPanel smallPane = new JPanel();
            smallPane.setLayout(new FlowLayout(0));
            smallPane.add(vrai);
            smallPane.add(faux);
            if (defVal != null) {
                if (defVal.equals("false")) {
                    faux.setSelected(true);
                } else {
                    vrai.setSelected(true);
                }
            } else if (fixVal != null) {
                if (fixVal.equals("false")) {
                    faux.setSelected(true);
                    vrai.setEnabled(false);
                    faux.setEnabled(false);
                } else if (fixVal.equals("true")) {
                    vrai.setSelected(true);
                    vrai.setEnabled(false);
                    faux.setEnabled(false);
                }
            } else {
                vrai.setSelected(true);
            }
            smallPane.setBackground(Color.white);
            return smallPane;
        }
        if (type.equals("xsd:string")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new BorderLayout());
            JTextField tf = new JTextField(25);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            ago.setComponent(tf);
            textPanel.add(tf);
            textPanel.setBackground(Color.white);
            return textPanel;
        }
        if (type.equals("xsd:decimal")) {
            JPanel decPanel = new JPanel();
            decPanel.setLayout(new BorderLayout());
            JTextField tf = new JTextField(10);
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            ago.setComponent(tf);
            decPanel.add((Component)tf, "West");
            decPanel.setBackground(Color.white);
            return decPanel;
        }
        if (type.equals("filename")) {
            JTextField tf = new JTextField(20);
            tf.setToolTipText("File Path must be absolute");
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            JPanel smallPane = new JPanel();
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("browse");
            smallPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(1, 1, 1, 5);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridy = 0;
            smallPane.add((Component)tf, gbc);
            gbc.insets = new Insets(1, 1, 1, 15);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            smallPane.add((Component)btnBrowse, gbc);
            smallPane.setBackground(Color.white);
            ago.setComponent(tf);
            this.buttonTextHash.put(btnBrowse, tf);
            return smallPane;
        }
        if (type.equals("filepath")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(0));
            JTextField tf = new JTextField(25);
            textPanel.add(tf);
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            textPanel.add(btnBrowse);
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("fpBrowse");
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            textPanel.setBackground(Color.white);
            ago.setComponent(tf);
            this.buttonTextHash.put(btnBrowse, tf);
            return textPanel;
        }
        if (type.equals("fileSelect")) {
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new FlowLayout(0));
            JTextField tf = new JTextField(25);
            textPanel.add(tf);
            JButton btnBrowse = new JButton("...");
            btnBrowse.setToolTipText("Browse file system");
            textPanel.add(btnBrowse);
            btnBrowse.addActionListener(this);
            btnBrowse.setActionCommand("browse");
            if (defVal != null) {
                tf.setText(defVal);
            }
            if (fixVal != null) {
                tf.setText(fixVal);
                tf.setEnabled(false);
            }
            textPanel.setBackground(Color.white);
            ago.setComponent(tf);
            this.buttonTextHash.put(btnBrowse, tf);
            return textPanel;
        }
        if (type.equals("smilesString")) {
            StructurePanel sPane = new StructurePanel();
            ago.setComponent(sPane);
            return sPane;
        }
        if (type.equals("actChoice")) {
            Element def = this.getDefinition((Node)this.schemaElement, type);
            Vector choices = this.createChoiceVector(def);
            JComboBox jc = new JComboBox(choices);
            if (defVal != null) {
                jc.setSelectedItem(defVal);
            }
            if (fixVal != null) {
                jc.setSelectedItem(fixVal);
                jc.setEnabled(false);
            }
            ago.setComponent(jc);
            return jc;
        }
        if (type.equals("optChoice")) {
            Element def = this.getDefinition((Node)this.schemaElement, type);
            Vector choices = this.createChoiceVector(def);
            JComboBox jc = new JComboBox(choices);
            ago.setComponent(jc);
            return jc;
        }
        if (type.equals("structure")) {
            StructurePanel sPane = new StructurePanel();
            ago.setComponent(sPane);
            return sPane;
        }
        Element def = this.getDefinition((Node)this.schemaElement, type);
        if (def == null) {
            JLabel typeL = new JLabel(type);
            ago.setComponent(null);
            return typeL;
        }
        Vector choices = this.createChoiceVector(def);
        JComboBox jc = new JComboBox(choices);
        ago.setComponent(jc);
        return jc;
    }

    private Element getDefinition(Node d, String type) {
        List defList = d.selectNodes("/xsd:schema/xsd:simpleType");
        for (int i = 0; i < defList.size(); ++i) {
            Element e = (Element)defList.get(i);
            if (!e.attributeValue("name").equals(type)) continue;
            return e;
        }
        return null;
    }

    private Vector createChoiceVector(Element e) {
        Vector<String> v = new Vector<String>();
        if (e == null) {
            return v;
        }
        Element detachedEl = e.createCopy();
        List choiceList = e.selectNodes(".//xsd:enumeration");
        for (int i = 0; i < choiceList.size(); ++i) {
            v.add(((Element)choiceList.get(i)).attributeValue("value"));
        }
        return v;
    }

    private List getChildAttributes(Element el) {
        Element firstChild;
        String firstType;
        List children = el.elements();
        children = !children.isEmpty() ? ((firstType = (firstChild = (Element)children.get(0)).getName()).equals("complexType") || firstType.equals("complexContent") ? this.getChildAttributes(firstChild) : (firstType.equals("attribute") || firstType.equals("sequence") ? el.elements("attribute") : this.getChildElements(firstChild))) : null;
        return children;
    }

    private List getChildElements(Element el) {
        List children = el.elements();
        if (!children.isEmpty()) {
            Element firstChild = (Element)children.get(0);
            String firstType = firstChild.getName();
            if (firstType.equals("element")) {
                children = el.elements("element");
                return children;
            }
            if (firstType.equals("attribute")) {
                return null;
            }
            children = this.getChildElements(firstChild);
            return children;
        }
        return null;
    }

    public Element getElement() {
        if (this.instanceEl == null) {
            this.instanceEl = DocumentHelper.createElement((String)this.schemaElement.attributeValue("name"));
        }
        return this.instanceEl;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String comm = ev.getActionCommand();
        if (comm.equals("browse")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            JFileChooser fc = new JFileChooser();
            String lastSavedFile = System.getProperty("lastFile");
            fc.setCurrentDirectory(new File(lastSavedFile));
            int ret = fc.showOpenDialog(this);
            if (ret == 0) {
                File file = fc.getSelectedFile();
                String filePath = file.getPath();
                tf.setText(filePath);
            }
        } else if (comm.equals("marvin")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            String smiles = tf.getText();
            MarvinFrame mf = new MarvinFrame(tf);
        } else if (comm.equals("fpBrowse")) {
            JButton b = (JButton)ev.getSource();
            JTextField tf = (JTextField)this.buttonTextHash.get(b);
            JFileChooser fc = new JFileChooser();
            String lastSavedFile = System.getProperty("lastFile");
            fc.setCurrentDirectory(new File(lastSavedFile));
            int ret = fc.showOpenDialog(this);
            if (ret == 0) {
                File file = fc.getSelectedFile();
                String filePath = file.getName();
                tf.setText(filePath);
            }
        } else if (comm.equals("okattribute")) {
            for (int i = 0; i < this.attributeObjs.size(); ++i) {
                AttGuiObject ago = (AttGuiObject)this.attributeObjs.get(i);
                Attribute at = ago.getAttribute(this.instanceEl);
            }
            JOptionPane.showMessageDialog(this, "Data saved.", "Data saved", 1);
        } else if (comm.equals("cancelattribute")) {
            this.removeAll();
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            JLabel msg = new JLabel("Edit cancelled.  No data has been changed/added, but the section has been added.");
            JLabel msg2 = new JLabel("You can remove the section by right-clicking and choosing 'Remove'");
            JPanel msgPane = new JPanel();
            msgPane.setLayout(new BoxLayout(msgPane, 1));
            msgPane.setBackground(Color.white);
            msgPane.add(msg);
            msgPane.add(msg2);
            this.add((Component)msgPane, "North");
            this.validate();
            this.repaint();
        }
    }

    public class StructurePanel
    extends JPanel
    implements KeyListener,
    WindowListener,
    ActionListener {
        private JTextField textBox;
        private MViewPane mPane;
        private MarvinFrame mFrame;

        public StructurePanel() {
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            JPanel inputPanel = new JPanel(new FlowLayout(0));
            inputPanel.setBackground(Color.white);
            this.textBox = new JTextField(20);
            this.textBox.addKeyListener(this);
            JButton btnFile = new JButton("Files");
            btnFile.setActionCommand("browse");
            btnFile.addActionListener(this);
            JButton btnMarv = new JButton("Marvin");
            btnMarv.setActionCommand("marvin");
            btnMarv.addActionListener(this);
            inputPanel.add(this.textBox);
            inputPanel.add(btnFile);
            inputPanel.add(btnMarv);
            this.add((Component)inputPanel, "North");
            this.mPane = new MViewPane();
            this.add((Component)this.mPane, "Center");
        }

        private void showMarvin() {
            String text = this.textBox.getText();
            text = text.trim();
            this.mPane.setM(0, text);
        }

        public void setText(String s) {
            this.textBox.setText(s);
            this.showMarvin();
        }

        public String getText() {
            return this.textBox.getText();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.showMarvin();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.setText(this.mFrame.getSmiles());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String comm = e.getActionCommand();
            if (comm.equals("browse")) {
                JFileChooser fc = new JFileChooser();
                String lastSavedFile = System.getProperty("lastFile");
                fc.setCurrentDirectory(new File(lastSavedFile));
                int ret = fc.showOpenDialog(this);
                if (ret == 0) {
                    File file = fc.getSelectedFile();
                    String filePath = file.getPath();
                    this.setText(filePath);
                }
            } else if (comm.equals("marvin")) {
                String smilesString = this.textBox.getText();
                this.mFrame = new MarvinFrame();
                this.mFrame.setSmiles(smilesString);
                this.mFrame.addWindowListener(this);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    public class AttGuiObject {
        private String attributeName;
        private Object inputComp;
        private JButton actionButton;

        AttGuiObject(String name) {
            this.attributeName = name;
        }

        public void setComponent(Object comp) {
            this.inputComp = comp;
        }

        public Attribute getAttribute(Element el) {
            Attribute att = EditorPanel.this.instanceEl.attribute(this.attributeName);
            if (att == null) {
                att = DocumentHelper.createAttribute((Element)EditorPanel.this.instanceEl, (String)this.attributeName, (String)this.getValue());
                el.add(att);
            } else {
                att.setValue(this.getValue());
            }
            return att;
        }

        private String getValue() {
            Object c = this.inputComp;
            String data = "";
            if (c == null) {
                return data;
            }
            if (c instanceof MolTextBox) {
                MolTextBox tf = (MolTextBox)c;
                data = tf.getText();
            } else if (c instanceof JTextField) {
                JTextField tf = (JTextField)c;
                data = tf.getText();
            } else if (c instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)c;
                data = bg.getSelection().getActionCommand();
            } else if (c instanceof JComboBox) {
                JComboBox cb = (JComboBox)c;
                data = (String)cb.getSelectedItem();
            } else if (c instanceof StructurePanel) {
                StructurePanel sp = (StructurePanel)c;
                data = sp.getText();
            } else {
                data = "";
            }
            return data;
        }

        public void setValue(Element el) {
            Object c;
            String data = el.attributeValue(this.attributeName);
            if (data == null) {
                data = "";
            }
            if ((c = this.inputComp) instanceof MolTextBox) {
                MolTextBox tf = (MolTextBox)c;
                tf.setText(data);
                tf.setCaretPosition(0);
            } else if (c instanceof JTextField) {
                JTextField tf = (JTextField)c;
                tf.setText(data);
                tf.setCaretPosition(0);
            } else if (c instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)c;
                Enumeration<AbstractButton> en = bg.getElements();
                if (data.equals("")) {
                    if (en.hasMoreElements()) {
                        JRadioButton rb = (JRadioButton)en.nextElement();
                        rb.setSelected(true);
                    }
                } else {
                    while (en.hasMoreElements()) {
                        JRadioButton rb = (JRadioButton)en.nextElement();
                        if (!rb.getActionCommand().equals(data)) continue;
                        rb.setSelected(true);
                    }
                }
            } else if (c instanceof JComboBox) {
                JComboBox cb = (JComboBox)c;
                cb.setSelectedItem(data);
            } else if (c instanceof StructurePanel) {
                StructurePanel sp = (StructurePanel)c;
                sp.setText(data);
            }
        }
    }
}

