/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config;

import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpFrame
extends JFrame
implements HyperlinkListener {
    private JEditorPane helpPane;
    private URL helpURL;

    public HelpFrame(String helpType) {
        if (helpType.equals("help")) {
            this.showHelp();
        } else if (helpType.equals("about")) {
            this.showAbout();
        }
        this.setDefaultCloseOperation(2);
        this.setSize(500, 400);
        this.setVisible(true);
    }

    private void showHelp() {
        try {
            this.helpURL = HelpFrame.class.getResource("/doc/user/Config.html");
            this.helpPane = new JEditorPane(this.helpURL);
            this.helpPane.setEditable(false);
            this.helpPane.addHyperlinkListener(this);
            JScrollPane js = new JScrollPane(this.helpPane);
            this.getContentPane().add(js);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setTitle("Config Help");
    }

    private void showAbout() {
        try {
            this.helpURL = HelpFrame.class.getResource("/doc/user/about-config.html");
            this.helpPane = new JEditorPane(this.helpURL);
            this.helpPane.setEditable(false);
            this.helpPane.addHyperlinkListener(this);
            JScrollPane js = new JScrollPane(this.helpPane);
            this.getContentPane().add(js);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setTitle("About Config");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL nextURL = ev.getURL();
            try {
                this.helpPane.setPage(nextURL);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

