/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config.converter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Converter {
    protected String fileName;
    protected int sourceType;
    protected static final int XML = 1;
    protected static final int DOM4J = 2;
    protected static final int OTHER = 0;
    private Document outDoc = null;
    private File outFile = null;
    private File inFile = null;
    private String outFileName;
    private Document sourceDoc;

    public Converter(String inFileName) {
        this.fileName = inFileName;
        this.sourceDoc = null;
        this.sourceType = this.fileName.endsWith(".xml") || this.fileName.endsWith(".xsd") ? 1 : 0;
    }

    public Converter(File iFile) {
        this.fileName = iFile.getPath();
        this.fileName = this.fileName.trim();
        this.sourceDoc = null;
        this.inFile = iFile;
        this.sourceType = this.fileName.endsWith(".xml") || this.fileName.endsWith(".xsd") ? 1 : 0;
    }

    public Converter(Document doc, String oFile) {
        this.sourceDoc = doc;
        this.outFileName = oFile;
        this.fileName = null;
        this.sourceType = 2;
    }

    public Converter(Document doc, File oFile) {
        this.sourceDoc = doc;
        this.outFileName = oFile.getPath();
        this.fileName = null;
        this.sourceType = 2;
        this.outFile = oFile;
    }

    public void convert() throws Exception {
        if (this.sourceType == 0) {
            System.err.println("Wrong type for conversion");
            throw new Exception("File in wrong format");
        }
        if (this.sourceType == 1) {
            this.convertXml2Object();
        } else if (this.sourceType == 2) {
            this.convertObject2Xml();
        } else {
            return;
        }
    }

    protected void convertXml2Object() throws DocumentException, MalformedURLException, FileNotFoundException {
        if (this.inFile == null) {
            this.inFile = new File(this.fileName);
        }
        if (!this.inFile.canRead()) {
            throw new FileNotFoundException("Can't Read File " + this.fileName);
        }
        SAXReader reader = new SAXReader();
        reader.setStripWhitespaceText(true);
        reader.setMergeAdjacentText(true);
        this.outDoc = reader.read(this.inFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertObject2Xml() throws FileNotFoundException, IOException {
        if (this.outFile == null) {
            this.outFile = new File(this.outFileName);
        }
        FileOutputStream outStream = null;
        outStream = new FileOutputStream(this.outFile);
        if (!this.outFile.canWrite()) {
            this.outFile.createNewFile();
        }
        try {
            XMLWriter outWrite = new XMLWriter((OutputStream)outStream, OutputFormat.createPrettyPrint());
            outWrite.write(this.sourceDoc);
            outWrite.flush();
            outStream.flush();
            outWrite.close();
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Bad encoding");
            System.err.println(ex.getMessage());
        }
        finally {
            outStream.close();
        }
    }

    public Document getObject() {
        return this.outDoc;
    }

    public File getFile() {
        return this.outFile;
    }
}

