/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config.converter;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class SchemaToInstance {
    private Document schema;
    private Document instance;
    private String schemaName;

    public SchemaToInstance() {
        this.schema = null;
        this.instance = DocumentHelper.createDocument();
    }

    public SchemaToInstance(String inFile) {
        this.schemaName = inFile;
        this.schema = null;
        this.instance = DocumentHelper.createDocument();
    }

    public Document convert() {
        File inFile = new File(this.schemaName);
        if (!inFile.canRead()) {
            System.err.println("Can't Read");
        } else {
            try {
                SAXReader reader = new SAXReader();
                this.schema = reader.read(inFile);
            }
            catch (DocumentException ex) {
                System.err.println(ex.getMessage());
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        if (this.schema != null) {
            XPath rootEl = DocumentHelper.createXPath((String)"/xsd:schema/xsd:element");
            List resList = rootEl.selectNodes((Object)this.schema);
            Element e = (Element)resList.get(0);
            Element instRoot = this.instance.addElement(e.attributeValue("name"));
            this.iterateNodes(e, instRoot);
        }
        return this.instance;
    }

    public Document convert(Document d) {
        this.schema = d;
        this.instance = DocumentHelper.createDocument();
        XPath rootEl = DocumentHelper.createXPath((String)"/xsd:schema/xsd:element");
        List resList = rootEl.selectNodes((Object)this.schema);
        if (resList == null || resList.isEmpty()) {
            return null;
        }
        Element e = (Element)resList.get(0);
        Element instRoot = this.instance.addElement(e.attributeValue("name"));
        this.iterateNodes(e, instRoot);
        return this.instance;
    }

    public Element convertNode(Element e) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(e.attributeValue("name"));
        this.iterateNodes(e, root);
        return root;
    }

    private void iterateNodes(Element sEl, Element iEl) {
        List kids = sEl.elements();
        for (Element e : kids) {
            String eType = e.getName();
            if (eType.equals("complexType") || eType.equals("sequence") || eType.equals("all") || eType.equals("choice") || eType.equals("complexContent") || eType.equals("group")) {
                this.iterateNodes(e, iEl);
                continue;
            }
            if (eType.equals("element")) {
                Element iChild = iEl.addElement(e.attributeValue("name"));
                this.iterateNodes(e, iChild);
                continue;
            }
            if (!eType.equals("attribute")) continue;
            iEl.addAttribute(e.attributeValue("name"), "");
        }
    }

    public void printDoc() {
        OutputFormat format2 = OutputFormat.createPrettyPrint();
        try {
            XMLWriter outWriter = new XMLWriter((OutputStream)System.out, format2);
            outWriter.write(this.instance);
            outWriter.close();
        }
        catch (UnsupportedEncodingException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

