/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.config.struct;

import chemaxon.config.struct.ActChoiceBox;
import chemaxon.config.struct.Dom4jListModel;
import chemaxon.config.struct.MolTextBox;
import chemaxon.marvin.beans.MViewPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class Control
implements ActionListener,
ListSelectionListener,
DocumentListener,
TextListener {
    private Element instNode = null;
    private Hashtable sourceComponents = new Hashtable();
    private Hashtable listHash;
    private boolean hasMultiple = false;
    private Dom4jListModel listModel;
    private JList listBox;
    private String lastNode;
    private boolean hasChildren = false;
    private Control childControl;
    private Vector childrenControls;
    private boolean hasChanged = false;
    private boolean needsViewer;
    private MViewPane mvPane = null;
    private Hashtable contentComponents = new Hashtable();
    private Hashtable hasMultiHash = new Hashtable();
    private Element idealNode = null;
    private Hashtable childControls;
    private Hashtable viewerNodes;
    private boolean firstFill = true;

    public Control() {
        this.listHash = new Hashtable();
        this.childrenControls = new Vector();
        this.childControls = new Hashtable();
        this.viewerNodes = new Hashtable();
    }

    public Element getInstanceNode() {
        return this.instNode;
    }

    public void setInstanceNode(Element e) {
        this.instNode = e;
    }

    public void setIdealNode(Element e) {
        this.idealNode = e;
    }

    public void changeInstanceNode(Element e) {
        this.instNode = e != null ? e : this.idealNode.createCopy();
        this.hasChanged = true;
        this.fillControls();
    }

    public void setList(JList list, Dom4jListModel lm) {
        Object[] o = new Object[]{list, lm};
        this.listHash.put(this.lastNode, o);
        this.listModel = lm;
        this.listBox = list;
        this.hasMultiHash.put(this.lastNode, new Boolean(true));
    }

    public void addControl(String eName, String aName, Object c) {
        Vector attVec = (Vector)this.sourceComponents.get(eName);
        Object[] attObject = new Object[]{aName, c};
        attVec.add(attObject);
    }

    public void addControl(String aName, Object c) {
        Vector attVec = (Vector)this.sourceComponents.get(this.lastNode);
        Object[] attObject = new Object[]{aName, c};
        attVec.add(attObject);
    }

    public void addNode(String name) {
        Vector v = new Vector();
        this.sourceComponents.put(name, v);
        this.hasMultiHash.put(name, new Boolean(false));
        this.lastNode = name;
    }

    public Enumeration getNodes() {
        return this.sourceComponents.keys();
    }

    public void setChild(Control c) {
        this.hasChildren = true;
        this.childrenControls.add(c);
    }

    public void setChild(String s, Control c) {
        this.hasChildren = true;
        this.childControls.put(s, c);
    }

    public boolean hasMultiple() {
        return this.hasMultiple;
    }

    public void addViewer() {
        this.viewerNodes.put(this.lastNode, "");
    }

    public void addViewer(String nName) {
        this.viewerNodes.put(nName, "");
    }

    public boolean needsViewer() {
        return this.needsViewer;
    }

    public boolean needsViewer(String nName) {
        return this.viewerNodes.containsKey(nName);
    }

    public void setViewer(MViewPane mv) {
        this.mvPane = mv;
    }

    public void setViewer(String nName, MViewPane mv) {
        this.viewerNodes.put(nName, mv);
    }

    public void addNodeContent(String eName, JTextField tf) {
        this.contentComponents.put(eName, tf);
    }

    private void createCleanCopy(Element e) {
        List atts = e.attributes();
        for (int i = 0; i < atts.size(); ++i) {
            ((Attribute)atts.get(i)).setValue("");
        }
        List els = e.elements();
        for (int j = 0; j < els.size(); ++j) {
            Element e1 = (Element)els.get(j);
            this.createCleanCopy(e1);
        }
    }

    public void addElement(String buttonName) {
        JTextField contentText;
        this.hasMultiple = (Boolean)this.hasMultiHash.get(buttonName);
        if (!this.hasMultiple) {
            return;
        }
        Element newEl = ((Element)this.idealNode.selectSingleNode(".//" + buttonName)).createCopy();
        this.instNode.add(newEl);
        if (this.hasChildren) {
            Control c = (Control)this.childControls.get(newEl.getName());
            c.parseAllInput();
            c.changeInstanceNode(newEl);
        }
        if ((contentText = (JTextField)this.contentComponents.get(buttonName)) != null) {
            String content = contentText.getText();
            newEl.clearContent();
            newEl.addCDATA(content);
        }
        Vector attVector = (Vector)this.sourceComponents.get(buttonName);
        String data = "";
        for (int i = 0; i < attVector.size(); ++i) {
            JTextField tf;
            Object[] o = (Object[])attVector.elementAt(i);
            String attName = (String)o[0];
            Object c = o[1];
            if (c instanceof MolTextBox) {
                tf = (MolTextBox)c;
                data = tf.isEnabled() ? tf.getText() : "";
            } else if (c instanceof JTextField) {
                tf = (JTextField)c;
                data = tf.getText();
            } else if (c instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)c;
                data = bg.getSelection().getActionCommand();
            } else {
                JComboBox cb;
                data = c instanceof JComboBox ? ((cb = (JComboBox)c).isEnabled() ? (String)cb.getSelectedItem() : "") : "";
            }
            if (data.equals("") || data.equals("blank")) continue;
            newEl.addAttribute(attName, data);
        }
        if (this.hasMultiple) {
            Object[] o = (Object[])this.listHash.get(buttonName);
            this.listBox = (JList)o[0];
            this.listModel = (Dom4jListModel)o[1];
            this.listModel.addElement(newEl);
            this.listBox.setSelectedIndex(this.listModel.indexOf(newEl));
        }
    }

    public void parseAllInput() {
        Enumeration nodes = this.sourceComponents.keys();
        while (nodes.hasMoreElements()) {
            String currentEl = (String)nodes.nextElement();
            this.hasMultiple = (Boolean)this.hasMultiHash.get(currentEl);
            if (this.hasMultiple) continue;
            Element newEl = null;
            Element sibling = null;
            sibling = (Element)this.instNode.selectSingleNode(".//" + currentEl);
            Object parent = null;
            newEl = sibling != null ? sibling : this.instNode.addElement(currentEl);
            JTextField contentText = (JTextField)this.contentComponents.get(currentEl);
            if (contentText != null) {
                String content = contentText.getText();
                newEl.clearContent();
                newEl.addCDATA(content);
            }
            Vector attVector = (Vector)this.sourceComponents.get(currentEl);
            String data = "";
            for (int i = 0; i < attVector.size(); ++i) {
                JTextField tf;
                Object[] o = (Object[])attVector.elementAt(i);
                String attName = (String)o[0];
                Object c = o[1];
                if (c instanceof MolTextBox) {
                    tf = (MolTextBox)c;
                    data = tf.getText();
                } else if (c instanceof JTextField) {
                    tf = (JTextField)c;
                    data = tf.getText();
                } else if (c instanceof ButtonGroup) {
                    ButtonGroup bg = (ButtonGroup)c;
                    data = bg.getSelection().getActionCommand();
                } else if (c instanceof JComboBox) {
                    JComboBox cb = (JComboBox)c;
                    data = (String)cb.getSelectedItem();
                } else {
                    data = "";
                }
                if (data.equals("") || data.equals("blank")) continue;
                newEl.addAttribute(attName, data);
            }
        }
    }

    public void editElement(String s) {
        Object[] o = (Object[])this.listHash.get(s);
        this.listBox = (JList)o[0];
        this.listModel = (Dom4jListModel)o[1];
        this.editElement();
    }

    public void editElement() {
        int selIndex = this.listBox.getSelectedIndex();
        if (selIndex != -1) {
            Element selEl = (Element)this.listModel.elementAt(selIndex);
            String currentEl = selEl.getName();
            JTextField contentText = (JTextField)this.contentComponents.get(currentEl);
            if (contentText != null) {
                String content = contentText.getText();
                selEl.clearContent();
                selEl.addCDATA(content);
            }
            Vector attVector = (Vector)this.sourceComponents.get(currentEl);
            String data = "";
            for (int i = 0; i < attVector.size(); ++i) {
                MViewPane mPane;
                JTextField tf;
                Object[] o = (Object[])attVector.elementAt(i);
                String attName = (String)o[0];
                Object c = o[1];
                if (c instanceof JTextField) {
                    tf = (JTextField)c;
                    data = tf.getText();
                    if (this.needsViewer(currentEl) && (attName.equals("String") || attName.equals("Path") || attName.equals("Structure")) && (mPane = (MViewPane)this.viewerNodes.get(currentEl)) != null) {
                        mPane.setM(0, data);
                    }
                } else if (c instanceof MolTextBox) {
                    tf = (MolTextBox)c;
                    data = tf.getText();
                    if (this.needsViewer(currentEl) && (attName.equals("String") || attName.equals("Path") || attName.equals("Structure")) && (mPane = (MViewPane)this.viewerNodes.get(currentEl)) != null) {
                        if (attName.equals("Path")) {
                            String pass = this.checkForFile(data);
                            mPane.setM(0, pass);
                        } else {
                            mPane.setM(0, data);
                        }
                    }
                } else if (c instanceof ButtonGroup) {
                    ButtonGroup bg = (ButtonGroup)c;
                    data = bg.getSelection().getActionCommand();
                } else {
                    JComboBox cb;
                    data = c instanceof JComboBox ? ((cb = (JComboBox)c).isEnabled() ? (String)cb.getSelectedItem() : "") : "";
                }
                selEl.addAttribute(attName, data);
            }
            this.listModel.setElementAt(selEl, selIndex);
        }
    }

    public void fillControls() {
        Element el = null;
        Enumeration nodeKeys = this.sourceComponents.keys();
        while (nodeKeys.hasMoreElements()) {
            Control c;
            String elNode = (String)nodeKeys.nextElement();
            Vector attVect = (Vector)this.sourceComponents.get(elNode);
            this.hasMultiple = (Boolean)this.hasMultiHash.get(elNode);
            if (this.hasMultiple) {
                Object[] ol = (Object[])this.listHash.get(elNode);
                this.listBox = (JList)ol[0];
                this.listModel = (Dom4jListModel)ol[1];
                if (this.hasChanged) {
                    this.listModel.clear();
                    this.clearControls(elNode);
                }
                List nodeElements = this.instNode.elements(elNode);
                int i = 0;
                if (nodeElements.size() > 0) {
                    String elName;
                    for (i = 0; i < nodeElements.size() - 1; ++i) {
                        el = (Element)nodeElements.get(i);
                        elName = el.getName();
                        if (this.listModel == null) continue;
                        this.listModel.addElement(el);
                    }
                    el = (Element)nodeElements.get(nodeElements.size() - 1);
                    elName = el.getName();
                    String tester = el.asXML();
                    String test2 = this.instNode.asXML();
                    if (this.isElementEmpty(el)) {
                        this.instNode.remove(el);
                        if (this.listModel.contains(el)) {
                            this.listModel.removeElement(el);
                        }
                        this.listBox.setSelectedIndex(-1);
                    } else {
                        this.listModel.addElement(el);
                        this.listBox.setSelectedIndex(this.listModel.size() - 1);
                        JTextField contentText = (JTextField)this.contentComponents.get(elNode);
                        if (contentText != null) {
                            String content = el.getText();
                            contentText.setText(content);
                            contentText.setCaretPosition(0);
                        }
                        for (int j = 0; j < attVect.size(); ++j) {
                            JTextField tf;
                            Object[] o = (Object[])attVect.elementAt(j);
                            String aName = (String)o[0];
                            Object c2 = o[1];
                            Attribute a = null;
                            if (el != null) {
                                a = el.attribute(aName);
                            }
                            if (c2 instanceof MolTextBox) {
                                tf = (MolTextBox)c2;
                                if (a != null) {
                                    ((MolTextBox)tf).setText(a.getValue());
                                    tf.setCaretPosition(0);
                                    continue;
                                }
                                ((MolTextBox)tf).setText("");
                                continue;
                            }
                            if (c2 instanceof JTextField) {
                                tf = (JTextField)c2;
                                if (a != null) {
                                    if (!a.getValue().equals("")) {
                                        tf.setText(a.getValue());
                                    }
                                    tf.setCaretPosition(0);
                                    continue;
                                }
                                tf.setText("");
                                continue;
                            }
                            if (c2 instanceof ButtonGroup) {
                                JRadioButton rb;
                                ButtonGroup bg = (ButtonGroup)c2;
                                Enumeration<AbstractButton> en = bg.getElements();
                                if (a != null) {
                                    while (en.hasMoreElements()) {
                                        rb = (JRadioButton)en.nextElement();
                                        if (!rb.getActionCommand().equals(a.getValue())) continue;
                                        rb.setSelected(true);
                                    }
                                    continue;
                                }
                                if (!en.hasMoreElements()) continue;
                                rb = (JRadioButton)en.nextElement();
                                rb.setSelected(true);
                                continue;
                            }
                            if (!(c2 instanceof JComboBox)) continue;
                            JComboBox cb = (JComboBox)c2;
                            if (a == null) continue;
                            if (!a.getValue().equals("")) {
                                cb.setSelectedItem(a.getValue());
                                continue;
                            }
                            cb.setSelectedIndex(0);
                        }
                    }
                }
                if (!this.hasChildren || this.firstFill) continue;
                Control c3 = (Control)this.childControls.get(elNode);
                c3.changeInstanceNode(el);
                continue;
            }
            if (this.hasChanged) {
                this.clearControls(elNode);
            }
            el = this.instNode.element(elNode);
            JTextField contentText = (JTextField)this.contentComponents.get(elNode);
            if (contentText != null) {
                String content = el.getText();
                contentText.setText(content);
                contentText.setCaretPosition(0);
            }
            for (int i = 0; i < attVect.size(); ++i) {
                JTextField tf;
                Object[] o = (Object[])attVect.elementAt(i);
                String aName = (String)o[0];
                Object c4 = o[1];
                Attribute a = null;
                if (el != null) {
                    a = el.attribute(aName);
                }
                if (c4 instanceof MolTextBox) {
                    tf = (MolTextBox)c4;
                    if (a != null) {
                        ((MolTextBox)tf).setText(a.getValue());
                        tf.setCaretPosition(0);
                        continue;
                    }
                    ((MolTextBox)tf).setText("");
                    continue;
                }
                if (c4 instanceof JTextField) {
                    tf = (JTextField)c4;
                    if (a == null) continue;
                    if (!a.getValue().equals("")) {
                        tf.setText(a.getValue());
                    }
                    tf.setCaretPosition(0);
                    continue;
                }
                if (c4 instanceof ButtonGroup) {
                    JRadioButton rb;
                    ButtonGroup bg = (ButtonGroup)c4;
                    Enumeration<AbstractButton> en = bg.getElements();
                    if (a != null) {
                        while (en.hasMoreElements()) {
                            rb = (JRadioButton)en.nextElement();
                            if (!rb.getActionCommand().equals(a.getValue())) continue;
                            rb.setSelected(true);
                        }
                        continue;
                    }
                    if (!en.hasMoreElements()) continue;
                    rb = (JRadioButton)en.nextElement();
                    rb.setSelected(true);
                    continue;
                }
                if (!(c4 instanceof JComboBox)) continue;
                JComboBox cb = (JComboBox)c4;
                if (a == null) continue;
                if (!a.getValue().equals("")) {
                    cb.setSelectedItem(a.getValue());
                    continue;
                }
                cb.setSelectedIndex(0);
            }
            if (!this.hasChildren || this.firstFill || (c = (Control)this.childControls.get(elNode)) == null) continue;
            c.changeInstanceNode(el);
        }
        this.firstFill = false;
    }

    private void clearControls(String nodeName) {
        JTextField contentText = (JTextField)this.contentComponents.get(nodeName);
        if (contentText != null) {
            contentText.setText("");
            contentText.setCaretPosition(0);
        }
        Vector attVect = (Vector)this.sourceComponents.get(nodeName);
        for (int i = 0; i < attVect.size(); ++i) {
            JTextField tf;
            MViewPane mPane;
            Object[] oV = (Object[])attVect.elementAt(i);
            String aName = (String)oV[0];
            Object c = oV[1];
            if (this.needsViewer(nodeName) && (aName.equals("String") || aName.equals("Path") || aName.equals("Structure")) && (mPane = (MViewPane)this.viewerNodes.get(nodeName)) != null) {
                mPane.setM(0, "");
            }
            if (c instanceof MolTextBox) {
                tf = (MolTextBox)c;
                ((MolTextBox)tf).setText("");
                continue;
            }
            if (c instanceof JTextField) {
                tf = (JTextField)c;
                tf.setText("");
                continue;
            }
            if (c instanceof ButtonGroup) {
                ButtonGroup bg = (ButtonGroup)c;
                Enumeration<AbstractButton> en = bg.getElements();
                if (!en.hasMoreElements()) continue;
                JRadioButton rb = (JRadioButton)en.nextElement();
                rb.setSelected(true);
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            JComboBox cb = (JComboBox)c;
            cb.setSelectedIndex(0);
        }
    }

    public void removeElement(String s) {
        Object[] o = (Object[])this.listHash.get(s);
        this.listBox = (JList)o[0];
        this.listModel = (Dom4jListModel)o[1];
        int selIndex = this.listBox.getSelectedIndex();
        if (selIndex != -1) {
            Element selEl = (Element)this.listModel.elementAt(selIndex);
            this.listModel.remove(selIndex);
            if (selIndex >= this.listModel.size()) {
                selIndex = this.listModel.size() - 1;
            }
            this.listBox.setSelectedIndex(selIndex);
            this.instNode.remove(selEl);
            if (selIndex == -1) {
                this.clearControls(s);
            }
        }
    }

    public void removeElement() {
        int selIndex = this.listBox.getSelectedIndex();
        if (selIndex != -1) {
            Element selEl = (Element)this.listModel.elementAt(selIndex);
            this.listModel.remove(selIndex);
            if (selIndex >= this.listModel.size()) {
                selIndex = this.listModel.size() - 1;
            }
            this.listBox.setSelectedIndex(selIndex);
            this.instNode.remove(selEl);
        }
    }

    private boolean isElementEmpty(Element e) {
        if (e.elements().isEmpty()) {
            if (e.attributeCount() == 0) {
                return true;
            }
            boolean isEmpty = true;
            Iterator atIt = e.attributeIterator();
            while (atIt.hasNext()) {
                Attribute a = (Attribute)atIt.next();
                String aVal = a.getValue();
                if (aVal.equals("") || aVal == null) continue;
                isEmpty = false;
                break;
            }
            return isEmpty;
        }
        boolean isEmpty = false;
        List els = e.elements();
        for (int i = 0; i < els.size() && (isEmpty = this.isElementEmpty((Element)els.get(i))); ++i) {
        }
        return isEmpty;
    }

    public void setMol(String s) {
        if (this.needsViewer && this.mvPane != null) {
            String pass = this.checkForFile(s);
            this.mvPane.setM(0, pass);
        }
    }

    private String checkForFile(String s) {
        String savedFile;
        String savedDir;
        int lastDot = s.lastIndexOf(".");
        if (lastDot == -1) {
            return s;
        }
        String fileFormat = s.substring(lastDot + 1);
        if (!(fileFormat.equals("mol") || fileFormat.equals("sdf") || fileFormat.equals("sd") || fileFormat.equals("rdf") || fileFormat.equals("rd") || fileFormat.equals("rxn") || fileFormat.equals("csmol") || fileFormat.equals("cssdf") || fileFormat.equals("csrdf") || fileFormat.equals("csrxn") || fileFormat.equals("pdb") || fileFormat.equals("smiles") || fileFormat.equals("smi") || fileFormat.equals("abbrevgroup") || fileFormat.equals("mol") || fileFormat.equals("syb") || fileFormat.equals("xyz"))) {
            return s;
        }
        File f = new File(s);
        if (f.exists()) {
            return s;
        }
        String curDir = System.getProperty("user.dir");
        String pathSep = System.getProperty("file.separator");
        String fileCheck = s;
        if (!s.startsWith(pathSep)) {
            fileCheck = pathSep + s;
        }
        if ((f = new File(fileCheck = curDir + fileCheck)).exists()) {
            return fileCheck;
        }
        String homeDir = System.getProperty("user.home");
        if (!homeDir.equals(curDir)) {
            if (!s.startsWith(pathSep)) {
                fileCheck = pathSep + s;
            }
            if ((f = new File(fileCheck = homeDir + fileCheck)).exists()) {
                return fileCheck;
            }
        }
        String string = savedDir = (savedFile = System.getProperty("saved.file")).lastIndexOf(pathSep) == -1 ? "" : savedFile.substring(0, savedFile.lastIndexOf(pathSep));
        if (!s.startsWith(pathSep)) {
            fileCheck = pathSep + s;
        }
        if ((f = new File(fileCheck = savedDir + fileCheck)).exists()) {
            return fileCheck;
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String comm = ev.getActionCommand();
        String buttonName = ((JButton)ev.getSource()).getName();
        if (comm.equals("edit")) {
            this.editElement(buttonName);
        } else if (comm.equals("add")) {
            this.addElement(buttonName);
        } else if (comm.equals("remove")) {
            this.removeElement(buttonName);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        if (ev.getValueIsAdjusting()) {
            return;
        }
        this.listBox = (JList)ev.getSource();
        this.listModel = (Dom4jListModel)this.listBox.getModel();
        int selIndex = this.listBox.getSelectedIndex();
        if (selIndex != -1) {
            String elName;
            JTextField contentText;
            Element selEl = (Element)this.listModel.elementAt(selIndex);
            if (this.hasChildren) {
                Control c = (Control)this.childControls.get(selEl.getName());
                c.parseAllInput();
                c.changeInstanceNode(selEl);
            }
            if ((contentText = (JTextField)this.contentComponents.get(elName = selEl.getName())) != null) {
                String content = selEl.getText();
                contentText.setText(content);
                contentText.setCaretPosition(0);
            }
            Vector attVect = (Vector)this.sourceComponents.get(elName);
            for (int i = 0; i < attVect.size(); ++i) {
                JComboBox cb;
                JTextField tf;
                Object[] o = (Object[])attVect.elementAt(i);
                String aName = (String)o[0];
                Object c = o[1];
                Attribute a = selEl.attribute(aName);
                if (this.needsViewer(elName) && (aName.equals("String") || aName.equals("Path")) || aName.equals("Structure") && a != null) {
                    String molString = a.getValue();
                    MViewPane mPane = (MViewPane)this.viewerNodes.get(elName);
                    if (mPane != null) {
                        if (aName.equals("Path")) {
                            String pass = this.checkForFile(molString);
                            mPane.setM(0, pass);
                        } else {
                            mPane.setM(0, molString);
                        }
                    }
                }
                if (c instanceof MolTextBox) {
                    tf = (MolTextBox)c;
                    if (a != null) {
                        ((MolTextBox)tf).setText(a.getValue());
                        tf.setCaretPosition(0);
                        continue;
                    }
                    ((MolTextBox)tf).setText("");
                    continue;
                }
                if (c instanceof JTextField) {
                    tf = (JTextField)c;
                    if (a != null) {
                        tf.setText(a.getValue());
                        tf.setCaretPosition(0);
                        continue;
                    }
                    tf.setText("");
                    continue;
                }
                if (c instanceof ButtonGroup) {
                    JRadioButton rb;
                    ButtonGroup bg = (ButtonGroup)c;
                    Enumeration<AbstractButton> en = bg.getElements();
                    if (a != null) {
                        while (en.hasMoreElements()) {
                            rb = (JRadioButton)en.nextElement();
                            if (!rb.getActionCommand().equals(a.getValue())) continue;
                            rb.setSelected(true);
                        }
                        continue;
                    }
                    if (!en.hasMoreElements()) continue;
                    rb = (JRadioButton)en.nextElement();
                    rb.setSelected(true);
                    continue;
                }
                if (c instanceof ActChoiceBox) {
                    cb = (ActChoiceBox)c;
                    if (a != null) {
                        ((ActChoiceBox)cb).setSelectedItem(a.getValue());
                        continue;
                    }
                    ((ActChoiceBox)cb).setSelectedIndex(0);
                    continue;
                }
                if (!(c instanceof JComboBox)) continue;
                cb = (JComboBox)c;
                if (a != null) {
                    cb.setSelectedItem(a.getValue());
                    continue;
                }
                cb.setSelectedIndex(0);
            }
        } else {
            return;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            String newSmiles = e.getDocument().getText(0, e.getDocument().getLength());
            if (this.needsViewer) {
                String pass = this.checkForFile(newSmiles);
                this.mvPane.setM(0, pass);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void textValueChanged(TextEvent e) {
    }
}

