/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.core.calculations.RingClassifier;
import chemaxon.struc.MoleculeGraph;
import java.util.Arrays;
import java.util.HashSet;

public class BondClassifier
implements RingClassifier {
    protected int[][] ctab = null;
    private int[] path = null;
    private int[] visited = null;
    private boolean[] ringatom = null;
    private HashSet<Long> ringbonds = null;
    private int[] dfs = null;
    private int[] root = null;
    private int dfsindex = 0;
    private int dfsroot = 0;
    private int pathlen = 0;

    public BondClassifier() {
        this.alloc(64);
    }

    public int getAtomCount() {
        return this.dfsindex;
    }

    @Override
    public boolean isRingAtom(int i) {
        return this.ringatom[i];
    }

    @Override
    public boolean isRingBond(int i, int j) {
        return this.ringbonds.contains(this.getBondIndex(i, j));
    }

    public int getAtomIndex(int i) {
        return this.dfs[i];
    }

    public int getRootDFS(int i) {
        return this.root[i];
    }

    @Override
    public void classify(MoleculeGraph graph) {
        this.ctab = graph.getCtab();
        this.alloc(this.ctab.length);
        for (int index = 0; index < this.ctab.length; ++index) {
            if (this.visited[index] != 0) continue;
            this.dfsroot = this.dfsindex;
            this.traverse(index);
        }
    }

    private void traverse(int index) {
        if (this.visited[index] == 2) {
            return;
        }
        if (this.visited[index] == 1) {
            this.setRing(index);
            return;
        }
        this.visited[index] = 1;
        this.root[index] = this.dfsroot;
        this.dfs[this.dfsindex++] = index;
        this.path[this.pathlen++] = index;
        int prev = this.pathlen >= 2 ? this.path[this.pathlen - 2] : -1;
        int deg = this.ctab[index].length;
        for (int j = 0; j < deg; ++j) {
            int next = this.ctab[index][j];
            if (prev == next) continue;
            this.traverse(next);
        }
        this.visited[index] = 2;
        --this.pathlen;
    }

    private void setRing(int index) {
        int from = index;
        int i = this.pathlen - 1;
        while (this.path[i] != index) {
            this.ringbonds.add(this.getBondIndex(from, this.path[i]));
            this.ringatom[this.path[i]] = true;
            from = this.path[i];
            --i;
        }
        this.ringatom[index] = true;
        this.ringbonds.add(this.getBondIndex(from, index));
    }

    private long getBondIndex(long i, long j) {
        return i > j ? i * (i - 1L) / 2L + j : j * (j - 1L) / 2L + i;
    }

    private void alloc(int capacity) {
        int n;
        int n2 = n = this.visited != null ? this.visited.length : 1;
        while (n < capacity) {
            n *= 2;
        }
        if (this.visited == null || n > this.visited.length) {
            this.visited = new int[n];
            this.path = new int[n];
            this.dfs = new int[n];
            this.root = new int[n];
            this.ringatom = new boolean[n];
            this.ringbonds = new HashSet(n);
        }
        Arrays.fill(this.visited, 0);
        Arrays.fill(this.ringatom, false);
        this.ringbonds.clear();
        this.dfsindex = 0;
        this.pathlen = 0;
    }
}

