/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;

public class DearomatizePlus {
    MoleculeGraph mol;
    Molecule[] oMol;
    MolAtom[] atomArray;
    int[][] cHtab;
    int[][] bHtab;
    int[][] newbHtab;
    int[] fixed;
    int[][] expectedBC;
    int[] DearaFailed;
    int[] fAraIsland;
    int[] expectedPieC;
    boolean[] spiroArA;
    boolean[] tArA;
    int[] islandPieC;
    int[] crossArA;
    int atomCount;
    int aCount;
    int fixingCount;
    boolean fixingFlag;
    int AraOxNb;
    int[] araAtom;
    int[][] rings;
    boolean huckelCheck = false;
    int islandCount;
    int actPieCount;
    boolean missedAra;
    final int EMPTY = -100;
    final int FIXED = 1;
    final int FAILED = 1;
    final int UNKNOWN = -1;
    final int KNOWN = 1;
    boolean UNKNOWN_ATOM;
    Boolean DEARA_FLAG;
    int[] dist;
    int[] sphere;
    int sphereSize;
    boolean repeat;
    int repeatCount = 0;
    MolBond[] keyb;
    int[] keyBtype;

    public boolean dearomatize(MoleculeGraph m) {
        this.setMolecule(m);
        return this.dearomatizePlus();
    }

    public boolean huckelCheck(MoleculeGraph m) {
        this.setMolecule(m);
        this.setRings();
        this.huckelCheck = true;
        this.dearomatizePlus();
        this.huckelCheck = false;
        return this.DEARA_FLAG;
    }

    public boolean createAll(MoleculeGraph m) {
        int i;
        this.setMolecule(m);
        this.setRings();
        this.initDearoma();
        if (this.aCount == 0) {
            return this.DEARA_FLAG;
        }
        this.setKeyBonds();
        Molecule g = (Molecule)m;
        int c = 0;
        for (i = 0; i < this.keyb.length; ++i) {
            if (this.keyBtype[i] != 3) continue;
            ++c;
        }
        this.oMol = new Molecule[this.keyb.length + c];
        for (i = 0; i < this.keyb.length + c; ++i) {
            this.oMol[i] = g.cloneMoleculeWithDocument();
        }
        int k = 0;
        int step = 0;
        while (k < this.keyb.length) {
            if (this.keyb[k] != null) {
                if (this.keyBtype[k] < 3) {
                    this.dearomatizePlus(k, this.keyBtype[k]);
                    this.printo();
                } else {
                    this.dearomatizePlus(k, 2);
                    this.printo();
                    this.setAgain(k, ++step);
                    this.dearomatizePlus(k, 1);
                    this.printo();
                }
            }
            this.setAgain(++k, ++step);
        }
        return this.DEARA_FLAG;
    }

    private void printo() {
        Molecule mzperx = (Molecule)this.mol;
        System.err.println("acount= " + this.aCount + "  " + mzperx.toFormat("smiles"));
    }

    private void setAgain(int bondCount, int step) {
        if (bondCount < this.keyb.length && this.keyb[bondCount] != null) {
            this.setMolecule(this.oMol[step]);
            this.setRings();
            this.initDearoma();
            this.setKeyBonds();
        }
    }

    private void setMolecule(MoleculeGraph m) {
        this.mol = m.getGraphUnion();
    }

    private boolean dearomatizePlus() {
        this.initDearoma();
        if (this.aCount == 0) {
            return this.DEARA_FLAG;
        }
        this.setAraBonds();
        return this.DEARA_FLAG;
    }

    private boolean dearomatizePlus(int indx, int bt) {
        if (this.aCount == 0) {
            return this.DEARA_FLAG;
        }
        this.setPredefinedBond(indx, bt);
        this.setAraBonds();
        return this.DEARA_FLAG;
    }

    private void setRings() {
        this.rings = this.mol.getSSSR();
    }

    private void print() {
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                System.err.println("a1= " + (i + 1) + " " + "a2=" + " " + (nb + 1) + "  " + this.newbHtab[i][j]);
            }
        }
    }

    private void initDearoma() {
        int i;
        this.atomCount = this.mol.getAtomCount();
        this.fixed = new int[this.atomCount];
        this.atomArray = this.mol.getAtomArray();
        this.spiroArA = new boolean[this.atomCount];
        this.tArA = new boolean[this.atomCount];
        this.araAtom = new int[this.atomCount];
        this.fAraIsland = new int[this.atomCount];
        for (int w = 0; w < this.atomCount; ++w) {
            this.fAraIsland[w] = -1;
        }
        this.fixingCount = 0;
        this.DEARA_FLAG = Boolean.TRUE;
        this.aCount = 0;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.atomArray[i].hasAromaticBond()) {
                ++this.aCount;
                this.fixed[i] = -100;
                this.spiroArA[i] = false;
                this.tArA[i] = false;
                this.araAtom[i] = 1;
                continue;
            }
            this.fixed[i] = 1;
        }
        this.expectedBC = new int[this.atomCount][2];
        this.expectedPieC = new int[this.atomCount];
        if (this.aCount == 0) {
            return;
        }
        this.cHtab = this.mol.createCHtab();
        this.bHtab = this.mol.createBHtab();
        this.newbHtab = new int[this.atomCount][];
        this.crossArA = new int[this.atomCount];
        for (i = 0; i < this.atomCount; ++i) {
            if (this.araAtom[i] != 1) continue;
            this.setCrossAraAtom(i);
        }
        boolean Fog = false;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            this.newbHtab[i2] = new int[this.cHtab[i2].length];
            for (int j = 0; j < this.cHtab[i2].length; ++j) {
                int nb = this.cHtab[i2][j];
                if (nb < this.atomCount && nb >= 0) {
                    int bt = this.mol.getBond(this.bHtab[i2][nb]).getType();
                    if (bt == 4) {
                        this.newbHtab[i2][j] = -100;
                        Fog = true;
                        continue;
                    }
                    this.newbHtab[i2][j] = bt;
                    continue;
                }
                this.newbHtab[i2][j] = 1;
            }
        }
        if (!Fog) {
            return;
        }
        this.setExpectedAraBondCount();
        if (this.huckelCheck && !this.checkHuckelRule()) {
            return;
        }
    }

    private boolean checkHuckelRule() {
        int i;
        this.islandCount = 0;
        int[] goodIslandIdx = new int[this.aCount / 3];
        for (i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i) || this.fAraIsland[i] != -1) continue;
            this.actPieCount = 0;
            this.setFogyIsland(i, this.islandCount);
            boolean failed = false;
            if (!this.isAraSystem(this.islandCount)) {
                failed = true;
            } else if (this.actPieCount % 4 != 2 && !this.isHuckelRuleSatisFied(this.islandCount)) {
                failed = true;
            }
            if (!failed) {
                goodIslandIdx[this.islandCount] = 1;
            }
            ++this.islandCount;
        }
        for (i = 0; i < this.islandCount; ++i) {
            if (goodIslandIdx[i] != 1) continue;
            for (int j = 0; j < this.atomCount; ++j) {
                if (this.fAraIsland[j] != i) continue;
                this.fAraIsland[j] = -1;
            }
        }
        return true;
    }

    private void setKeyBonds() {
        int k = 0;
        this.keyb = new MolBond[this.aCount];
        this.keyBtype = new int[this.aCount];
        boolean[] used = new boolean[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            used[i] = false;
        }
        for (int j = 0; j < this.atomCount; ++j) {
            if (!this.isArA(j) || used[j] || this.crossArA[j] == 1 || this.expectedBC[j][1] == 0) continue;
            for (int i = 0; i < this.cHtab[j].length; ++i) {
                MolBond b;
                int nb = this.cHtab[j][i];
                if (!this.isArA(nb) || used[nb] || (b = this.mol.getBond(this.bHtab[j][nb])).getType() != 4 || this.crossArA[nb] == 1 || this.expectedBC[nb][1] == 0) continue;
                used[j] = true;
                used[nb] = true;
                if (!this.isRightRing(j)) continue;
                this.keyb[k] = b;
                this.keyBtype[k] = this.getKeyBtype(j, nb);
                ++k;
            }
        }
    }

    private boolean isCrossRight(int a1, int a2) {
        if (this.crossArA[a1] == 1 && this.crossArA[a2] == 1) {
            return true;
        }
        if (this.crossArA[a1] == 1) {
            return false;
        }
        return this.crossArA[a2] != 1;
    }

    private int getKeyBtype(int a1, int a2) {
        boolean c1 = false;
        boolean c2 = false;
        if (this.expectedBC[a1][1] != 0 && this.expectedBC[a2][1] != 0) {
            c2 = true;
        }
        if (this.expectedBC[a1][0] != 0 && this.expectedBC[a2][0] != 0) {
            c1 = true;
        }
        if (c2 && c1) {
            return 3;
        }
        if (c2) {
            return 2;
        }
        if (c1) {
            return 1;
        }
        return 1;
    }

    private boolean isRightRing(int ai) {
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.rings[i][j] != ai || this.rings[i].length == 5) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAraSystem(int indx) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.fAraIsland[i] != indx) continue;
            if (!this.isInRing(i)) {
                return false;
            }
            int c = 0;
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                if (nb >= this.atomCount || !this.isArA(nb)) continue;
                ++c;
            }
            if (c >= 2) continue;
            return false;
        }
        return true;
    }

    private boolean isInRing(int ai) {
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                if (this.rings[i][j] != ai) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHuckelRuleSatisFied(int indx) {
        for (int i = 0; i < this.rings.length; ++i) {
            int ec = 0;
            int L = 0;
            for (int j = 0; j < this.rings[i].length; ++j) {
                int ai = this.rings[i][j];
                if (this.fAraIsland[ai] != indx) continue;
                ++L;
                ec += this.expectedPieC[ai];
            }
            if (L != this.rings[i].length || ec % 4 == 2) continue;
            return false;
        }
        return true;
    }

    private void setExpectedAraBondCount() {
        this.UNKNOWN_ATOM = false;
        for (int i = 0; i < this.atomCount; ++i) {
            int ac;
            if (!this.isArA(i)) continue;
            int pc = this.atomArray[i].getAtno();
            int chg = this.atomArray[i].getCharge();
            int L = this.cHtab[i].length;
            if (pc == 6 || pc == 14) {
                if (chg == -1) {
                    if (L == 3) {
                        if (this.getAraNbCount(i) == 3) {
                            this.expectedBC[i][0] = 3;
                            this.expectedPieC[i] = 2;
                        } else {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        }
                    }
                } else if (chg == 1) {
                    if (L == 3) {
                        if (this.getAraNbCount(i) == 3) {
                            this.expectedBC[i][0] = 3;
                            this.expectedPieC[i] = 0;
                        } else {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 0;
                        }
                    }
                } else if (chg == 0 && L == 3 && this.isArAOxideLike(i)) {
                    ac = this.getAraNbCount(i);
                    this.expectedBC[i][0] = ac == 2 ? 2 : 1;
                    MolAtom a = this.mol.getAtom(this.AraOxNb);
                    this.expectedPieC[i] = a.getAtno() == 6 ? 1 : 0;
                }
            } else if (pc == 16) {
                if (chg == 0 && L == 2) {
                    ac = this.getAraNbCount(i);
                    if (ac == 2) {
                        if (!this.isRadical(i)) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        }
                    } else {
                        this.expectedBC[i][0] = 1;
                        this.expectedPieC[i] = 0;
                    }
                }
            } else if (pc == 8) {
                if (chg == 0) {
                    if (L == 2) {
                        ac = this.getAraNbCount(i);
                        if (ac == 2) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        } else {
                            this.expectedBC[i][0] = 1;
                            this.expectedPieC[i] = 0;
                        }
                    } else if (L == 1) {
                        this.expectedBC[i][0] = 0;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                    }
                }
            } else if (pc == 7) {
                if (chg == 0) {
                    if (L == 3) {
                        if (this.getAraNbCount(i) == 3) {
                            this.expectedBC[i][0] = 3;
                            this.expectedPieC[i] = 2;
                        } else if (!this.isArAOxideLike(i)) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        }
                    } else if (L == 2) {
                        if (this.isRadical(i)) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        }
                    } else if (L == 4) {
                        ac = this.getAraNbCount(i);
                        if (ac == 3) {
                            this.expectedBC[i][0] = 3;
                            this.expectedPieC[i] = 2;
                        } else if (ac == 2 && this.isImpHGiven(i)) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        }
                    }
                } else if (chg == -1) {
                    if (L == 2 && !this.isRadical(i)) {
                        this.expectedBC[i][0] = 2;
                        this.expectedPieC[i] = 2;
                    }
                } else if (chg == 1 && this.isArAOxideLike(i)) {
                    this.expectedBC[i][0] = 2;
                    this.expectedPieC[i] = 0;
                }
            } else if (pc == 34 || pc == 52) {
                if (chg == 0) {
                    if (L == 2) {
                        ac = this.getAraNbCount(i);
                        if (ac == 2) {
                            this.expectedBC[i][0] = 2;
                            this.expectedPieC[i] = 2;
                        } else {
                            this.expectedBC[i][0] = 1;
                            this.expectedPieC[i] = 0;
                        }
                    } else if (L == 4) {
                        ac = this.getAraNbCount(i);
                        if (ac == 3) {
                            this.expectedBC[i][0] = 3;
                            this.expectedPieC[i] = 2;
                        } else if (ac == 4) {
                            this.expectedBC[i][0] = 4;
                            this.expectedPieC[i] = 2;
                        }
                    }
                }
            } else if (pc == 5) {
                if (chg == 0 && L == 3) {
                    if (this.getAraNbCount(i) == 3) {
                        this.expectedBC[i][0] = 3;
                        this.expectedPieC[i] = 0;
                    } else {
                        this.expectedBC[i][0] = 2;
                        this.expectedPieC[i] = 0;
                    }
                }
            } else if (pc == 33) {
                if (chg == 0 && L == 4 && this.getAraNbCount(i) == 3) {
                    this.expectedBC[i][0] = 3;
                    this.expectedPieC[i] = 2;
                }
            } else if (pc == 15) {
                if (L == 5) {
                    this.expectedBC[i][0] = 4;
                    this.expectedBC[i][1] = 0;
                    this.expectedPieC[i] = 0;
                } else if (L == 3) {
                    if (this.getAraNbCount(i) == 3) {
                        this.expectedBC[i][0] = 3;
                        this.expectedPieC[i] = 2;
                    } else if (!this.isArAOxideLike(i)) {
                        this.expectedBC[i][0] = 2;
                        this.expectedPieC[i] = 2;
                    }
                }
            }
            if (this.expectedBC[i][0] != 0) continue;
            if (pc == 6 || pc == 14 || pc == 112) {
                if (chg == -1) {
                    if (L != 2) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg == 1) {
                    if (L != 2) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != 0) continue;
                ac = this.getAraNbCount(i);
                if (ac == 3) {
                    this.expectedBC[i][0] = 2;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (ac == 1) {
                    if (this.isArAOxideLike(i)) {
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 0;
                        this.expectedPieC[i] = 0;
                        continue;
                    }
                    if (L == 4) {
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 0;
                        this.expectedPieC[i] = 0;
                        continue;
                    }
                    this.expectedBC[i][0] = 0;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (ac >= 3 || this.isArAOxideLike(i)) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 16) {
                if (chg == 1) {
                    ac = this.getAraNbCount(i);
                    if (L == 2) {
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L == 3 && ac == 2) {
                        this.expectedBC[i][0] = 2;
                        this.expectedPieC[i] = 2;
                        continue;
                    }
                    if (L != 3 || ac != 3) continue;
                    this.expectedBC[i][0] = 3;
                    this.expectedPieC[i] = 0;
                    continue;
                }
                if (chg != 0) continue;
                ac = this.getAraNbCount(i);
                if (ac == 3) {
                    this.expectedBC[i][0] = 2;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (L == 3 && this.isArAOxideLike(i)) {
                    this.expectedBC[i][0] = 2;
                    this.expectedPieC[i] = 2;
                    continue;
                }
                if (L == 4 && this.isArAOxideLike(i)) {
                    this.expectedBC[i][0] = 2;
                    this.expectedPieC[i] = 0;
                    continue;
                }
                if (ac == 2 && L == 3) {
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (!this.isRadical(i) || ac != 2 || L != 2) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 8) {
                if (chg != 1 || L != 2) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 7) {
                if (chg == 0) {
                    if (L == 2) {
                        ac = this.getAraNbCount(i);
                        if (ac == 1) {
                            this.expectedBC[i][0] = 0;
                            this.expectedBC[i][1] = 1;
                            this.expectedPieC[i] = 1;
                            continue;
                        }
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L == 3) {
                        if (!this.isArAOxideLike(i)) continue;
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L != 4) continue;
                    ac = this.getAraNbCount(i);
                    if (ac == 3) {
                        this.expectedBC[i][0] = 2;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (ac >= 3) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg == 1) {
                    if (L != 3) continue;
                    ac = this.getAraNbCount(i);
                    if (ac == 1) {
                        this.expectedBC[i][0] = 0;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (ac == 3) {
                        this.expectedBC[i][0] = 2;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != -1 || L != 2 || !this.isRadical(i)) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 34 || pc == 52) {
                if (chg == 1) {
                    if (L != 2) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != 0 || L != 3) continue;
                if (this.getAraNbCount(i) == 3) {
                    this.expectedBC[i][0] = 2;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 5) {
                if (chg == 0) {
                    if (L != 2) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != -1 || L != 3) continue;
                if (this.getAraNbCount(i) == 3) {
                    this.expectedBC[i][0] = 2;
                    this.expectedBC[i][1] = 1;
                    continue;
                }
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 33) {
                if (chg == 0) {
                    if (L == 2) {
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L == 3) {
                        if (!this.isArAOxideLike(i)) continue;
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L != 4 || (ac = this.getAraNbCount(i)) != 2) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg == 1) {
                    if (L != 3) continue;
                    if (this.getAraNbCount(i) == 3) {
                        this.expectedBC[i][0] = 2;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != -1 || L != 3 || this.getAraNbCount(i) != 2) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            if (pc == 15) {
                if (chg == 0) {
                    if (L == 2) {
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L == 3) {
                        if (!this.isArAOxideLike(i)) continue;
                        this.expectedBC[i][0] = 1;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    if (L != 4) continue;
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg == 1) {
                    if (L != 3) continue;
                    if (this.getAraNbCount(i) == 3) {
                        this.expectedBC[i][0] = 2;
                        this.expectedBC[i][1] = 1;
                        this.expectedPieC[i] = 1;
                        continue;
                    }
                    this.expectedBC[i][0] = 1;
                    this.expectedBC[i][1] = 1;
                    this.expectedPieC[i] = 1;
                    continue;
                }
                if (chg != -1 || L != 3 || this.getAraNbCount(i) != 2) continue;
                this.expectedBC[i][0] = 1;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                continue;
            }
            this.UNKNOWN_ATOM = true;
        }
    }

    private boolean setFixableSingleAraBond() {
        this.fixingFlag = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i) || this.fixed[i] == 1) continue;
            if (this.expectedBC[i][0] != 0 && this.expectedBC[i][1] == 0) {
                this.setSingleOrDoubleBond(i, this.expectedBC[i][0], 1);
            } else if (this.expectedBC[i][0] == 0 && this.expectedBC[i][1] != 0) {
                this.setSingleOrDoubleBond(i, this.expectedBC[i][1], 2);
            }
            if (!this.isFixedAtom(i)) continue;
            this.fixed[i] = 1;
            this.fixingFlag = true;
            ++this.fixingCount;
            return true;
        }
        return false;
    }

    private void setPredefinedBond(int indx, int bt) {
        this.fixingFlag = false;
        MolAtom a = this.keyb[indx].getAtom1();
        MolAtom aa = this.keyb[indx].getAtom2();
        int ai = this.mol.indexOf(a);
        int aai = this.mol.indexOf(aa);
        System.err.println(indx + "  a1=" + ai + " a2=" + aai);
        if (bt == 2) {
            this.setPreBond(ai, aai, 2);
        } else if (bt == 1) {
            this.setPreBond(ai, aai, 1);
        }
    }

    private void setFixableDoubleAraBonds() {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.crossArA[i] != 1 || this.expectedBC[i][0] == 0 || this.expectedBC[i][1] == 0 || this.cHtab[i].length != 3) continue;
            int a = -1;
            int c = 0;
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                if (nb >= this.atomCount || nb < 0 || !this.isArA(nb)) continue;
                if (this.expectedBC[nb][0] != 0 && this.expectedBC[nb][1] == 0) {
                    if (this.mol.getBond(this.bHtab[nb][i]).getType() != 4) continue;
                    ++c;
                    continue;
                }
                if (this.mol.getBond(this.bHtab[nb][i]).getType() != 4) continue;
                a = nb;
            }
            if (c != 2 || a == -1) continue;
            this.newbHtab[i][this.getIndex((int)i, (int)a)] = 2;
            this.newbHtab[a][this.getIndex((int)a, (int)i)] = 2;
        }
    }

    private boolean isImpHGiven(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            if (this.cHtab[ai][i] < this.atomCount) continue;
            return true;
        }
        return false;
    }

    private boolean isRadical(int ai) {
        return this.atomArray[ai].getRadical() != 0;
    }

    private void setFixableTerminalBond() {
        for (int i = 0; i < this.atomCount; ++i) {
            int ind;
            if (this.fixed[i] == 1 || !this.isArA(i) || this.expectedBC[i][0] != 0 || this.expectedBC[i][1] != 1 || (ind = this.getAraNbInd(i)) == -1 || this.isCrossAraEnding(i)) continue;
            int nb = this.cHtab[i][ind];
            if (this.isNbCorrect(i)) {
                this.newbHtab[i][ind] = 2;
                this.newbHtab[nb][this.getIndex((int)nb, (int)i)] = 2;
                this.fixingFlag = true;
                this.fixed[i] = 1;
                this.expectedBC[i][0] = 0;
                this.expectedBC[i][1] = 1;
                this.expectedPieC[i] = 1;
                if (!this.isFixedAtom(nb)) continue;
                this.fixed[nb] = 1;
                this.expectedPieC[nb] = 1;
                continue;
            }
            this.newbHtab[i][ind] = 1;
            this.newbHtab[nb][this.getIndex((int)nb, (int)i)] = 1;
            this.fixingFlag = true;
            this.fixed[i] = 1;
            this.expectedBC[i][0] = 1;
            this.expectedBC[i][1] = 0;
            this.expectedPieC[i] = 1;
            if (!this.isFixedAtom(nb)) continue;
            this.fixed[nb] = 1;
            this.expectedPieC[nb] = 1;
        }
    }

    private int getAraNbInd(int tara) {
        int c = 0;
        int ind = -1;
        for (int i = 0; i < this.cHtab[tara].length; ++i) {
            int nb = this.cHtab[tara][i];
            if (!this.isArA(nb) || this.mol.getBond(this.bHtab[tara][nb]).getType() != 4) continue;
            ++c;
            ind = i;
        }
        if (c == 1) {
            return ind;
        }
        return ind;
    }

    private void setAraBonds() {
        this.setFixableSingleAraBond();
        this.setFixableTerminalBond();
        this.setFixableDoubleAraBonds();
        int cycle = 0;
        boolean fixable = true;
        boolean doAgain = true;
        if (!this.fixingFlag) {
            this.setStartAtom();
        }
        while (doAgain) {
            this.fixingFlag = false;
            for (int i = 0; i < this.atomCount; ++i) {
                fixable = false;
                if (this.fixed[i] != 1 && this.isArA(i)) {
                    fixable = this.isNbFixed(i);
                    if (this.missedAra) {
                        fixable = false;
                    }
                }
                if (!fixable) continue;
                this.setNotFixedAraBonds(i);
            }
            doAgain = false;
            for (int k = 0; k < this.atomCount && !doAgain; ++k) {
                if (!this.isArA(k) || this.fixed[k] == 1) continue;
                doAgain = true;
            }
            if (doAgain && !this.fixingFlag) {
                this.setStartAtom();
            }
            if (this.aCount == this.fixingCount) {
                doAgain = false;
            }
            if (++cycle <= this.aCount) continue;
            doAgain = false;
        }
        this.DearaFailed = new int[this.atomCount];
        int aInd = 0;
        if (!this.isBondSettingCorrect()) {
            aInd = 0;
            for (int y = 0; y < this.atomCount; ++y) {
                if (!this.isArA(y) || this.DearaFailed[y] != 1) continue;
                if (this.fAraIsland[y] == -1) {
                    this.setFogyIsland(y, aInd);
                }
                ++aInd;
            }
        }
        this.setBonds();
        this.mol.valenceCheck();
    }

    private boolean isAraBondExist(int a1, int a2) {
        try {
            if (this.mol.getBond(this.bHtab[a1][a2]).getType() == 4) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private boolean isBondSettingCorrect() {
        this.DearaFailed = new int[this.atomCount];
        boolean f = true;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i)) continue;
            int s = 0;
            int d = 0;
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int bto;
                int nb = this.cHtab[i][j];
                if (!this.isArA(nb) || (bto = this.mol.getBond(this.bHtab[i][nb]).getType()) != 4) continue;
                int bt = this.newbHtab[i][j];
                if (bt == 1) {
                    ++s;
                    continue;
                }
                if (bt != 2) continue;
                ++d;
            }
            if (this.expectedBC[i][0] == s && this.expectedBC[i][1] == d) continue;
            this.DearaFailed[i] = 1;
            f = false;
        }
        return f;
    }

    private void setFogyIsland(int atom, int aInd) {
        int actAtom = atom;
        int sphereSize = 0;
        int[] dist = new int[this.atomCount];
        int[] sphere = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            sphere[i] = -1;
        }
        this.fAraIsland[atom] = aInd;
        this.actPieCount += this.expectedPieC[atom];
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < this.atomCount + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.atomCount || sphereAtom < 0 || !(dist[sphereAtom] == 0 & sphereAtom != atom) || !this.isArA(sphereAtom) || this.spiroArA[sphereAtom] || this.mol.getBond(this.bHtab[sphereAtom][actAtom]).getType() != 4) continue;
                    dist[sphereAtom] = distance;
                    sphere[sphereSize] = sphereAtom;
                    this.fAraIsland[sphereAtom] = aInd;
                    this.actPieCount += this.expectedPieC[sphereAtom];
                    ++sphereSize;
                }
            }
            if (sphere[i] != -1) {
                actAtom = sphere[i];
                distance = dist[actAtom] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
    }

    private boolean setMinusChgAraAtoms() {
        boolean find = false;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i)) continue;
            int pc = this.atomArray[i].getAtno();
            int chg = this.atomArray[i].getCharge();
            if (chg == -1) {
                int L;
                if (pc == 7) {
                    if (this.expectedBC[i][0] != 2) continue;
                    this.setSingleOrDoubleBond(i, 2, 1);
                    if (!this.isFixedAtom(i)) continue;
                    find = true;
                    continue;
                }
                if (pc != 6 || (L = this.expectedBC[i][0]) != 2 && L != 3) continue;
                this.setSingleOrDoubleBond(i, L, 1);
                if (!this.isFixedAtom(i)) continue;
                find = true;
                continue;
            }
            if (chg == 1) {
                if (pc != 6 || this.expectedBC[i][0] != 3) continue;
                this.setSingleOrDoubleBond(i, 3, 1);
                if (!this.isFixedAtom(i)) continue;
                find = true;
                continue;
            }
            if (chg != 0 || pc != 6 || !this.isArAOxideLike(i) || this.expectedBC[i][0] != 2) continue;
            this.setSingleOrDoubleBond(i, 2, 1);
            if (!this.isFixedAtom(i)) continue;
            find = true;
        }
        return false;
    }

    private void setStartAtom() {
        if (this.setMinusChgAraAtoms()) {
            return;
        }
        if (this.setXDBBond(false)) {
            return;
        }
        if (this.setFixableSingleAraBond()) {
            return;
        }
        if (this.setSimpleDBond1()) {
            return;
        }
        if (this.setSimpleDBond11()) {
            return;
        }
        if (this.setSimpleDBond2()) {
            return;
        }
        if (this.setEmptyDBCrossBond()) {
            return;
        }
    }

    private boolean isBondedYet(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int a = this.cHtab[ai][i];
            if (a >= this.atomCount || a < 0 || this.newbHtab[ai][this.getIndex(ai, a)] == -100 || this.mol.getBond(this.bHtab[ai][a]).getType() != 4) continue;
            return true;
        }
        return false;
    }

    private boolean isCrossAraEnding(int ai) {
        int ac = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 4) continue;
            if (this.getAraNbCount(nb) >= 3) {
                return true;
            }
            ++ac;
        }
        return ac > 3;
    }

    private void setNotFixedAraBonds(int i) {
        this.setSingleOrDoubleBond(i, this.expectedBC[i][0], 1);
        this.setSingleOrDoubleBond(i, this.expectedBC[i][1], 2);
        if (this.isFixedAtom(i)) {
            this.fixed[i] = 1;
            this.fixingFlag = true;
            ++this.fixingCount;
        }
    }

    private boolean isNbFixed(int ai) {
        int c = 0;
        this.missedAra = false;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            int b = this.newbHtab[ai][i];
            if (b == -100) continue;
            if (b == 2) {
                this.missedAra = false;
                if (!this.isArA(nb)) {
                    if (this.atomArray[ai].getAtno() == 6) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            if (nb < this.atomCount && nb >= 0 && this.spiroArA[nb]) {
                this.missedAra = true;
            }
            ++c;
        }
        if (c >= 2) {
            return true;
        }
        return c == 1 && this.cHtab[ai].length == 2;
    }

    private void setCrossAraAtom(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 4) continue;
            ++c;
        }
        if (c >= 3) {
            this.crossArA[ai] = 1;
        }
    }

    private boolean setEmptyDBCrossBond() {
        for (int j = 0; j < this.atomCount; ++j) {
            if (this.crossArA[j] != 1) continue;
            for (int i = 0; i < this.cHtab[j].length; ++i) {
                int nb = this.cHtab[j][i];
                if (!this.isArA(nb) || this.mol.getBond(this.bHtab[j][nb]).getType() != 4 || this.crossArA[nb] != 1 || this.newbHtab[j][i] != -100) continue;
                this.newbHtab[j][i] = 2;
                int ind = this.getIndex(nb, j);
                this.newbHtab[nb][ind] = 2;
                return true;
            }
        }
        return false;
    }

    private boolean setSimpleDBond1() {
        for (int j = 0; j < this.atomCount; ++j) {
            if (!this.isArA(j) || this.crossArA[j] == 1 || this.expectedBC[j][1] == 0 || this.isNoCrossNbExist(j) || this.isBondedYet(j)) continue;
            for (int i = 0; i < this.cHtab[j].length; ++i) {
                int nb = this.cHtab[j][i];
                if (!this.isArA(nb) || this.mol.getBond(this.bHtab[j][nb]).getType() != 4 || this.crossArA[nb] == 1 || this.expectedBC[nb][1] == 0 || this.isNoCrossNbExist(nb) || this.isBondedYet(nb)) continue;
                this.newbHtab[j][i] = 2;
                int ind = this.getIndex(nb, j);
                this.newbHtab[nb][ind] = 2;
                return true;
            }
        }
        return false;
    }

    private boolean setSimpleDBond11() {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i) || this.crossArA[i] != 1 || this.expectedBC[i][1] == 0 || this.cHtab[i].length != 3) continue;
            boolean cond1 = false;
            boolean cond2 = false;
            int k = 0;
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                if (this.crossArA[nb] == 1 && (this.crossArA[nb] != 1 || this.fixed[nb] != 1)) continue;
                if (this.fixed[nb] == 1) {
                    cond1 = true;
                    continue;
                }
                cond2 = true;
                k = nb;
            }
            if (!cond1 || !cond2) continue;
            int ind = this.getIndex(i, k);
            this.newbHtab[i][ind] = 2;
            ind = this.getIndex(k, i);
            this.newbHtab[k][ind] = 2;
            return true;
        }
        return false;
    }

    private boolean setSimpleDBond2() {
        for (int j = 0; j < this.atomCount; ++j) {
            if (!this.isArA(j) || this.crossArA[j] == 1 || this.expectedBC[j][1] == 0 || this.isBondedYet(j)) continue;
            for (int i = 0; i < this.cHtab[j].length; ++i) {
                int nb = this.cHtab[j][i];
                if (!this.isArA(nb) || this.mol.getBond(this.bHtab[j][nb]).getType() != 4 || this.crossArA[nb] == 1 || this.expectedBC[nb][1] == 0 || this.isBondedYet(nb)) continue;
                this.newbHtab[j][i] = 2;
                int ind = this.getIndex(nb, j);
                this.newbHtab[nb][ind] = 2;
                return true;
            }
        }
        return false;
    }

    private boolean isNoCrossNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || this.mol.getBond(this.bHtab[ai][nb]).getType() != 4 || this.crossArA[nb] != 1) continue;
            return true;
        }
        return false;
    }

    private boolean setXDBBond(boolean allowed) {
        int indx;
        int c = 0;
        int k = 0;
        int ai = 0;
        int a = 0;
        int id = 0;
        int b_a = -1;
        int b_id = -1;
        int b_ai = -1;
        boolean exit = false;
        for (int w = 0; w < this.atomCount && !exit; ++w) {
            if (!this.isArA(w) || this.atomArray[w].getAtno() == 6 || this.expectedBC[w][1] == 0 || this.isBondedYet(w) || this.fixed[w] == 1) continue;
            c = 0;
            k = 0;
            for (int i = 0; i < this.cHtab[w].length; ++i) {
                int nb = this.cHtab[w][i];
                if (!this.isArA(nb) || this.mol.getBond(this.bHtab[w][nb]).getType() != 4 || this.crossArA[nb] != 1 || this.expectedBC[nb][1] == 0 || this.fixed[nb] == 1) continue;
                if (this.isBondedYet(nb)) {
                    a = nb;
                    id = i;
                    ai = w;
                    ++k;
                }
                if (c == 0) {
                    a = nb;
                    id = i;
                    ai = w;
                }
                ++c;
            }
            if (c < 2 || k == 0) continue;
            b_a = a;
            b_ai = ai;
            b_id = id;
            exit = true;
        }
        if (b_id != -1) {
            a = b_a;
            ai = b_ai;
            id = b_id;
        }
        if (!allowed && c >= 2 && k != 0) {
            this.newbHtab[ai][id] = 2;
            indx = this.getIndex(a, ai);
            this.newbHtab[a][indx] = 2;
            return true;
        }
        if (allowed && c >= 2) {
            this.newbHtab[ai][id] = 2;
            indx = this.getIndex(a, ai);
            this.newbHtab[a][indx] = 2;
            return true;
        }
        return false;
    }

    private int getAraNbCount(int ai) {
        int c = 0;
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int bt;
            int nb = this.cHtab[ai][i];
            if (!this.isArA(nb) || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 4) continue;
            ++c;
        }
        return c;
    }

    private void setSingleOrDoubleBond(int ai, int c, int type) {
        int nb;
        int cc = 0;
        int i = 0;
        for (int k = 0; k < this.cHtab[ai].length; ++k) {
            int bt;
            nb = this.cHtab[ai][k];
            if (!this.isArA(nb) || (bt = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 4 || this.newbHtab[ai][k] != type) continue;
            --c;
        }
        int oldType = type;
        while (i < this.cHtab[ai].length && cc < c) {
            nb = this.cHtab[ai][i];
            if (nb < this.atomCount && nb >= 0 && this.isArA(nb) && this.newbHtab[ai][i] == -100) {
                this.newbHtab[ai][i] = type;
                int ind = this.getIndex(nb, ai);
                this.newbHtab[nb][ind] = type;
                if (this.isFixedAtom(nb)) {
                    this.fixed[nb] = 1;
                    this.fixingFlag = true;
                    ++this.fixingCount;
                }
                type = oldType;
                ++cc;
            }
            ++i;
        }
    }

    private void setPreBond(int a1, int a2, int type) {
        int ind = this.getIndex(a1, a2);
        this.newbHtab[a1][ind] = type;
        ind = this.getIndex(a2, a1);
        this.newbHtab[a2][ind] = type;
        if (this.isFixedAtom(a1)) {
            this.fixed[a1] = 1;
            this.fixingFlag = true;
            ++this.fixingCount;
        }
        if (this.isFixedAtom(a2)) {
            this.fixed[a2] = 1;
            this.fixingFlag = true;
            ++this.fixingCount;
        }
    }

    private boolean isNbCorrect(int nb) {
        int eDc = this.expectedBC[nb][1];
        int aSc = 0;
        int aDc = 0;
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            int nnb = this.cHtab[nb][i];
            if (!this.isArA(nnb) || this.mol.getBond(this.bHtab[nnb][nb]).getType() != 4) continue;
            int bt = this.newbHtab[nb][i];
            if (bt == 2) {
                ++aDc;
                continue;
            }
            if (bt != 1) continue;
            ++aSc;
        }
        return aDc != eDc;
    }

    private boolean isFixedAtom(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            if (this.newbHtab[ai][i] != -100) continue;
            return false;
        }
        return true;
    }

    private int getIndex(int nb, int ai) {
        for (int i = 0; i < this.cHtab[nb].length; ++i) {
            if (this.cHtab[nb][i] != ai) continue;
            return i;
        }
        return 0;
    }

    private boolean isArAOxideLike(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int b;
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || nb < 0 || this.isAraBondExist(nb, ai) || (b = this.mol.getBond(this.bHtab[ai][nb]).getType()) != 2) continue;
            this.AraOxNb = nb;
            return true;
        }
        return false;
    }

    private boolean isArA(int ai) {
        if (ai >= this.atomCount) {
            return false;
        }
        if (ai < 0) {
            return false;
        }
        return this.araAtom[ai] == 1;
    }

    private void setBonds() {
        boolean change = false;
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int nb = this.cHtab[i][j];
                if (!this.isArA(nb) || !this.isArA(i)) continue;
                if (this.fAraIsland[nb] == -1 && this.fAraIsland[i] == -1) {
                    int bt = this.newbHtab[i][j];
                    if (bt == -100) continue;
                    MolBond actBond = this.mol.getBond(this.bHtab[i][nb]);
                    int actBFlag = actBond.getFlags() & 0xFFFFFFF0 & 0xFFFFFC0F;
                    actBond.setFlags(actBFlag | bt);
                    change = true;
                    continue;
                }
                this.DEARA_FLAG = Boolean.FALSE;
            }
        }
        if (change) {
            this.mol.incGrinvCCOnly();
        }
    }
}

