/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;

public class LonePairCounter {
    private MoleculeGraph mol;
    private MolAtom[] atomArray;
    private int[][] bHtab;
    private int[][] cHtab;
    private int atomCount;
    int actPCount;
    private int[] implicitNBEC;
    private int[] implicitEPC;
    private int[] implicitRC;
    private int[] explicitNBEC;
    private int[] explicitEPC;
    private int[] explicitRC;
    private int[] explicitBEC;
    private int[] allNBEC;
    private int[] allEC;
    private int[] allEPC;
    boolean showFormaCharge = false;
    boolean mfls = false;
    boolean showRadical = false;
    private int[] araAtom;
    private int[] corr;
    boolean METAL;
    boolean changeAble = false;
    int ImpHCount;
    private int[] formalCharge;
    int[] MGN;
    double[] EN;
    int[] initBEC;
    int[] bondCount;
    final int MINUS = -1;
    final int PLUS = 1;
    final int ZERO = 0;
    final int SUCCESS = 1;
    final int UNSUCCESS = 0;
    int[][] di;
    int[] delocAble;
    int sphereSize;
    int[] sAtom;
    public static final int IDE = -2;
    public static final int UIDE = -1;
    public static final int NEUTRAL = 0;
    public static final int YLIUM = 1;
    public static final int IUM = 2;
    public static final int IUM_YLIUM = 3;

    public int[] getLonePairCount(MoleculeGraph mg) {
        if (this.mol == null) {
            this.mol = mg;
            this.calcLonePairCount();
        }
        return this.implicitEPC;
    }

    public int[] getExplicitLonePairCount(MoleculeGraph mg) {
        if (this.mol == null) {
            this.mol = mg;
            this.calcLonePairCount();
        }
        return this.explicitEPC;
    }

    public int[] getImplicitRadicalCount(MoleculeGraph mg) {
        if (this.mol == null) {
            this.mol = mg;
            this.calcLonePairCount();
        }
        return this.implicitRC;
    }

    public void setMolecule(MoleculeGraph m) {
        this.mol = m;
    }

    public void calcLonePairCount() {
        this.initLonePairCount();
        this.calcLoneElectronCount();
        this.setLonePairCount();
    }

    public int[] getImplicitLonePairCount() {
        return this.implicitEPC;
    }

    public int[] getExplicitLonePairCount() {
        return this.explicitEPC;
    }

    public int[] getImplicitRadicalCount() {
        return this.implicitRC;
    }

    public int[] getExplicitRadicalCount() {
        return this.explicitRC;
    }

    public int[] getImplictNBECounts() {
        return this.implicitNBEC;
    }

    public int[] getExplicitNBECounts() {
        return this.explicitNBEC;
    }

    public int[] getNBECounts() {
        return this.allNBEC;
    }

    public int[] getAllEC() {
        return this.allEC;
    }

    public int[] getLonePairCount() {
        return this.allEPC;
    }

    public int[] getExplicitBECounts() {
        return this.explicitBEC;
    }

    private void initLonePairCount() {
        this.atomCount = this.mol.getAtomCount();
        this.ImpHCount = this.mol.getImplicitHcount();
        this.setAromState();
        this.atomArray = this.mol.getAtomArray();
        this.bHtab = this.mol.createBHtab();
        this.cHtab = this.mol.createCHtab();
        this.implicitNBEC = new int[this.atomCount];
        this.implicitEPC = new int[this.atomCount];
        this.implicitRC = new int[this.atomCount];
        this.explicitEPC = new int[this.atomCount];
        this.explicitRC = new int[this.atomCount];
        this.explicitNBEC = new int[this.atomCount];
        this.explicitBEC = new int[this.atomCount];
        this.allNBEC = new int[this.atomCount];
        this.allEC = new int[this.atomCount];
        this.allEPC = new int[this.atomCount];
        this.formalCharge = new int[this.atomCount];
        this.initBEC = new int[this.atomCount];
        this.bondCount = new int[this.atomCount];
        this.sAtom = new int[this.atomCount];
        this.setExistingLPCount();
        this.setExisitngRadicalCount();
        this.setDelocAbleAtoms();
        this.MGN = new int[139];
        this.MGN[1] = 1;
        this.MGN[5] = 3;
        this.MGN[13] = 3;
        this.MGN[31] = 3;
        this.MGN[49] = 3;
        this.MGN[81] = 3;
        this.MGN[6] = 4;
        this.MGN[14] = 4;
        this.MGN[32] = 4;
        this.MGN[50] = 4;
        this.MGN[82] = 4;
        this.MGN[7] = 5;
        this.MGN[15] = 5;
        this.MGN[33] = 5;
        this.MGN[51] = 5;
        this.MGN[83] = 5;
        this.MGN[8] = 6;
        this.MGN[16] = 6;
        this.MGN[34] = 6;
        this.MGN[52] = 6;
        this.MGN[84] = 6;
        this.MGN[9] = 7;
        this.MGN[17] = 7;
        this.MGN[35] = 7;
        this.MGN[53] = 7;
        this.MGN[85] = 7;
        this.MGN[2] = 8;
        this.MGN[10] = 8;
        this.MGN[18] = 8;
        this.MGN[36] = 8;
        this.MGN[54] = 8;
        this.MGN[86] = 8;
        this.EN = new double[150];
        this.EN[1] = 2.1;
        this.EN[5] = 2.0;
        this.EN[6] = 2.5;
        this.EN[7] = 3.0;
        this.EN[8] = 3.5;
        this.EN[9] = 4.0;
        this.EN[17] = 3.0;
        this.EN[35] = 2.8;
        this.EN[53] = 2.5;
        this.EN[16] = 2.5;
        this.EN[34] = 2.4;
        this.EN[15] = 2.1;
        this.EN[50] = 1.8;
    }

    private void setLonePairCount() {
        int i;
        for (int i2 = 0; i2 < this.atomCount; ++i2) {
            int loneElectronPair = this.implicitNBEC[i2] / 2;
            this.implicitEPC[i2] = loneElectronPair >= 0 ? loneElectronPair : 0;
        }
        for (i = 0; i < this.atomCount; ++i) {
            int d = this.implicitNBEC[i] - 2 * this.implicitEPC[i];
            if (d < 0) continue;
            this.implicitRC[i] = this.implicitNBEC[i] - 2 * this.implicitEPC[i];
        }
        for (i = 0; i < this.atomCount; ++i) {
            this.explicitNBEC[i] = 2 * this.explicitEPC[i] + this.explicitRC[i];
            this.allNBEC[i] = this.implicitNBEC[i] + this.explicitNBEC[i];
            this.allEC[i] = this.allNBEC[i] + this.initBEC[i];
            this.allEPC[i] = this.explicitEPC[i] + this.implicitEPC[i];
            this.explicitBEC[i] = this.allEC[i] - this.explicitNBEC[i] - this.implicitNBEC[i];
        }
        if (this.showRadical) {
            this.addRadical();
        }
    }

    private void reduceRadicalAtoms() {
        int i;
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i) || this.getRequiredElectrons(i) <= 0) continue;
            this.addElectronToAcceptor(i);
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i) || this.getRequiredElectrons(i) >= 0) continue;
            this.getElectronFromDonor(i);
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i) || this.getActualCharge(i) <= 0 || this.isProtonated(i)) continue;
            this.neutralize(i);
        }
        for (i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i) || !this.isBadValenceState(i)) continue;
            this.repairBadValenceState(i);
        }
    }

    private boolean isBadValenceState(int ai) {
        int sumEc = this.getActualValenceElectronCount(ai);
        int protonCount = this.atomArray[ai].getAtno();
        return protonCount <= 10 ? sumEc > 8 : sumEc > 12;
    }

    private int getActualValenceElectronCount(int ai) {
        return this.implicitNBEC[ai] + 2 * this.explicitEPC[ai] + 2 * this.bondCount[ai] + this.explicitRC[ai];
    }

    private int getActualFreeElectronCount(int ai) {
        return this.implicitNBEC[ai] + 2 * this.explicitEPC[ai] + this.explicitRC[ai];
    }

    private void repairBadValenceState(int donor) {
        this.calcDelocPath(donor, this.atomCount);
        boolean find = false;
        for (int j = 0; j < this.sphereSize && !find; ++j) {
            int acceptor = this.sAtom[j];
            if (!this.isAcceptorChargeAble(acceptor) || !this.setnvLECChange(acceptor, donor)) continue;
            find = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setnvLECChange(int a, int d) {
        int actualCount = this.implicitNBEC[d] - 1;
        if (actualCount < 0) {
            if (this.explicitRC[d] > 0) {
                int n = d;
                this.explicitRC[n] = this.explicitRC[n] + -1;
                int n2 = a;
                this.implicitNBEC[n2] = this.implicitNBEC[n2] + 1;
                return true;
            } else {
                if (this.explicitEPC[d] <= 0) return false;
                int n = d;
                this.explicitEPC[n] = this.explicitEPC[n] + -1;
                int n3 = d;
                this.explicitRC[n3] = this.explicitRC[n3] + 1;
                int n4 = a;
                this.implicitNBEC[n4] = this.implicitNBEC[n4] + 1;
            }
            return true;
        } else {
            int n = d;
            this.implicitNBEC[n] = this.implicitNBEC[n] + -1;
            int n5 = a;
            this.implicitNBEC[n5] = this.implicitNBEC[n5] + 1;
        }
        return true;
    }

    private boolean isAcceptorChargeAble(int acceptor) {
        if (this.isHybridForbidden(acceptor)) {
            return false;
        }
        int ac = this.getActualCharge(acceptor) - 1;
        int aSign = this.getSign(ac);
        return aSign == 0 || this.isChargeAble(acceptor, aSign);
    }

    private boolean isProtonated(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) {
                int protonCount;
                if (this.isLP(nb) || (protonCount = this.atomArray[nb].getAtno()) != 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void neutralize(int acceptor) {
        this.calcDelocPath(acceptor, this.atomCount);
        boolean Find = false;
        int ap = this.atomArray[acceptor].getAtno();
        for (int j = 0; j < this.sphereSize && !Find; ++j) {
            int donor = this.sAtom[j];
            int dp = this.atomArray[donor].getAtno();
            if (!(this.EN[ap] - this.EN[dp] >= 0.5) || this.getActualCharge(donor) != 0 || !this.isAtomHasLoneElectron(donor) || this.isForbiddenCharge(acceptor, donor) || !this.setnvLECChange(acceptor, donor)) continue;
            Find = true;
        }
    }

    private boolean isAtomHasLoneElectron(int ai) {
        int sumEc = this.getActualFreeElectronCount(ai);
        return sumEc > 0;
    }

    private void addElectronToAcceptor(int acceptor) {
        int donor;
        int j;
        this.calcDelocPath(acceptor, this.atomCount);
        boolean Find = false;
        for (j = 0; j < this.sphereSize && !Find; ++j) {
            donor = this.sAtom[j];
            if (this.getRequiredElectrons(donor) >= 0 || this.isForbiddenCharge(acceptor, donor) || !this.setnvLECChange(acceptor, donor)) continue;
            Find = true;
        }
        int ap = this.atomArray[acceptor].getAtno();
        for (j = 0; j < this.sphereSize && !Find; ++j) {
            int dp;
            donor = this.sAtom[j];
            if (!this.isAtomHasLP(donor) || !(this.EN[dp = this.atomArray[donor].getAtno()] < this.EN[ap]) || this.isForbiddenCharge(acceptor, donor) || !this.setnvLECChange(acceptor, donor)) continue;
            Find = true;
        }
    }

    private boolean isAtomHasLP(int ai) {
        return this.getActualFreeElectronCount(ai) >= 2;
    }

    private void getElectronFromDonor(int donor) {
        int j;
        this.calcDelocPath(donor, this.atomCount);
        boolean Find = false;
        for (j = 0; j < this.sphereSize && !Find; ++j) {
            int acceptor = this.sAtom[j];
            if (this.getRequiredElectrons(acceptor) <= 0 || this.isForbiddenCharge(acceptor, donor) || !this.setnvLECChange(acceptor, donor)) continue;
            Find = true;
        }
        int dp = this.atomArray[donor].getAtno();
        for (j = 0; j < this.sphereSize && !Find; ++j) {
            int isDonor = this.sAtom[j];
            if (this.getRequiredElectrons(isDonor) >= 0) continue;
            int pc = this.atomArray[isDonor].getAtno();
            if (this.EN[dp] < this.EN[pc]) {
                if (this.isForbiddenCharge(isDonor, donor) || !this.setnvLECChange(isDonor, donor)) continue;
                Find = true;
                continue;
            }
            if (this.EN[dp] == this.EN[pc]) {
                if (this.implicitNBEC[donor] < this.implicitNBEC[isDonor]) {
                    if (this.isForbiddenCharge(isDonor, donor) || !this.setnvLECChange(isDonor, donor)) continue;
                    Find = true;
                    continue;
                }
                if (this.isForbiddenCharge(isDonor, donor) || !this.setnvLECChange(isDonor, donor)) continue;
                Find = true;
                continue;
            }
            if (!(this.EN[dp] > this.EN[pc]) || this.isForbiddenCharge(isDonor, donor) || !this.setnvLECChange(isDonor, donor)) continue;
            Find = true;
        }
    }

    private boolean isForbiddenCharge(int acceptor, int donor) {
        if (this.isHybridForbidden(acceptor)) {
            return true;
        }
        int ac = this.getActualCharge(acceptor) - 1;
        int aSign = this.getSign(ac);
        int dc = this.getActualCharge(donor) + 1;
        int dSign = this.getSign(dc);
        if (aSign != 0 && !this.isChargeAble(acceptor, aSign)) {
            return true;
        }
        if (dSign != 0 && !this.isChargeAble(donor, dSign)) {
            return true;
        }
        return aSign == dSign;
    }

    private int getSign(int n) {
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    private boolean isChargeAble(int ai, int refSign) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || refSign != this.getSign(this.getActualCharge(nb))) continue;
            return false;
        }
        return true;
    }

    private boolean isHybridForbidden(int acceptor) {
        int sumEc = this.getActualValenceElectronCount(acceptor);
        int protonCount = this.atomArray[acceptor].getAtno();
        return protonCount <= 10 ? sumEc + 1 > 8 : sumEc + 1 > 12;
    }

    private int getRequiredElectrons(int ai) {
        int se;
        int protonCount = this.atomArray[ai].getAtno();
        if (this.implicitNBEC[ai] == 0 && this.isTrueClosedShell(se = this.implicitNBEC[ai] + this.initBEC[ai] + this.explicitEPC[ai] + this.explicitRC[ai], protonCount)) {
            return 0;
        }
        int minEc = 2 * this.bondCount[ai];
        int sumEc = this.getActualValenceElectronCount(ai);
        int requredEc = 0;
        if (sumEc < 8) {
            requredEc = 8 - sumEc;
        } else if (sumEc == 9 || sumEc == 11) {
            requredEc = minEc < 8 ? 8 - sumEc : minEc - sumEc;
        }
        return requredEc;
    }

    private boolean isTrueClosedShell(int se, int protonCount) {
        return !(protonCount <= 10 ? se > 8 : se > 12);
    }

    private void calcLoneElectronCount() {
        int be;
        int gn;
        int i;
        for (i = 0; i < this.atomCount; ++i) {
            MolAtom a;
            if (this.isLP(i) || (a = this.atomArray[i]).getAtno() > 109) continue;
            int fc = a.getCharge();
            if (fc != 0) {
                this.formalCharge[i] = fc;
            }
            gn = this.getMainGroupNumber(i);
            if (this.actPCount == 2) {
                gn = 2;
            }
            if (this.METAL) continue;
            this.initBEC[i] = be = this.getBondingElectrons(i, this.formalCharge[i]);
            int requiredElectronCount = (int)((double)(gn - this.formalCharge[i]) - 0.5 * (double)be - (double)(2 * this.explicitEPC[i]) - (double)this.explicitRC[i]);
            if (this.araAtom[i] != 0 && this.changeAble && !this.isArA(i)) {
                requiredElectronCount -= 2;
                int n = i;
                this.bondCount[n] = this.bondCount[n] + 1;
                this.corr[i] = -2;
            }
            this.implicitNBEC[i] = requiredElectronCount;
        }
        if (this.mfls) {
            this.reduceRadicalAtoms();
        }
        if (this.showFormaCharge) {
            for (i = 0; i < this.atomCount; ++i) {
                gn = this.getMainGroupNumber(i);
                if (this.METAL || this.isLP(i)) continue;
                be = this.initBEC[i];
                this.setFormalCharge(i, gn, be, this.corr[i]);
            }
            this.addFormalCharge();
        }
    }

    private int getMainGroupNumber(int atomInd) {
        this.actPCount = this.atomArray[atomInd].getAtno();
        this.METAL = this.MGN[this.actPCount] == 0;
        return this.MGN[this.actPCount];
    }

    private int getBondingElectrons(int atomInd, int fc) {
        int be = 0;
        int abc = 0;
        boolean aromaticAtom = false;
        int impHCount = 0;
        this.changeAble = true;
        for (int i = 0; i < this.cHtab[atomInd].length; ++i) {
            int nb = this.cHtab[atomInd][i];
            if (nb < this.atomCount) {
                int t = this.mol.getBond(this.bHtab[atomInd][nb]).getType();
                if (this.isLP(nb)) continue;
                if (t != 4) {
                    if (t == 9) {
                        t = 2;
                    }
                    be += 2 * t;
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + t;
                } else {
                    aromaticAtom = true;
                    ++abc;
                }
                if (t != 2) continue;
                this.changeAble = false;
                continue;
            }
            be += 2;
            ++impHCount;
            int n = atomInd;
            this.bondCount[n] = this.bondCount[n] + 1;
        }
        if (aromaticAtom) {
            int protonCount = this.atomArray[atomInd].getAtno();
            int charge = fc;
            switch (protonCount) {
                case 5: {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 2;
                    return be += 4;
                }
            }
            if (abc == 3) {
                int n = atomInd;
                this.bondCount[n] = this.bondCount[n] + 4;
                return be += 8;
            }
            if (this.isPyridineOxideType(atomInd)) {
                int n = atomInd;
                this.bondCount[n] = this.bondCount[n] + 3;
                return be += 6;
            }
            if (this.cHtab[atomInd].length == 3) {
                if (charge == 0) {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 3;
                    switch (protonCount) {
                        case 6: {
                            return be += 6;
                        }
                    }
                    return be += 8 - this.explicitEPC[atomInd];
                }
                if (charge == 1) {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 3;
                    switch (protonCount) {
                        case 7: {
                            return be += 6;
                        }
                    }
                    return be += 8;
                }
                if (charge == -1) {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 3;
                    switch (protonCount) {
                        case 7: {
                            return be += 6;
                        }
                        case 6: {
                            return be += 6;
                        }
                    }
                    return be += 8;
                }
            } else if (this.cHtab[atomInd].length == 2) {
                if (charge == 0) {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 3;
                    switch (protonCount) {
                        case 7: {
                            return be += 6;
                        }
                    }
                    return be += 8;
                }
                if (charge == 1) {
                    int n = atomInd;
                    this.bondCount[n] = this.bondCount[n] + 3;
                    switch (protonCount) {
                        case 7: {
                            return be += 6;
                        }
                    }
                    return be += 8;
                }
                if (charge < 0) {
                    if (charge == -1) {
                        int n = atomInd;
                        this.bondCount[n] = this.bondCount[n] + 3;
                        switch (protonCount) {
                            case 6: {
                                return be += 6;
                            }
                        }
                        return be += 8;
                    }
                    if (charge == -2) {
                        int n = atomInd;
                        this.bondCount[n] = this.bondCount[n] + 2;
                        switch (protonCount) {
                            case 6: {
                                return be += 4;
                            }
                        }
                        return be += 6;
                    }
                }
            }
        }
        return be;
    }

    private boolean isPyridineOxideType(int atomInd) {
        for (int i = 0; i < this.cHtab[atomInd].length; ++i) {
            int bondOrder;
            int protonCount;
            int nb = this.cHtab[atomInd][i];
            if (nb >= this.atomCount || (protonCount = this.atomArray[nb].getAtno()) != 8 || (bondOrder = this.mol.getBond(this.bHtab[atomInd][nb]).getType()) != 2) continue;
            return true;
        }
        return false;
    }

    private void setExistingLPCount() {
        for (int i = 0; i < this.atomCount; ++i) {
            for (int j = 0; j < this.cHtab[i].length; ++j) {
                int protonCount;
                int nb = this.cHtab[i][j];
                if (nb >= this.atomCount || (protonCount = this.atomArray[nb].getAtno()) != 130) continue;
                int n = i;
                this.explicitEPC[n] = this.explicitEPC[n] + 1;
            }
        }
    }

    private boolean isLP(int ai) {
        return this.atomArray[ai].getAtno() == 130;
    }

    private void setFormalCharge(int atomIndex, int gn, int be, int corr) {
        this.formalCharge[atomIndex] = (int)((double)gn - 0.5 * (double)be - (double)this.getActualFreeElectronCount(atomIndex) + (double)corr);
    }

    private int getActualCharge(int ai) {
        int gn = this.getMainGroupNumber(ai);
        return (int)((double)gn - 0.5 * (double)this.initBEC[ai] - (double)this.getActualFreeElectronCount(ai) + (double)this.corr[ai]);
    }

    private boolean isArA(int atomIndex) {
        if (atomIndex >= this.atomCount) {
            return false;
        }
        return this.atomArray[atomIndex].hasAromaticBond();
    }

    private void addFormalCharge() {
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomArray[i].setCharge(this.formalCharge[i]);
        }
    }

    private void addRadical() {
        int sum = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i)) continue;
            int rc = this.atomArray[i].getRadical();
            sum = this.implicitRC[i] + this.explicitRC[i];
            this.atomArray[i].setRadical(0);
            if (sum == rc) {
                this.setFinalRadicalType(rc, i);
                continue;
            }
            if (sum == 1) {
                this.setFinalRadicalType(1, i);
                continue;
            }
            if (sum == 2) {
                this.setFinalRadicalType(6, i);
                continue;
            }
            if (sum != 3) continue;
            this.setFinalRadicalType(3, i);
        }
    }

    private void setExisitngRadicalCount() {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.isLP(i)) continue;
            int rc = this.atomArray[i].getRadical();
            switch (rc) {
                case 1: {
                    rc = 1;
                    break;
                }
                case 2: {
                    rc = 2;
                    break;
                }
                case 6: {
                    rc = 2;
                    break;
                }
                case 10: {
                    rc = 2;
                    break;
                }
                case 3: {
                    rc = 3;
                    break;
                }
                case 7: {
                    rc = 3;
                    break;
                }
                case 11: {
                    rc = 3;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            this.explicitRC[i] = rc;
        }
    }

    private void setFinalRadicalType(int type, int a) {
        if (type == 1) {
            this.atomArray[a].setRadical(1);
        } else if (type == 2) {
            this.atomArray[a].setRadical(2);
        } else if (type == 6) {
            this.atomArray[a].setRadical(6);
        } else if (type == 10) {
            this.atomArray[a].setRadical(10);
        } else if (type == 3) {
            this.atomArray[a].setRadical(7);
        }
    }

    private void setAromState() {
        MoleculeGraph oMol = (MoleculeGraph)this.mol.clone();
        this.atomArray = oMol.getAtomArray();
        this.araAtom = new int[this.atomCount];
        this.corr = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.isArA(i)) continue;
            int protonCount = this.atomArray[i].getAtno();
            if (protonCount != 6 && protonCount != 5) {
                this.araAtom[i] = 1;
                continue;
            }
            if (protonCount != 6 || this.atomArray[i].getCharge() >= 0) continue;
            this.araAtom[i] = 1;
        }
    }

    private void setDelocAbleAtoms() {
        this.delocAble = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.delocAble[i] = -1;
            if (!this.isRightAtom(i)) continue;
            this.delocAble[i] = 1;
        }
    }

    private boolean isRightAtom(int atom) {
        int protonCount = this.atomArray[atom].getAtno();
        if (protonCount == 1) {
            return false;
        }
        if (protonCount == 7) {
            return this.cHtab[atom].length != 4;
        }
        if (protonCount == 6) {
            return this.cHtab[atom].length != 4;
        }
        return true;
    }

    public void calcDelocPath(int atom, int maxDistance) {
        int actAtom = atom;
        this.sphereSize = 0;
        this.di = new int[this.atomCount][2];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sAtom[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        int i = 0;
        while (distance < maxDistance + 1 & sChange) {
            sChange = false;
            if (actAtom != -1) {
                int length = this.cHtab[actAtom].length;
                for (int j = 0; j < length; ++j) {
                    int sphereAtom = this.cHtab[actAtom][j];
                    if (sphereAtom >= this.atomCount || this.isLP(sphereAtom) || !(this.di[sphereAtom][0] != 1 & sphereAtom != atom) || this.delocAble[sphereAtom] != 1) continue;
                    this.di[sphereAtom][0] = 1;
                    this.di[sphereAtom][1] = distance;
                    this.sAtom[this.sphereSize] = sphereAtom;
                    ++this.sphereSize;
                }
            }
            if (this.sAtom[i] != -1) {
                actAtom = this.sAtom[i];
                distance = this.di[actAtom][1] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            ++i;
        }
        if (this.sphereSize != 0) {
            this.di[atom][0] = 1;
            this.di[atom][1] = 0;
        }
    }

    private boolean isRingAtom(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || !this.isRingBond(ai, nb)) continue;
            return true;
        }
        return false;
    }

    private boolean isCrossRing(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb < this.atomCount) {
                if (this.isRingAtom(nb)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isRingBond(int ai, int aj) {
        int actAtom = ai;
        int resB = ai;
        int resA = aj;
        this.sphereSize = 0;
        this.di = new int[this.atomCount][2];
        for (int i = 0; i < this.atomCount; ++i) {
            this.sAtom[i] = -1;
        }
        int distance = 1;
        boolean sChange = true;
        boolean jump = false;
        int i = 0;
        while (distance < this.atomCount + 1 & sChange) {
            sChange = false;
            int length = this.cHtab[actAtom].length;
            for (int j = 0; j < length; ++j) {
                int pa = this.cHtab[actAtom][j];
                jump = false;
                if (actAtom == resB && pa == resA) {
                    jump = true;
                }
                if (pa >= this.atomCount || jump || this.di[pa][0] == 1 || pa == ai) continue;
                this.di[pa][0] = 1;
                this.di[pa][1] = distance;
                if (pa == resA && distance > 1) {
                    return true;
                }
                this.sAtom[this.sphereSize] = pa;
                ++this.sphereSize;
            }
            if (this.sAtom[i] != -1) {
                actAtom = this.sAtom[i];
                distance = this.di[actAtom][1] + 1;
                sChange = true;
            } else {
                sChange = false;
            }
            if (++i != this.atomCount) continue;
            sChange = false;
        }
        return false;
    }

    public static int getIonicType(MoleculeGraph m, MolAtom a) {
        if (a.getCharge() == 0) {
            return 0;
        }
        LonePairCounter lpc = new LonePairCounter();
        lpc.setMolecule(m);
        lpc.calcLonePairCount();
        return lpc.getIonicType(a);
    }

    public int getIonicType(MolAtom a) {
        int i = this.mol.indexOf(a);
        int chg = this.atomArray[i].getCharge();
        if (chg > 0) {
            int sumVe = 2 * (this.implicitEPC[i] + this.explicitEPC[i]) + this.explicitBEC[i];
            if (sumVe >= 8) {
                if (this.isProtonated(i)) {
                    return 2;
                }
                if (!this.isRingAtom(i)) {
                    if (this.isRaidcalParentExist(i, sumVe)) {
                        if (this.isOnlySingleBonded(i)) {
                            return 2;
                        }
                        return 1;
                    }
                    return 2;
                }
                if (this.isCrossRing(i)) {
                    return 1;
                }
                if (this.isSingleBondedNbExist(i)) {
                    return 2;
                }
                return 1;
            }
            if (chg > 1) {
                if (this.isSingleBondedNbExist(i)) {
                    if (this.isProtonated(i)) {
                        return 3;
                    }
                    return 1;
                }
                return 1;
            }
            if (this.isSingleBondedNbExist(i)) {
                if (this.explicitRC[i] != 0) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }
        if (chg < 0) {
            int sumVe = 2 * (this.implicitEPC[i] + this.explicitEPC[i]) + this.explicitBEC[i];
            int lpc = this.implicitEPC[i] + this.explicitEPC[i];
            if (sumVe == 8) {
                if (this.explicitRC[i] != 0) {
                    if (this.isNegativeHole(i)) {
                        return -1;
                    }
                    return -2;
                }
                if (lpc == 0) {
                    return -1;
                }
                return -2;
            }
            if (this.explicitRC[i] != 0) {
                if (this.isNegativeHole(i)) {
                    return -1;
                }
                return -2;
            }
            return -1;
        }
        return 0;
    }

    private boolean isNegativeHole(int ai) {
        int protonCount = this.atomArray[ai].getAtno();
        return this.MGN[protonCount] < 4;
    }

    private boolean isRaidcalParentExist(int ai, int vec) {
        int gn;
        int protonCount = this.atomArray[ai].getAtno();
        return !(protonCount <= 10 ? vec + 1 > 8 : ((gn = this.getMainGroupNumber(ai)) > 5 ? vec + 1 > 12 : gn <= 5 && vec + 1 > 10));
    }

    private boolean isOnlySingleBonded(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.mol.getBond(this.bHtab[ai][nb]).getType() <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean isSingleBondedNbExist(int ai) {
        for (int i = 0; i < this.cHtab[ai].length; ++i) {
            int nb = this.cHtab[ai][i];
            if (nb >= this.atomCount || this.mol.getBond(this.bHtab[ai][nb]).getType() != 1 || this.isRingAtom(nb)) continue;
            return true;
        }
        return false;
    }

    protected boolean isOddNumber(int L) {
        int y = L & 1;
        return y == 1;
    }
}

