/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.stereo.RigidPart;
import chemaxon.core.calculations.stereo.RigidPartDetection;
import chemaxon.core.calculations.stereo.StereoCalculations;
import chemaxon.struc.AxialStereoDescriptor;
import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.CisTransStereoDescriptor;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.StereoActivePart;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public class AXCTStereoDetection {
    MoleculeGraph molecule;
    BitSet activeAtoms;
    int[] graphInvariants;
    RigidPart[] rigidParts;

    public AXCTStereoDetection(MoleculeGraph molecule, BitSet activeAtoms, int[] graphInvariants) {
        this.molecule = molecule;
        this.activeAtoms = activeAtoms;
        this.graphInvariants = graphInvariants;
        this.rigidParts = RigidPartDetection.detectRigidParts(molecule);
    }

    public void calculateAXCTStereoDescriptors(HashSet<CIPStereoDescriptorIface> descriptors) {
        int i = this.activeAtoms.nextSetBit(0);
        while (i >= 0) {
            ArrayList<Path> pathList = new ArrayList<Path>();
            this.findActiveAtomPairs(i, pathList, new Path(i));
            if (pathList.size() > 0) {
                this.calculateStereoValue(pathList, descriptors);
            }
            i = this.activeAtoms.nextSetBit(i + 1);
        }
    }

    private void calculateStereoValue(ArrayList<Path> pathList, HashSet<CIPStereoDescriptorIface> descriptors) {
        for (Path path : pathList) {
            StereoActivePart sap2;
            StereoActivePart sap1 = new StereoActivePart(path.firstAtom, this.getStereoActivePartLigands(path.firstAtom, path.connectingRigidParts.get(0), this.molecule));
            if (this.checkPrimaryStereoActivePart(sap1, sap2 = new StereoActivePart(path.lastAtom(), this.getStereoActivePartLigands(path.lastAtom(), path.lastRigidPart(), this.molecule)))) {
                StereoActivePart tmp = sap1;
                sap1 = sap2;
                sap2 = tmp;
            }
            CIPStereoDescriptorIface descriptor = path.connectingRigidParts.size() % 2 == 0 ? new AxialStereoDescriptor(this.calculateAxialValue(path, this.molecule, sap1, sap2), path.centerAtom(), sap1, sap2) : new CisTransStereoDescriptor(this.calculateCisTransValue(path, this.molecule, sap1, sap2), sap1, sap2);
            descriptors.add(descriptor);
        }
    }

    private boolean checkPrimaryStereoActivePart(StereoActivePart sap1, StereoActivePart sap2) {
        int max2;
        int max1 = StereoCalculations.getMaxValue(sap1.getLigands());
        return max1 < (max2 = StereoCalculations.getMaxValue(sap2.getLigands())) || max1 == Integer.MIN_VALUE && max2 == Integer.MIN_VALUE && sap1.getStereoActiveAtom() < sap2.getStereoActiveAtom();
    }

    public CIPStereoDescriptorIface.CIPValue.AxialStereoValue calculateAxialValue(Path path, MoleculeGraph m, StereoActivePart sap1, StereoActivePart sap2) {
        if (this.hasWiggly(sap1, m) || this.hasWiggly(sap2, m)) {
            return CIPStereoDescriptorIface.CIPValue.AxialStereoValue.WIGGLY;
        }
        int firstAtomIdx = path.firstAtom;
        StereoActivePart sap = sap1.getStereoActiveAtom() == firstAtomIdx ? sap1 : sap2;
        DPoint3 v = this.getLigandVector(m, sap);
        ArrayList<RigidPart> rigidParts = path.connectingRigidParts;
        for (RigidPart rigidPart : rigidParts) {
            int toAtomIdx = rigidPart.getOppositeAtom(firstAtomIdx);
            rigidPart.transform(v, firstAtomIdx, toAtomIdx);
            firstAtomIdx = toAtomIdx;
        }
        DPoint3[] p = this.getReferenceFrameCoords(path, m, sap1, sap2, v);
        p[3].subtract(p[2]);
        DPoint3 axisToFront = p[3];
        p[0].subtract(p[1]);
        DPoint3 axisToBack = p[0];
        DPoint3 rotationCenter = p[2];
        p[1].subtract(p[2]);
        DPoint3 axisFrontToAxisBack = p[1];
        return StereoCalculations.calculateValue(axisToFront, axisToBack, rotationCenter, axisFrontToAxisBack);
    }

    private DPoint3[] getReferenceFrameCoords(Path path, MoleculeGraph m, StereoActivePart sap1, StereoActivePart sap2, DPoint3 v) {
        DPoint3[] p = new DPoint3[4];
        p[1] = m.getAtom(sap1.getStereoActiveAtom()).getLocation();
        p[2] = m.getAtom(sap2.getStereoActiveAtom()).getLocation();
        if (path.firstAtom == sap1.getStereoActiveAtom()) {
            this.generateCoordinatesFromSAP(m, sap2, v, p, 0, 1, 3);
        } else {
            this.generateCoordinatesFromSAP(m, sap1, v, p, 3, 2, 0);
        }
        return p;
    }

    private void generateCoordinatesFromSAP(MoleculeGraph m, StereoActivePart sap, DPoint3 v, DPoint3[] p, int ligandIdx, int pillar, int ligandIdx2) {
        p[ligandIdx] = (DPoint3)p[pillar].clone();
        p[ligandIdx].add(v);
        int[] ligands = sap.getLigands();
        if (ligands.length == 0) {
            p[ligandIdx2] = (DPoint3)p[pillar].clone();
            if (m.getDim() == 3) {
                this.addImplicitHcoord(p[ligandIdx2], m.getAtom(ligandIdx2));
            } else {
                this.convertWedges(-1, p[ligandIdx2], sap, m);
            }
        } else {
            int maxLigandIdx = StereoCalculations.getMaxValue(sap.getLigands());
            p[ligandIdx2] = m.getAtom(maxLigandIdx).getLocation();
            this.convertWedges(maxLigandIdx, p[ligandIdx2], sap, m);
        }
    }

    private void convertWedges(int ligandIdx, DPoint3 v, StereoActivePart sap, MoleculeGraph m) {
        if (m.getDim() == 2) {
            int f;
            MolAtom center = m.getAtom(sap.getStereoActiveAtom());
            MolAtom ligand = null;
            MolBond b = null;
            if (ligandIdx >= 0) {
                ligand = m.getAtom(ligandIdx);
                b = center.getBondTo(ligand);
            }
            if ((f = StereoCalculations.convertWedge(center, b)) == 16) {
                v.z = 10.0;
            } else if (f == 32) {
                v.z = -10.0;
            }
        }
    }

    private boolean hasWiggly(StereoActivePart sap, MoleculeGraph m) {
        int[] ligands = sap.getLigands();
        MolAtom center = m.getAtom(sap.getStereoActiveAtom());
        for (int i = 0; i < ligands.length; ++i) {
            MolAtom other = m.getAtom(ligands[i]);
            MolBond b = center.getBondTo(other);
            if (b.getStereo1(center) != 48) continue;
            return true;
        }
        return false;
    }

    private int[] getStereoActivePartLigands(int index, RigidPart rigidPart, MoleculeGraph molecule) {
        MolAtom atom = molecule.getAtom(index);
        IntVector atoms = new IntVector(4);
        for (int i = atom.getBondCount() - 1; i > -1; --i) {
            if (rigidPart.containsAtom(molecule.indexOf(atom.getLigand(i)))) continue;
            atoms.add(molecule.indexOf(atom.getLigand(i)));
        }
        return atoms.toArray();
    }

    private CIPStereoDescriptorIface.CIPValue.CisTransStereoValue calculateCisTransValue(Path path, MoleculeGraph m, StereoActivePart sap1, StereoActivePart sap2) {
        if (this.hasWiggly(sap1, m) || this.hasWiggly(sap2, m)) {
            return CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.WIGGLY;
        }
        int firstAtomIdx = path.firstAtom;
        StereoActivePart sap = sap1.getStereoActiveAtom() == firstAtomIdx ? sap1 : sap2;
        DPoint3 v = this.getLigandVector(m, sap);
        if (v.x != 0.0 || v.y != 0.0 || v.z != 0.0) {
            ArrayList<RigidPart> rigidParts = path.connectingRigidParts;
            for (RigidPart rigidPart : rigidParts) {
                int toAtomIdx = rigidPart.getOppositeAtom(firstAtomIdx);
                rigidPart.transform(v, firstAtomIdx, toAtomIdx);
                firstAtomIdx = toAtomIdx;
            }
            DPoint3[] p = this.getReferenceFrameCoords(path, m, sap1, sap2, v);
            return AXCTStereoDetection.calcCisTransStereoFromCoordinates(p[0], p[1], p[2], p[3]);
        }
        return CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.UNKNOWN;
    }

    private DPoint3 getLigandVector(MoleculeGraph m, StereoActivePart sap) {
        DPoint3 v;
        int centerAtomIdx = sap.getStereoActiveAtom();
        MolAtom center = m.getAtom(centerAtomIdx);
        int ligandIdx = -1;
        int[] SAPligands = sap.getLigands();
        if (SAPligands.length == 0) {
            v = new DPoint3();
            if (m.getDim() == 3) {
                this.addImplicitHcoord(v, center);
            }
        } else {
            ligandIdx = StereoCalculations.getMaxValue(sap.getLigands());
            v = m.getAtom(ligandIdx).getLocation();
            v.subtract(center.getLocation());
        }
        this.convertWedges(ligandIdx, v, sap, m);
        return v;
    }

    private void addImplicitHcoord(DPoint3 v, MolAtom centerAtom) {
        DPoint3 c = new DPoint3();
        int bc = centerAtom.getBondCount();
        for (int i = 0; i < bc; ++i) {
            DPoint3 v1 = centerAtom.getLigand(i).getLocation();
            c.add(v1);
        }
        c.x /= (double)bc;
        c.y /= (double)bc;
        c.z /= (double)bc;
        DPoint3 center = centerAtom.getLocation();
        center.subtract(c);
        v.add(center);
    }

    private void findActiveAtomPairs(int incomingAtomIndex, ArrayList<Path> validPathList, Path incomingPath) {
        ArrayList<RigidPart> leavingParts = this.getNextRigidParts(incomingAtomIndex, incomingPath);
        if (leavingParts.size() > 0) {
            for (RigidPart part : leavingParts) {
                int oppositeLeaving = part.getOppositeAtom(incomingAtomIndex);
                if (oppositeLeaving == -1 || !this.hasAllowedDoubleBondCount(incomingAtomIndex) || !this.isLeavingAtomAllowed(incomingAtomIndex, part) || !this.isLeavingPartAllowed(incomingPath, part)) continue;
                Path newPath = new Path(incomingPath);
                newPath.connectingAtoms.add(oppositeLeaving);
                newPath.connectingRigidParts.add(part);
                if (this.activeAtoms.get(oppositeLeaving)) {
                    validPathList.add(newPath);
                }
                this.findActiveAtomPairs(oppositeLeaving, validPathList, newPath);
            }
        }
    }

    private boolean hasAllowedDoubleBondCount(int incomingAtomIndex) {
        MolAtom incomingAtom = this.molecule.getAtom(incomingAtomIndex);
        int doubleBondCount = 0;
        for (int i = 0; i < incomingAtom.getBondCount(); ++i) {
            if (incomingAtom.getBond(i).getType() != 2) continue;
            ++doubleBondCount;
        }
        return doubleBondCount < 3;
    }

    private boolean isLeavingAtomAllowed(int incomingAtomIndex, RigidPart part) {
        MolAtom incomingAtom = this.molecule.getAtom(incomingAtomIndex);
        HashSet<Integer> set = new HashSet<Integer>();
        for (MolAtom ligand : incomingAtom.getLigands()) {
            int ligandIndex = this.molecule.indexOf(ligand);
            if (!part.containsAtom(ligandIndex) || !part.containsBond(this.molecule.indexOf(incomingAtom.getBondTo(ligand)))) continue;
            set.add(this.graphInvariants[ligandIndex]);
        }
        return set.size() == 1;
    }

    private boolean isLeavingPartAllowed(Path incomingPath, RigidPart part) {
        return incomingPath.connectingRigidParts.size() <= 0 || !part.hasCommonBond(incomingPath.lastRigidPart());
    }

    private ArrayList<RigidPart> getNextRigidParts(int atomIndex, Path incomingPath) {
        ArrayList<RigidPart> containingParts = new ArrayList<RigidPart>();
        for (RigidPart part : this.rigidParts) {
            if (incomingPath.contains(part) || !part.containsAtom(atomIndex)) continue;
            containingParts.add(part);
        }
        return containingParts;
    }

    public static CIPStereoDescriptorIface.CIPValue.CisTransStereoValue calcCisTransStereoFromCoordinates(DPoint3 atom1, DPoint3 atom2, DPoint3 atom3, DPoint3 atom4) {
        if (atom1 == null || atom2 == null || atom3 == null || atom4 == null) {
            return null;
        }
        if (atom1.equals(atom2) || atom3.equals(atom4)) {
            return CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.UNKNOWN;
        }
        double ax = atom1.x - atom2.x;
        double bx = atom3.x - atom2.x;
        double ay = atom1.y - atom2.y;
        double by = atom3.y - atom2.y;
        double az = atom1.z - atom2.z;
        double bz = atom3.z - atom2.z;
        double ab = ax * bx + ay * by + az * bz;
        double cx = atom4.x - atom3.x;
        double cy = atom4.y - atom3.y;
        double cz = atom4.z - atom3.z;
        double bc = bx * cx + by * cy + bz * cz;
        double ac = ax * cx + ay * cy + az * cz;
        double bb = bx * bx + by * by + bz * bz;
        double scalar = ab * bc - ac * bb;
        double normsq = bb * bb * (ax * ax + ay * ay + az * az) * (cx * cx + cy * cy + cz * cz);
        double epsilon = 5.77E-5;
        return scalar * scalar < normsq * epsilon ? CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.UNKNOWN : (scalar > 0.0 ? CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.TRANS : CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.CIS);
    }

    private static class Path {
        int firstAtom = -1;
        ArrayList<Integer> connectingAtoms = new ArrayList();
        ArrayList<RigidPart> connectingRigidParts = new ArrayList();

        Path(Path path) {
            this.connectingAtoms = new ArrayList<Integer>(path.connectingAtoms);
            this.firstAtom = path.firstAtom;
            this.connectingRigidParts = new ArrayList<RigidPart>(path.connectingRigidParts);
        }

        Path(int atomIndex) {
            this.firstAtom = atomIndex;
        }

        int lastAtom() {
            return this.connectingAtoms.get(this.connectingAtoms.size() - 1);
        }

        int centerAtom() {
            return this.connectingAtoms.get(this.connectingAtoms.size() / 2 - 1);
        }

        RigidPart lastRigidPart() {
            return this.connectingRigidParts.get(this.connectingRigidParts.size() - 1);
        }

        public boolean contains(RigidPart part) {
            for (int i = 0; i < this.connectingRigidParts.size(); ++i) {
                if (this.connectingRigidParts.get(i) != part) continue;
                return true;
            }
            return false;
        }
    }
}

