/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.BitSet;

public final class ActiveAtomDetection {
    public static BitSet[] getActiveAtoms(MoleculeGraph m) {
        int ac = m.getAtomCount();
        int[] graphInvariants = new int[ac];
        BitSet active = new BitSet(ac);
        BitSet thStereo = new BitSet(ac);
        int[][] ctab = m.getCtab();
        int[] ligandGrinvs = new int[4];
        int[] ligandGrinvsTH = new int[4];
        m.getGrinv(graphInvariants, 3);
        for (int i = 0; i < ac; ++i) {
            MolAtom a = m.getAtom(i);
            int bondCount = a.getBondCount();
            if (bondCount < 2 || bondCount > 4) continue;
            for (int j = bondCount; j < 4; ++j) {
                ligandGrinvs[j] = -1;
                ligandGrinvsTH[j] = -1;
            }
            int[] an = ctab[i];
            int doubleBondCount = 0;
            int singleBondCount = 0;
            boolean nonStereo = false;
            for (int j = 0; j < bondCount; ++j) {
                MolBond b = a.getBond(j);
                int t = b.getType();
                if (t == 2) {
                    ++doubleBondCount;
                    ligandGrinvsTH[j] = graphInvariants[an[j]];
                    continue;
                }
                if (t == 1) {
                    ligandGrinvs[singleBondCount++] = graphInvariants[an[j]];
                    ligandGrinvsTH[j] = graphInvariants[an[j]];
                    continue;
                }
                nonStereo = true;
                break;
            }
            if (nonStereo) continue;
            if (ActiveAtomDetection.fourGrinvDiff(ligandGrinvsTH)) {
                thStereo.set(i);
                if (doubleBondCount >= 2) continue;
                active.set(i);
                continue;
            }
            if (!ActiveAtomDetection.isActiveAtom(ligandGrinvs, doubleBondCount, singleBondCount)) continue;
            active.set(i);
        }
        return new BitSet[]{active, thStereo};
    }

    private static boolean isActiveAtom(int[] ligandGrinvs, int doubleBondCount, int singleBondCount) {
        if (doubleBondCount == 0) {
            if (singleBondCount == 3 && ligandGrinvs[0] != -1 && ligandGrinvs[1] != -1 && ligandGrinvs[2] != -1 ? ActiveAtomDetection.threeDifferent(ligandGrinvs) : singleBondCount == 4 && ActiveAtomDetection.threeDifferent(ligandGrinvs)) {
                return true;
            }
        } else if (doubleBondCount == 1) {
            if (singleBondCount == 1 && ligandGrinvs[0] != -1) {
                return true;
            }
            if (singleBondCount == 2 && ligandGrinvs[0] != ligandGrinvs[1]) {
                return true;
            }
        }
        return false;
    }

    private static boolean fourGrinvDiff(int[] g) {
        return ActiveAtomDetection.differentGrinv(g, false);
    }

    private static boolean threeDifferent(int[] g) {
        return ActiveAtomDetection.differentGrinv(g, true);
    }

    private static boolean differentGrinv(int[] g, boolean three) {
        int l = g.length;
        int n = 1;
        for (int i = 0; i < l; ++i) {
            int v1 = g[i];
            for (int j = i + 1; j < l; ++j) {
                if (v1 != g[j]) continue;
                if (!three) {
                    return false;
                }
                if (++n <= 2) continue;
                return false;
            }
        }
        return true;
    }
}

