/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.core.calculations.stereo.AXCTStereoDetection;
import chemaxon.core.calculations.stereo.ActiveAtomDetection;
import chemaxon.core.calculations.stereo.AtropStereoRecognizer;
import chemaxon.core.calculations.stereo.TetrahedralStereoDetection;
import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.MoleculeGraph;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;

public class CIPStereoRecognizer {
    public static Collection<CIPStereoDescriptorIface> calculateCIPStereoDescriptors(MoleculeGraph molecule) {
        HashSet<CIPStereoDescriptorIface> descriptors = new HashSet<CIPStereoDescriptorIface>();
        MoleculeGraph mol = CIPStereoRecognizer.initialize(molecule);
        BitSet[] atomSets = ActiveAtomDetection.getActiveAtoms(mol);
        int[] graphInvariants = new int[molecule.getAtomCount()];
        molecule.getGrinv(graphInvariants, 3);
        AtropStereoRecognizer atropStereoRecognizer = new AtropStereoRecognizer(graphInvariants);
        atropStereoRecognizer.calculateAtropStereo(mol, descriptors);
        TetrahedralStereoDetection tetrahedralDetection = new TetrahedralStereoDetection();
        tetrahedralDetection.calculateTetrahedralDescriptors(atomSets[0], atomSets[1], mol, descriptors);
        AXCTStereoDetection axctDetection = new AXCTStereoDetection(molecule, atomSets[0], graphInvariants);
        axctDetection.calculateAXCTStereoDescriptors(descriptors);
        return descriptors;
    }

    private static MoleculeGraph initialize(MoleculeGraph m) {
        MoleculeGraph mol = (MoleculeGraph)m.clone();
        mol.aromatize();
        return mol;
    }
}

