/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.core.calculations.stereo.RigidPart;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MoleculeGraph;

public class DoubleBondRigidPart
implements RigidPart {
    private MoleculeGraph molecule;
    private int bondIndex;

    public DoubleBondRigidPart(int bondIndex, MoleculeGraph molecule) {
        this.bondIndex = bondIndex;
        this.molecule = molecule;
    }

    @Override
    public int getOppositeAtom(int atomIndex) {
        int facingAtomIdx = atomIndex == this.getAtomIndex1() ? this.getAtomIndex2() : (atomIndex == this.getAtomIndex2() ? this.getAtomIndex1() : -1);
        return facingAtomIdx > -1 && this.molecule.getAtom(facingAtomIdx).getBondCount() > 1 ? facingAtomIdx : -1;
    }

    private int getAtomIndex2() {
        return this.molecule.indexOf(this.molecule.getBond(this.bondIndex).getAtom2());
    }

    private int getAtomIndex1() {
        return this.molecule.indexOf(this.molecule.getBond(this.bondIndex).getAtom1());
    }

    @Override
    public boolean containsAtom(int atomIndex) {
        return this.getAtomIndex1() == atomIndex || this.getAtomIndex2() == atomIndex;
    }

    @Override
    public void transform(DPoint3 v, int fromAtomIdx, int toAtomIdx) {
    }

    @Override
    public boolean containsBond(int bondIndex) {
        return this.bondIndex == bondIndex;
    }

    @Override
    public boolean hasCommonBond(RigidPart rigidPart) {
        return rigidPart.containsBond(this.bondIndex);
    }
}

