/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.core.calculations.stereo.RigidPart;
import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;

public class RingRigidPart
implements RigidPart {
    private BitSet indexes;
    private MoleculeGraph m = null;

    public RingRigidPart(BitSet bondIndexes, MoleculeGraph mol) {
        this.indexes = bondIndexes;
        this.m = mol;
    }

    @Override
    public boolean containsAtom(int atomIndex) {
        MolAtom atom = this.m.getAtom(atomIndex);
        for (int i = atom.getBondCount() - 1; i > -1; --i) {
            if (!this.indexes.get(this.m.indexOf(atom.getBond(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOppositeAtom(int atomIndex) {
        int facingAtomIdx = this.getFacingAtom(this.m, atomIndex, this.indexes);
        if (facingAtomIdx < 0) {
            return -1;
        }
        return this.m.getAtom(facingAtomIdx).getBondCount() > 2 ? facingAtomIdx : -1;
    }

    @Override
    public void transform(DPoint3 v, int fromAtomIdx, int toAtomIdx) {
        MolAtom a1 = this.m.getAtom(fromAtomIdx);
        MolBond[] b1 = this.locateBondsToAtom(a1);
        MolAtom a2 = this.m.getAtom(toAtomIdx);
        MolBond[] b2 = this.locateBondsToAtom(a2);
        this.rearrangeAccordingToCanoncialWalk(b1, a1, b2, a2);
        DPoint3 n1 = this.getPlainVector(b1, a1);
        DPoint3 n2 = this.getPlainVector(b2, a2);
        DPoint3 cm1 = this.getCenterOfMass(b1, a1);
        cm1.subtract(a1.getLocation());
        DPoint3 cm2 = this.getCenterOfMass(b2, a2);
        cm2.subtract(a2.getLocation());
        double alpha = n1.angle3D(n2);
        DPoint3 axis = DPoint3.cross(n1, n2);
        CTransform3D T = new CTransform3D();
        if (!(axis.x == 0.0 && axis.y == 0.0 && axis.z == 0.0 || Double.isNaN(alpha))) {
            T.setRotation(axis.x, axis.y, axis.z, alpha);
            T.transform(v);
            T.transform(cm1);
        }
        cm2.x = -cm2.x;
        cm2.y = -cm2.y;
        cm2.z = -cm2.z;
        alpha = cm1.angle3D(cm2);
        axis = DPoint3.cross(cm1, cm2);
        if (!(axis.x == 0.0 && axis.y == 0.0 && axis.z == 0.0 || Double.isNaN(alpha))) {
            T.setIdentity();
            T.setRotation(axis.x, axis.y, axis.z, alpha);
            T.transform(v);
        }
    }

    private DPoint3 getCenterOfMass(MolBond[] b1, MolAtom a1) {
        DPoint3 cm = new DPoint3();
        int l = b1.length;
        for (int i = 0; i < l; ++i) {
            MolBond molBond = b1[i];
            MolAtom a = molBond.getOtherAtom(a1);
            cm.x += a.getX();
            cm.y += a.getY();
            cm.z += a.getZ();
        }
        cm.x /= (double)l;
        cm.y /= (double)l;
        cm.z /= (double)l;
        return cm;
    }

    private void rearrangeAccordingToCanoncialWalk(MolBond[] b1, MolAtom a1, MolBond[] b2, MolAtom a2) {
        MolAtom a = a1;
        MolBond b = b1[1];
        boolean foundBond = true;
        block0: while (a != a2 && foundBond) {
            a = b.getOtherAtom(a);
            foundBond = false;
            for (int i = 0; i < a.getBondCount(); ++i) {
                MolBond next = a.getBond(i);
                if (next == b || !this.indexes.get(this.m.indexOf(next))) continue;
                b = next;
                foundBond = true;
                continue block0;
            }
        }
        if (b2[1] != b) {
            b2[0] = b2[1];
            b2[1] = b;
        }
    }

    private DPoint3 getPlainVector(MolBond[] b, MolAtom atom) {
        DPoint3 c = atom.getLocation();
        MolAtom a = b[0].getOtherAtom(atom);
        DPoint3 v1 = a.getLocation();
        a = b[1].getOtherAtom(atom);
        DPoint3 v2 = a.getLocation();
        v1.subtract(c);
        v2.subtract(c);
        return DPoint3.cross(v1, v2);
    }

    private MolBond[] locateBondsToAtom(MolAtom atom) {
        MolBond[] bonds = new MolBond[2];
        int n = 0;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = atom.getBond(i);
            int bondIdx = this.m.indexOf(b);
            if (n < 3) {
                if (!this.indexes.get(bondIdx)) continue;
                bonds[n++] = b;
                continue;
            }
            throw new RuntimeException("More than 2 bonds for atom " + this.m.indexOf(atom));
        }
        return bonds;
    }

    private int getFacingAtom(MoleculeGraph mol, int startAtom, BitSet usableEdges) {
        boolean edgeUsabilityFlag = usableEdges != null;
        BondTable bTab = mol.getBondTable();
        int N = mol.getAtomCount();
        int[][] cTab = mol.getCtab();
        int[] parent = new int[N];
        Arrays.fill(parent, -1);
        LinkedList<Integer> queue = new LinkedList<Integer>();
        boolean[] reached = new boolean[N];
        LinkedList<Integer> reachedInCurrentStep = new LinkedList<Integer>();
        int[] distances = new int[N];
        Arrays.fill(distances, -1);
        distances[startAtom] = 0;
        queue.add(startAtom);
        reached[startAtom] = true;
        while (!queue.isEmpty()) {
            int current = (Integer)queue.poll();
            for (int i = 0; i < cTab[current].length; ++i) {
                int neighbor = cTab[current][i];
                int bondIndex = bTab.getBondIndex(current, neighbor);
                if (edgeUsabilityFlag && !usableEdges.get(bondIndex)) continue;
                if (!reached[neighbor]) {
                    queue.add(neighbor);
                    reached[neighbor] = true;
                    distances[neighbor] = distances[current] + 1;
                    reachedInCurrentStep.add(neighbor);
                    continue;
                }
                if (distances[neighbor] != distances[current] + 1) continue;
                return neighbor;
            }
        }
        return -1;
    }

    @Override
    public boolean containsBond(int bondIndex) {
        return this.indexes.get(bondIndex);
    }

    @Override
    public boolean hasCommonBond(RigidPart rigidPart) {
        if (rigidPart instanceof RingRigidPart) {
            return this.indexes.intersects(((RingRigidPart)rigidPart).indexes);
        }
        return false;
    }
}

