/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

public class StereoCalculations {
    public static int convertWedge(MolAtom a, MolBond reference) {
        int w = 0;
        int n = 0;
        int doubleBondCount = 0;
        int bc = a.getBondCount();
        for (int i = 0; i < bc; ++i) {
            int flag;
            MolBond b = a.getBond(i);
            if (b.getType() == 2) {
                ++doubleBondCount;
            }
            if ((flag = b.getStereo1(a)) == 0) continue;
            if (flag == 48) {
                return flag;
            }
            if (n == 0) {
                w = flag;
            }
            ++n;
        }
        if (n == 1 && bc <= 3) {
            if (doubleBondCount == 0) {
                return w;
            }
            int referenceFlag = reference.getStereo1(a);
            return referenceFlag != 0 ? referenceFlag : w ^ 0x30;
        }
        return StereoCalculations.calculateWedgeFromParity(a, reference);
    }

    private static int calculateWedgeFromParity(MolAtom a, MolBond reference) {
        int bc = a.getBondCount();
        DPoint3[] c = new DPoint3[4];
        int ups = 0;
        int downs = 0;
        int referenceIdx = -1;
        for (int i = 0; i < bc; ++i) {
            int flag;
            c[i] = a.getLigand(i).getLocation();
            MolBond b = a.getBond(i);
            if (b == reference) {
                referenceIdx = i;
            }
            if ((flag = b.getStereo1(a)) == 16) {
                c[i].z += 1.0;
                ++ups;
                continue;
            }
            if (flag != 32) continue;
            c[i].z -= 1.0;
            ++downs;
        }
        if (referenceIdx < 0) {
            return 0;
        }
        if (bc == 3) {
            c[3] = a.getLocation();
        }
        if (ups == 0 && downs == 0) {
            return 0;
        }
        if (ups == 4 || downs == 4) {
            return 0;
        }
        int p = StereoCalculations.determinantToParity(c, 2);
        if (p == 0) {
            return 0;
        }
        for (int i = 0; i < bc; ++i) {
            c[i] = a.getLigand(i).getLocation();
            c[i].z = 0.0;
        }
        if (bc == 3) {
            c[3] = a.getLocation();
        }
        c[referenceIdx].z = 1.0;
        if (p == StereoCalculations.determinantToParity(c, 2)) {
            return 16;
        }
        return 32;
    }

    private static int determinantToParity(DPoint3[] c, int dim) {
        for (int i = 0; i < 3; ++i) {
            c[i].subtract(c[3]);
        }
        return StereoCalculations.determinantToParity(c[0].x, c[0].y, c[0].z, c[1].x, c[1].y, c[1].z, c[2].x, c[2].y, c[2].z, dim);
    }

    private static int determinantToParity(double ax, double ay, double az, double bx, double by, double bz, double cx, double cy, double cz, int dim) {
        double rot;
        double DET2_THRESHOLD = 1.0E-16;
        double ab_x = ay * bz - az * by;
        double ab_y = az * bx - ax * bz;
        double ab_z = ax * by - ay * bx;
        double ac_x = ay * cz - az * cy;
        double ac_y = az * cx - ax * cz;
        double ac_z = ax * cy - ay * cx;
        double a_sq = ax * ax + ay * ay + az * az;
        double b_sq = bx * bx + by * by + bz * bz;
        double c_sq = cx * cx + cy * cy + cz * cz;
        if (dim > 2) {
            double dz;
            double dy;
            double ac_l;
            double ab_sq = ab_x * ab_x + ab_y * ab_y + ab_z * ab_z;
            double ac_sq = ac_x * ac_x + ac_y * ac_y + ac_z * ac_z;
            double ab_l = Math.sqrt(ab_sq);
            double dx = ab_x / ab_l - ac_x / (ac_l = Math.sqrt(ac_sq));
            double distance = Math.sqrt(dx * dx + (dy = ab_y / ab_l - ac_y / ac_l) * dy + (dz = ab_z / ab_l - ac_z / ac_l) * dz);
            double d = distance = distance < Math.abs(distance - 2.0) ? distance : Math.abs(distance - 2.0);
            if (distance < 0.1) {
                return 3;
            }
        }
        if ((rot = ab_x * cx + ab_y * cy + ab_z * cz) * rot < DET2_THRESHOLD * a_sq * b_sq * c_sq) {
            return 3;
        }
        return rot > 0.0 ? 1 : -1;
    }

    public static CIPStereoDescriptorIface.CIPValue.AtropStereoValue calculateValueFromVectors(DPoint3 axisToFront, DPoint3 axisFrontToAxisBack, DPoint3 axisToBack, DPoint3 rotationCenter) {
        CIPStereoDescriptorIface.CIPValue.AtropStereoValue result = CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN;
        if (Math.abs(axisFrontToAxisBack.x) < 1.0E-16 && Math.abs(axisFrontToAxisBack.y) < 1.0E-16) {
            if (axisFrontToAxisBack.z > 0.0) {
                axisToFront.y = -axisToFront.y;
                axisToBack.y = -axisToBack.y;
            }
        } else {
            DPoint3 axisOrthoInXY = new DPoint3(axisFrontToAxisBack.y, -axisFrontToAxisBack.x, 0.0);
            DPoint3 axisOrthoToXY = DPoint3.cross(axisFrontToAxisBack, axisOrthoInXY);
            if (axisOrthoToXY.z > 0.0) {
                axisOrthoToXY.z = -axisOrthoToXY.z;
                axisOrthoInXY.x = -axisOrthoInXY.x;
                axisOrthoInXY.y = -axisOrthoInXY.y;
            }
            DPoint3 origo = new DPoint3();
            double sinOfRotationAngle = DPoint3.cross(axisFrontToAxisBack, axisOrthoToXY).distance(origo) / axisFrontToAxisBack.distance(origo) / axisOrthoToXY.distance(origo);
            double rotationAngle = sinOfRotationAngle > 1.0 ? 1.5707963267948966 : (sinOfRotationAngle < -1.0 ? -1.5707963267948966 : Math.asin(sinOfRotationAngle));
            CTransform3D transform = new CTransform3D();
            transform.setRotation(-axisOrthoInXY.x, -axisOrthoInXY.y, -axisOrthoInXY.z, rotationAngle);
            transform.transform(axisToFront);
            axisToBack = DPoint3.add(axisToBack, axisFrontToAxisBack);
            transform.transform(axisToBack);
            transform.transform(axisFrontToAxisBack);
            axisToBack.subtract(axisFrontToAxisBack);
            double frontAngle = origo.angle2D(axisToFront.x, axisToFront.y);
            double backAngle = origo.angle2D(axisToBack.x, axisToBack.y);
            if (backAngle < frontAngle) {
                backAngle += Math.PI * 2;
            }
            result = Math.abs(backAngle - frontAngle) < 0.08726646259971647 ? CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN : (Math.abs(backAngle - frontAngle - Math.PI) < 0.08726646259971647 ? CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN : (backAngle > frontAngle + Math.PI ? CIPStereoDescriptorIface.CIPValue.AtropStereoValue.ODD : CIPStereoDescriptorIface.CIPValue.AtropStereoValue.EVEN));
        }
        return result;
    }

    public static CIPStereoDescriptorIface.CIPValue.AxialStereoValue calculateValue(DPoint3 axisToFront, DPoint3 axisToBack, DPoint3 rotationCenter, DPoint3 axisFrontToAxisBack) {
        CIPStereoDescriptorIface.CIPValue.AtropStereoValue sv = StereoCalculations.calculateValueFromVectors(axisToFront, axisFrontToAxisBack, axisToBack, rotationCenter);
        switch (sv) {
            case ODD: {
                return CIPStereoDescriptorIface.CIPValue.AxialStereoValue.ODD;
            }
            case EVEN: {
                return CIPStereoDescriptorIface.CIPValue.AxialStereoValue.EVEN;
            }
            case UNKNOWN: {
                return CIPStereoDescriptorIface.CIPValue.AxialStereoValue.UNKNOWN;
            }
            case WIGGLY: {
                return CIPStereoDescriptorIface.CIPValue.AxialStereoValue.WIGGLY;
            }
        }
        return null;
    }

    public static int getMaxValue(int[] values) {
        int maxValue = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= maxValue) continue;
            maxValue = value;
        }
        return maxValue;
    }
}

