/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.calculations.stereo;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;

class TempSAP {
    private MolAtom axisAtom = null;
    private MolAtom ligandHigh = null;
    private MolAtom ligandLow = null;
    private int axisAtomIndex = -1;
    private int ligandHighIndex = -1;
    private int ligandLowIndex = -1;

    public MolAtom getAxisAtom() {
        return this.axisAtom;
    }

    public MolAtom getLigandHigh() {
        return this.ligandHigh;
    }

    public MolAtom getLigandLow() {
        return this.ligandLow;
    }

    public int getAxisAtomIndex() {
        return this.axisAtomIndex;
    }

    public int getLigandHighIndex() {
        return this.ligandHighIndex;
    }

    public int getLigandLowIndex() {
        return this.ligandLowIndex;
    }

    public TempSAP(MolAtom axisAtom, MoleculeGraph m) {
        this.axisAtom = axisAtom;
        this.axisAtomIndex = m.indexOf(axisAtom);
    }

    public void setLigands(MoleculeGraph m, MolBond[] twoLigandBonds) {
        int index2;
        int index1 = m.indexOf(twoLigandBonds[0].getOtherAtom(this.axisAtom));
        if (index1 > (index2 = m.indexOf(twoLigandBonds[1].getOtherAtom(this.axisAtom)))) {
            this.ligandHigh = m.getAtom(index1);
            this.ligandHighIndex = index1;
            this.ligandLow = m.getAtom(index2);
            this.ligandLowIndex = index2;
        } else {
            this.ligandHigh = m.getAtom(index2);
            this.ligandHighIndex = index2;
            this.ligandLow = m.getAtom(index1);
            this.ligandLowIndex = index1;
        }
    }
}

