/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util;

import chemaxon.core.util.BondTableJavaArray;
import chemaxon.core.util.BondTableSparseArray;
import java.io.Serializable;

public abstract class BondTable
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8372436801118701137L;
    public static final int DEFAULT_VALUE = -1;
    private static final int LARGE_MATRIX_ATOM_NUMBER = 500;
    private final int atomCount;

    public static BondTable createBondTable(int atomCount) {
        if (atomCount > 500) {
            return BondTableSparseArray.create(atomCount);
        }
        return BondTableJavaArray.create(atomCount);
    }

    public static BondTable cloneBondTable(BondTable jsa) {
        return jsa.clone();
    }

    protected BondTable(int atomCount) {
        this.atomCount = atomCount;
    }

    public int[][] getMatrixArray() {
        if (this.getAtomCount() == 0) {
            return null;
        }
        int[][] result = new int[this.getAtomCount()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getBondIndexesToAtom(i);
        }
        return result;
    }

    public int[] getBondIndexesToAtom(int i) {
        if (this.getAtomCount() == 0) {
            return null;
        }
        int[] result = new int[this.getAtomCount()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.getBondIndex(i, j);
        }
        return result;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public abstract int getBondIndex(int var1, int var2);

    public abstract void setBondIndex(int var1, int var2, int var3);

    public BondTable clone() {
        try {
            return (BondTable)super.clone();
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }
}

