/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util;

import chemaxon.core.util.BondTable;
import java.lang.ref.SoftReference;

final class BondTableSparseArray
extends BondTable {
    private int[][] value;
    private int[][] index;
    private SoftReference arrayReference = null;

    public static BondTable create(int atomCount) {
        return new BondTableSparseArray(atomCount);
    }

    private BondTableSparseArray(int atomCount) {
        super(atomCount);
        this.value = new int[atomCount][];
        this.index = new int[atomCount][];
    }

    protected int lengthOfRow(int i) {
        return this.index[i] == null ? 0 : this.index[i].length;
    }

    @Override
    public int[][] getMatrixArray() {
        Object result = null;
        if (this.arrayReference != null) {
            result = (int[][])this.arrayReference.get();
        }
        if (result == null) {
            int i;
            result = new int[this.getAtomCount()][];
            for (i = 0; i < ((int[][])result).length; ++i) {
                result[i] = new int[this.getAtomCount()];
                result[0][i] = -1;
            }
            for (i = 0; i < ((int[][])result).length; ++i) {
                System.arraycopy(result[0], 0, result[i], 0, this.getAtomCount());
            }
            for (i = 0; i < this.index.length; ++i) {
                for (int j = 0; j < this.lengthOfRow(i); ++j) {
                    result[i][this.index[i][j]] = this.value[i][j];
                    result[this.index[i][j]][i] = this.value[i][j];
                }
            }
            this.arrayReference = new SoftReference<int[][]>((int[][])result);
        }
        return result;
    }

    @Override
    public int[] getBondIndexesToAtom(int i) {
        int[] result = new int[this.getAtomCount()];
        for (int j = 0; j < result.length; ++j) {
            result[j] = this.getBondIndex(i, j);
        }
        return result;
    }

    @Override
    public int getBondIndex(int i1, int i2) {
        int x = i2 < i1 ? i2 : i1;
        int y = x == i1 ? i2 : i1;
        int[] valuex = this.value[x];
        int[] indexx = this.index[x];
        for (int k = 0; k < this.lengthOfRow(x); ++k) {
            if (y != indexx[k]) continue;
            return valuex[k];
        }
        return -1;
    }

    @Override
    public void setBondIndex(int i1, int i2, int bondIndex) {
        int x = i2 < i1 ? i2 : i1;
        int y = x == i1 ? i2 : i1;
        int[] valuex = this.value[x];
        int[] indexx = this.index[x];
        for (int k = 0; k < this.lengthOfRow(x); ++k) {
            if (y != indexx[k]) continue;
            valuex[k] = bondIndex;
        }
        this.addElementAt(x, y, bondIndex);
    }

    private void addElementAt(int i, int j, int v) {
        int[] valuei = this.value[i];
        int[] indexi = this.index[i];
        if (valuei == null) {
            valuei = new int[1];
            indexi = new int[1];
            valuei[0] = v;
            indexi[0] = j;
            this.value[i] = valuei;
            this.index[i] = indexi;
        } else {
            int l = this.lengthOfRow(i);
            int[] value1 = new int[l + 1];
            int[] index1 = new int[l + 1];
            System.arraycopy(valuei, 0, value1, 0, l);
            System.arraycopy(indexi, 0, index1, 0, l);
            value1[l] = v;
            index1[l] = j;
            this.value[i] = value1;
            this.index[i] = index1;
        }
    }

    @Override
    public BondTableSparseArray clone() {
        BondTableSparseArray result = (BondTableSparseArray)super.clone();
        result.value = new int[this.getAtomCount()][];
        result.index = new int[this.getAtomCount()][];
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (this.index[i] == null) continue;
            result.value[i] = new int[this.value[i].length];
            result.index[i] = new int[this.index[i].length];
            System.arraycopy(this.value[i], 0, result.value[i], 0, this.value[i].length);
            System.arraycopy(this.index[i], 0, result.index[i], 0, this.index[i].length);
        }
        return result;
    }
}

