/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util;

import chemaxon.common.util.GeomCalc;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class GeomUtil {
    private static final double CCLENGTH = 1.54;
    public static double EPS = 0.1;
    public static final float SMALL_NUM = 1.0E-8f;

    public static MolBond[] getCrossingBonds(MolBond[] b, DPoint3 e1, DPoint3 e2, boolean use3D) {
        ArrayList<MolBond> list = new ArrayList<MolBond>();
        for (int i = b.length - 1; i >= 0; --i) {
            double d;
            DPoint3 b1 = b[i].getAtom1().getLocation();
            DPoint3 b2 = b[i].getAtom2().getLocation();
            if (!use3D) {
                b1.z = 0.0;
                b2.z = 0.0;
            }
            if (!((d = GeomUtil.dist3DSegmentToSegment(b1, b2, e1, e2)) < EPS)) continue;
            list.add(b[i]);
        }
        MolBond[] crossingBonds = new MolBond[list.size()];
        list.toArray(crossingBonds);
        return crossingBonds;
    }

    public static double dist3DSegmentToSegment(DPoint3 l10, DPoint3 l11, DPoint3 l20, DPoint3 l21) {
        float tN;
        float sN;
        float D;
        int u = GeomCalc.newVector((float)(l11.x - l10.x), (float)(l11.y - l10.y), (float)(l11.z - l10.z));
        int v = GeomCalc.newVector((float)(l21.x - l20.x), (float)(l21.y - l20.y), (float)(l21.z - l20.z));
        int w = GeomCalc.newVector((float)(l10.x - l20.x), (float)(l10.y - l20.y), (float)(l10.z - l20.z));
        float a = GeomCalc.dot(u, u);
        float b = GeomCalc.dot(u, v);
        float c = GeomCalc.dot(v, v);
        float d = GeomCalc.dot(u, w);
        float e = GeomCalc.dot(v, w);
        float sD = D = a * c - b * b;
        float tD = D;
        if (D < 1.0E-8f) {
            sN = 0.0f;
            sD = 1.0f;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if ((double)sN < 0.0) {
                sN = 0.0f;
                tN = e;
                tD = c;
            } else if (sN > sD) {
                sN = sD;
                tN = e + b;
                tD = c;
            }
        }
        if ((double)tN < 0.0) {
            tN = 0.0f;
            if ((double)(-d) < 0.0) {
                sN = 0.0f;
            } else if (-d > a) {
                sN = sD;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if ((double)(-d + b) < 0.0) {
                sN = 0.0f;
            } else if (-d + b > a) {
                sN = sD;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        float sc = (float)(Math.abs(sN) < 1.0E-8f ? 0.0 : (double)(sN / sD));
        float tc = (float)(Math.abs(tN) < 1.0E-8f ? 0.0 : (double)(tN / tD));
        GeomCalc.scale(u, sc);
        GeomCalc.scale(v, tc);
        int dP = GeomCalc.sub(u, v);
        GeomCalc.increase(dP, w);
        return GeomCalc.length(dP);
    }

    public static double calculateAngle(DPoint3 p0, DPoint3 p1, DPoint3 c) {
        double d0 = p0.distance(c);
        double d1 = p1.distance(c);
        if (d0 == 0.0 || d1 == 0.0) {
            return 0.0;
        }
        double p = ((p0.x - c.x) * (p1.x - c.x) + (p0.y - c.y) * (p1.y - c.y) + (p0.z - c.z) * (p1.z - c.z)) / (d0 * d1);
        return Math.acos(p);
    }

    public static double[] getLargestBondAngle2D(MolAtom a) {
        int nb = a.getBondCount();
        int[] bi = new int[nb];
        for (int i = 0; i < nb; ++i) {
            bi[i] = i;
        }
        return GeomUtil.getLargestBondAngle2D(bi, GeomUtil.bondAngles(a, bi));
    }

    public static double[] getLargestBondAngle2D(ArrayList<Integer> bi, ArrayList<Double> angles) {
        int n = angles.size();
        GeomUtil.sortAngles(angles, bi);
        double[] diffs = GeomUtil.calcAngleDiffs(angles, bi);
        double ldiff = 0.0;
        double langle = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(diffs[i]) - Math.abs(ldiff) > 1.0E-10)) continue;
            langle = angles.get(i);
            ldiff = diffs[i];
        }
        double[] r = new double[]{langle, ldiff};
        return r;
    }

    public static double[] calcAngleDiffs(ArrayList<Double> angles, ArrayList<Integer> bi) {
        int n = angles.size();
        GeomUtil.sortAngles(angles, bi);
        double[] diffs = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            diffs[i] = angles.get(i + 1) - angles.get(i);
        }
        if (n > 0) {
            diffs[n - 1] = angles.get(0) - angles.get(n - 1) + Math.PI * 2;
        }
        return diffs;
    }

    public static void sortAngles(ArrayList<Double> angles, ArrayList<Integer> bi) {
        int n = angles.size();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(angles.get(i) > angles.get(j))) continue;
                double f = angles.get(i);
                angles.set(i, angles.get(j));
                angles.set(j, f);
                int d = bi.get(i);
                bi.set(i, bi.get(j));
                bi.set(j, d);
            }
        }
    }

    public static double[] getLargestBondAngle2D(int[] bi, double[] angles) {
        int n = angles.length;
        GeomUtil.sortAngles(angles, bi, null);
        double[] diffs = GeomUtil.calcAngleDiffs(angles, bi, null);
        double ldiff = 0.0;
        double langle = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(diffs[i]) > ldiff)) continue;
            langle = angles[i];
            ldiff = diffs[i];
        }
        double[] r = new double[]{langle, ldiff};
        return r;
    }

    public static double[] bondAngles(MolAtom a0, int[] bi) {
        double[] angles = new double[bi.length];
        DPoint3 p0 = a0.getLocation();
        for (int i = 0; i < bi.length; ++i) {
            MolAtom a = a0.getLigand(bi[i]);
            angles[i] = p0.angle2D(a.getX(), a.getY());
        }
        return angles;
    }

    public static void sortAngles(double[] angles, int[] bi, int[] ai) {
        int n = angles.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(angles[i] > angles[j])) continue;
                double f = angles[i];
                angles[i] = angles[j];
                angles[j] = f;
                int d = bi[i];
                bi[i] = bi[j];
                bi[j] = d;
                if (ai == null) continue;
                d = ai[i];
                ai[i] = ai[j];
                ai[j] = d;
            }
        }
    }

    public static double[] calcAngleDiffs(double[] angles, int[] bi, int[] ai) {
        int n = angles.length;
        GeomUtil.sortAngles(angles, bi, ai);
        double[] diffs = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            diffs[i] = angles[i + 1] - angles[i];
        }
        if (n > 0) {
            diffs[n - 1] = angles[0] - angles[n - 1] + Math.PI * 2;
        }
        return diffs;
    }

    public static double calcBadness(MoleculeGraph mol1, MoleculeGraph mol2, MolAtom sa, MolBond[] xbonds) {
        int i;
        DPoint3 p1 = new DPoint3();
        DPoint3 p2 = new DPoint3();
        double badness = 0.0;
        MolAtom[] atomArr1 = mol1.getAtomArray();
        MolAtom[] atomArr2 = mol2.getAtomArray();
        ArrayList<MolAtom> atoms1 = new ArrayList<MolAtom>(atomArr1.length);
        for (int i2 = 0; i2 < atomArr1.length; ++i2) {
            atoms1.add(atomArr1[i2]);
        }
        ArrayList<MolAtom> atoms2 = new ArrayList<MolAtom>(atomArr2.length);
        for (i = 0; i < atomArr2.length; ++i) {
            atoms2.add(atomArr2[i]);
        }
        for (i = 0; i < atoms2.size(); ++i) {
            MolAtom a = (MolAtom)atoms2.get(i);
            atoms1.remove(a);
        }
        if (sa != null && !atoms2.contains(sa)) {
            atoms2.add(sa);
        }
        for (i = 0; i < atoms1.size(); ++i) {
            MolAtom a1 = (MolAtom)atoms1.get(i);
            a1.getLocation(p1);
            for (int j = 0; j < atoms2.size(); ++j) {
                MolBond bb;
                int k;
                MolAtom a2 = (MolAtom)atoms2.get(j);
                a2.getLocation(p2);
                double dx = p2.x - p1.x;
                double dy = p2.y - p1.y;
                double dz = p2.z - p1.z;
                double rsq = dx * dx + dy * dy + dz * dz;
                MolBond b = null;
                for (k = 0; k < a1.getBondCount() && b == null; ++k) {
                    bb = a1.getBond(k);
                    if (bb.getAtom1() != a2 && bb.getAtom2() != a2) continue;
                    b = bb;
                }
                if (xbonds != null) {
                    for (k = 0; k < xbonds.length && b == null; ++k) {
                        bb = xbonds[k];
                        MolAtom c1 = bb.getAtom1();
                        MolAtom c2 = bb.getAtom2();
                        if ((c1 != a1 || c2 != a2) && (c1 != a2 || c2 != a1)) continue;
                        b = bb;
                    }
                }
                if (b != null) {
                    double l0 = mol1.getDesiredLength(b);
                    double lsq = l0 * l0;
                    if (rsq < lsq) {
                        badness += 1.0 - rsq / lsq;
                        continue;
                    }
                    badness += 1.0 - lsq / rsq;
                    continue;
                }
                double lsq = 2.3716;
                if (rsq < lsq) {
                    badness += 2.0 - rsq / lsq;
                    continue;
                }
                badness += lsq / rsq;
            }
        }
        return badness;
    }

    public static double[] createSavedCoordsArray(MoleculeGraph g) {
        int na = g.getAtomCount();
        return new double[3 * na];
    }

    public static void saveCoords(MoleculeGraph g, double[] coords) {
        int na = g.getAtomCount();
        int k = 0;
        for (int i = 0; i < na; ++i) {
            MolAtom a = g.getAtom(i);
            coords[k++] = a.getX();
            coords[k++] = a.getY();
            coords[k++] = a.getZ();
        }
    }

    public static void restoreCoords(MoleculeGraph g, double[] coords) {
        int na = g.getAtomCount();
        int k = 0;
        for (int i = 0; i < na; ++i) {
            double x = coords[k++];
            double y = coords[k++];
            double z = coords[k++];
            g.getAtom(i).setXYZ(x, y, z);
        }
    }

    public static boolean arrangeComponents(MoleculeGraph mol) {
        return GeomUtil.arrangeComponents(mol, true);
    }

    public static boolean arrangeComponents(MoleculeGraph mol, boolean obj) {
        return GeomUtil.arrangeComponents(mol, obj, false);
    }

    public static boolean arrangeComponents(MoleculeGraph mol, boolean obj, boolean frags) {
        boolean changed = GeomUtil.arrangeComponentMolecules(mol, frags);
        if (obj) {
            GeomUtil.arrangeDataSgroupData(mol);
            GeomUtil.arrangeSgBrackets(mol);
        }
        return changed;
    }

    private static boolean arrangeComponentMolecules(MoleculeGraph mol, boolean arrangeFragments) {
        if (mol instanceof RgMolecule) {
            RgMolecule m = (RgMolecule)mol;
            Molecule r = m.getRoot();
            int Rgcount = m.getRgroupCount();
            if (Rgcount == 0) {
                if (r instanceof RxnMolecule) {
                    boolean isGUIContracted = m.isGUIContracted();
                    m.setGUIContracted(true);
                    GeomUtil.arrangeReaction((RxnMolecule)r);
                    m.setGUIContracted(isGUIContracted);
                    return true;
                }
                if (arrangeFragments) {
                    MoleculeGraph[] frags = r.findFrags(SelectionMolecule.class);
                    if (frags.length == 1) {
                        return false;
                    }
                    GeomUtil.arrangeMolecules(frags, 2, -1);
                    return true;
                }
                return false;
            }
            boolean isGUIContracted = m.isGUIContracted();
            m.setGUIContracted(true);
            double[] xyminmax = null;
            if (r instanceof RxnMolecule) {
                RxnMolecule rxn = (RxnMolecule)r;
                GeomUtil.arrangeReaction(rxn);
                MoleculeGraph[] rxnm = null;
                if (rxn.getProductCount() > 0) {
                    rxnm = new Molecule[rxn.getProductCount()];
                    for (int i = 0; i < rxnm.length; ++i) {
                        rxnm[i] = rxn.getProduct(i);
                    }
                } else if (rxn.getReactantCount() > 0) {
                    rxnm = new Molecule[rxn.getReactantCount()];
                    for (int i = 0; i < rxnm.length; ++i) {
                        rxnm[i] = rxn.getReactant(i);
                    }
                } else if (rxn.getAgentCount() > 0) {
                    rxnm = new Molecule[rxn.getAgentCount()];
                    for (int i = 0; i < rxnm.length; ++i) {
                        rxnm[i] = rxn.getAgent(i);
                    }
                }
                xyminmax = GeomUtil.XYminmax(rxnm);
            } else {
                GeomUtil.arrangeMolecules(r.findFrags(SelectionMolecule.class), 2, -1);
                xyminmax = GeomUtil.XYminmax(r);
            }
            GeomUtil.arrangeRgoups(m, xyminmax);
            m.setGUIContracted(isGUIContracted);
            return true;
        }
        if (mol instanceof RxnMolecule) {
            RxnMolecule m = (RxnMolecule)mol;
            boolean isGUIContracted = m.isGUIContracted();
            m.setGUIContracted(true);
            GeomUtil.arrangeReaction(m);
            m.setGUIContracted(isGUIContracted);
            return true;
        }
        if (arrangeFragments) {
            MoleculeGraph[] frags = mol.findFrags(SelectionMolecule.class);
            if (frags.length == 1) {
                return false;
            }
            GeomUtil.arrangeMolecules(frags, 2, -1);
            return true;
        }
        return false;
    }

    public static void arrangeRgoups(RgMolecule m) {
        double[] xyminmax = GeomUtil.XYminmax(m.getRoot());
        GeomUtil.arrangeRgoups(m, xyminmax);
    }

    private static void arrangeRgoups(RgMolecule m, double[] xyminmax) {
        int rgl = m.getRgroupCount();
        double rootXmax = xyminmax[1];
        double RgroupY = (xyminmax[2] + xyminmax[3]) / 2.0;
        CTransform3D T = new CTransform3D();
        Molecule[][] Rg = new Molecule[rgl][];
        for (int i = 0; i < rgl; ++i) {
            int j;
            Rg[i] = new Molecule[m.getRgroupMemberCount(i)];
            int memberCount = m.getRgroupMemberCount(i);
            for (j = 0; j < memberCount; ++j) {
                Rg[i][j] = m.getRgroupMember(i, j);
            }
            GeomUtil.arrangeMolecules(Rg[i], 2, -1);
            xyminmax = GeomUtil.XYminmax(Rg[i]);
            RgroupY = RgroupY - xyminmax[3] - 4.62;
            T.setTranslation(rootXmax - xyminmax[0] + 4.62, RgroupY, 0.0);
            for (j = 0; j < memberCount; ++j) {
                m.getRgroupMember(i, j).transform(T, false);
            }
            RgroupY += xyminmax[2];
            T.setIdentity();
        }
    }

    public static void arrangeReaction(RxnMolecule m) {
        int np;
        int nr;
        int i;
        double[] xyminmax = null;
        double AgentLeft = 0.0;
        double AgentRight = 0.0;
        double AgentWidth = 0.0;
        double AgentBottom = 0.0;
        double AgentHeight = 0.0;
        MoleculeGraph[] mf = null;
        int an = m.getAgentCount();
        if (an > 0) {
            mf = new MoleculeGraph[an];
            int pos = 0;
            for (int i2 = 0; i2 < an; ++i2) {
                mf[pos++] = m.getAgent(i2);
            }
            GeomUtil.arrangeMolecules(mf, 2, mf.length);
            xyminmax = GeomUtil.XYminmax(mf);
            AgentLeft = xyminmax[0];
            AgentRight = xyminmax[1];
            AgentWidth = AgentRight - AgentLeft;
            AgentBottom = xyminmax[2];
        }
        DPoint3[] arrow = new DPoint3[2];
        double mult = 0.1;
        arrow[0] = new DPoint3(AgentLeft - AgentWidth * mult, 0.0, 0.0);
        double dx_arrow = AgentRight + AgentWidth * mult;
        arrow[1] = new DPoint3(dx_arrow == 0.0 ? 1.54 : dx_arrow, 0.0, 0.0);
        m.setReactionArrowEndPoints(arrow);
        double dx = arrow[1].x - arrow[0].x;
        dx = dx / 3.0 < 3.08 ? 3.08 : dx / 3.0;
        CTransform3D T = new CTransform3D();
        if (an > 0) {
            T.setIdentity();
            DPoint3 agentT = new DPoint3(arrow[0].x + (arrow[1].x - arrow[0].x) / 2.0 - (AgentLeft + AgentWidth / 2.0), (arrow[1].y - arrow[0].y) / 2.0 - AgentBottom + dx / 2.0, 0.0);
            T.setTranslation(agentT);
            int mfl = mf.length;
            for (i = 0; i < mfl; ++i) {
                mf[i].transform(T, false);
            }
        }
        if ((nr = m.getReactantCount()) > 0) {
            mf = new MoleculeGraph[nr];
            int pos = 0;
            for (i = 0; i < nr; ++i) {
                mf[pos++] = m.getReactant(i);
            }
            GeomUtil.arrangeMolecules(mf, 2, mf.length);
            xyminmax = GeomUtil.XYminmax(mf);
            double ReactRight = xyminmax[1];
            double ReactVertMiddle = (xyminmax[3] + xyminmax[2]) / 2.0;
            DPoint3 reactionT = new DPoint3(arrow[0].x - ReactRight - dx, arrow[0].y - ReactVertMiddle, 0.0);
            T.setIdentity();
            T.setTranslation(reactionT);
            int mfl = mf.length;
            for (int i3 = 0; i3 < mfl; ++i3) {
                mf[i3].transform(T, false);
            }
        }
        if ((np = m.getProductCount()) > 0) {
            mf = new MoleculeGraph[np];
            int pos = 0;
            for (int i4 = 0; i4 < np; ++i4) {
                mf[pos++] = m.getProduct(i4);
            }
            GeomUtil.arrangeMolecules(mf, 2, mf.length);
            xyminmax = GeomUtil.XYminmax(mf);
            double ProdLeft = xyminmax[0];
            double ProdVertMiddle = (xyminmax[3] + xyminmax[2]) / 2.0;
            DPoint3 productT = new DPoint3(arrow[1].x - ProdLeft + dx, arrow[1].y - ProdVertMiddle, 0.0);
            T.setIdentity();
            T.setTranslation(productT);
            int mfl = mf.length;
            for (int i5 = 0; i5 < mfl; ++i5) {
                mf[i5].transform(T, false);
            }
        }
        if (arrow[0].distance2D(arrow[1]) == 0.0) {
            m.recalcReactionArrow();
        }
    }

    public static void arrangeMolecules(MoleculeGraph[] mo, int dist, int col) {
        CTransform3D T = new CTransform3D();
        double[] xmin = new double[mo.length];
        double[] xmax = new double[mo.length];
        double[] ymin = new double[mo.length];
        double[] ymax = new double[mo.length];
        double rowymin = 0.0;
        double rowymax = 0.0;
        double xmove = 0.0;
        double ymove = 0.0;
        col = col < 0 ? (int)Math.round(Math.ceil(Math.sqrt(mo.length))) : col;
        int c = 0;
        int mol = mo.length;
        for (int s = 0; s < mol; ++s) {
            MoleculeGraph m = mo[s];
            DPoint3 center = m.calcCenter();
            T.setIdentity();
            T.setTranslation(-center.x, -center.y, 0.0);
            m.transform(T, false);
            double[] v = GeomUtil.XYminmax(m);
            xmin[s] = v[0];
            xmax[s] = v[1];
            ymin[s] = v[2];
            ymax[s] = v[3];
        }
        while (c < mo.length) {
            rowymin = Double.MAX_VALUE;
            boolean prevSmallIon = false;
            boolean thisSmallIon = false;
            for (int i = 0; i < col; ++i) {
                if (c >= mo.length) continue;
                MoleculeGraph m = mo[c];
                thisSmallIon = GeomUtil.isSmallIon(m);
                if (i > 0) {
                    xmove = prevSmallIon && thisSmallIon ? xmove - xmin[c] + 0.77 : xmove - xmin[c] + (double)dist * 1.54;
                }
                T.setIdentity();
                T.setTranslation(xmove, ymove, 0.0);
                m.transform(T, false);
                rowymin = rowymin > ymin[c] ? ymin[c] : rowymin;
                xmove += xmax[c];
                ++c;
                prevSmallIon = thisSmallIon;
            }
            xmove = 0.0;
            ymove = ymove + rowymin - (double)dist * 1.54;
            int r = c;
            rowymax = -1.7976931348623157E308;
            for (int i = 0; i < col; ++i) {
                if (r >= mo.length) continue;
                rowymax = rowymax < ymax[r] ? ymax[r] : rowymax;
                ++r;
            }
            ymove -= rowymax;
        }
    }

    public static boolean isSmallIon(MoleculeGraph m) {
        if (m.getAtomCount() != 1) {
            return false;
        }
        MolAtom a = m.getAtom(0);
        return a.getCharge() != 0;
    }

    private static double[] XYminmax(MoleculeGraph m) {
        int ac = m.getAtomCount();
        if (ac == 0) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        double[] v = new double[4];
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        double len = 0.22;
        for (int i = 0; i < ac; ++i) {
            MolAtom a;
            String symbol;
            double diff;
            double[] visCoords = m.getVisibleCoords(m.getAtom(i));
            if (visCoords[0] - (diff = (double)(symbol = (a = m.getAtom(i)).getAtomSymbol(1, -1, null, null)).length() * len) < xmin) {
                xmin = visCoords[0] - diff;
            }
            if (visCoords[0] > xmax) {
                xmax = visCoords[0];
            }
            if (visCoords[1] < ymin) {
                ymin = visCoords[1];
            }
            if (!(visCoords[1] > ymax)) continue;
            ymax = visCoords[1];
        }
        v[0] = xmin;
        v[1] = xmax;
        v[2] = ymin;
        v[3] = ymax;
        return v;
    }

    private static double[] XYminmax(MoleculeGraph[] mols) {
        double[] v = new double[4];
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        int ml = mols.length;
        for (int i = 0; i < ml; ++i) {
            double[] xyminmax = GeomUtil.XYminmax(mols[i]);
            xmin = xmin > xyminmax[0] ? xyminmax[0] : xmin;
            xmax = xmax < xyminmax[1] ? xyminmax[1] : xmax;
            ymin = ymin > xyminmax[2] ? xyminmax[2] : ymin;
            ymax = ymax < xyminmax[3] ? xyminmax[3] : ymax;
        }
        v[0] = xmin;
        v[1] = xmax;
        v[2] = ymin;
        v[3] = ymax;
        return v;
    }

    public static void arrangeDataSgroupData(MoleculeGraph m) {
        if (m instanceof Molecule) {
            Molecule mol = (Molecule)m;
            int sgc = mol.getSgroupCount();
            HashMap<BitSet, Integer> dataSgroupGraphs = new HashMap<BitSet, Integer>();
            for (int i = 0; i < sgc; ++i) {
                DataSgroup dsg;
                Sgroup sg = mol.getSgroup(i);
                if (!(sg instanceof DataSgroup) || !(dsg = (DataSgroup)sg).isDataDetached() || dsg.getData() == null) continue;
                BitSet atomSet = GeomUtil.getAtomArrayBitSet(dsg, m);
                int n = 0;
                if (dataSgroupGraphs.containsKey(atomSet)) {
                    n = (Integer)dataSgroupGraphs.get(atomSet);
                    dataSgroupGraphs.put(atomSet, ++n);
                } else {
                    dataSgroupGraphs.put(atomSet, 0);
                }
                SuperatomSgroup lcsg = GeomUtil.getLastClosedSgroup(dsg);
                double[] xy = null;
                if (lcsg == null) {
                    xy = GeomUtil.XYminmax(dsg.getSgroupGraph());
                } else {
                    SgroupAtom sa = lcsg.getSuperAtom();
                    xy = new double[4];
                    xy[1] = sa.getX();
                    xy[2] = sa.getY();
                }
                if (dsg.isAbsolutePlacement()) {
                    xy[1] = xy[1] + 0.77;
                    xy[2] = xy[2] - (0.77 - (double)n * 1.54 / 2.0);
                    dsg.setX(xy[1]);
                    dsg.setY(xy[2]);
                    continue;
                }
                dsg.setX((xy[1] - xy[0]) / 2.0 + 0.77);
                dsg.setY(-(xy[3] - xy[2]) / 2.0 - 0.77 - (double)n * 1.54 / 2.0);
            }
        }
    }

    private static BitSet getAtomArrayBitSet(Sgroup sg, MoleculeGraph m) {
        BitSet s = new BitSet();
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            MolAtom a = sg.getAtom(i);
            int index = m.indexOf(a);
            if (index < 0) {
                return null;
            }
            s.set(index);
        }
        return s;
    }

    private static SuperatomSgroup getLastClosedSgroup(Sgroup sg) {
        SuperatomSgroup ssg;
        Sgroup psg = sg.getParentSgroup();
        SuperatomSgroup s = null;
        if (psg != null) {
            s = GeomUtil.getLastClosedSgroup(psg);
        }
        if (s == null && psg instanceof SuperatomSgroup && (ssg = (SuperatomSgroup)psg).isContracted()) {
            return ssg;
        }
        return s;
    }

    public static void arrangeSgBrackets(MoleculeGraph m) {
        if (m instanceof Molecule) {
            Molecule mol = (Molecule)m;
            int sgc = mol.getSgroupCount();
            for (int i = 0; i < sgc; ++i) {
                Sgroup sg = mol.getSgroup(i);
                if (sg.getBracketCount() <= 0) continue;
                double d = 0.77 * (double)GeomUtil.getDeepness(sg);
                double xmin = Double.MAX_VALUE;
                double xmax = -1.7976931348623157E308;
                double ymin = Double.MAX_VALUE;
                double ymax = -1.7976931348623157E308;
                for (int j = 0; j < sg.getAtomCount(); ++j) {
                    double y;
                    double x = sg.getAtom(j).getX();
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (x < xmin) {
                        xmin = x;
                    }
                    if ((y = sg.getAtom(j).getY()) > ymax) {
                        ymax = y;
                    }
                    if (!(y < ymin)) continue;
                    ymin = y;
                }
                ArrayList<MBracket> brackets = sg.getBrackets();
                MBracket b1 = brackets.get(0);
                int orientation = b1.getBracketOrientation();
                if (orientation == 4) {
                    b1.setCorners(new MPoint(xmin - d, ymax + d, 0.0), new MPoint(xmin - d + 0.385, ymin - d, 0.0));
                    if (brackets.size() <= 1) continue;
                    MBracket b2 = brackets.get(1);
                    b2.setCorners(new MPoint(xmax + d, ymin - d, 0.0), new MPoint(xmax + d - 0.385, ymax + d, 0.0));
                    continue;
                }
                if (orientation != 5) continue;
                b1.setCorners(new MPoint(xmin - d, ymax + d), new MPoint(xmax + d, ymin - d));
            }
        }
    }

    public static int getDeepness(Sgroup sg) {
        int deepness = 0;
        for (int i = 0; i < sg.getChildSgroupCount(); ++i) {
            if (sg.getChildSgroup(i).findCrossingBonds().length != 0) continue;
            deepness = Math.max(GeomUtil.getDeepness(sg.getChildSgroup(i)), deepness);
        }
        return deepness + 1;
    }
}

