/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.sgroup.DataSgroup;

public class DataSgroupDiffer
extends BasicSgroupDiffer {
    private boolean ignoreData = false;
    private boolean ignoreFieldName = false;
    private boolean ignoreFieldType = false;
    private boolean ignoreUnits = false;
    private boolean ignoreTag = false;
    private boolean ignorePosition = false;
    private boolean ignoreAbsolutePlacement = false;
    private boolean ignoreQuery = false;
    private boolean ignoreDataDetached = false;
    private boolean ignoreDisplayOptions = false;
    private boolean ignoreContext = false;
    private boolean ignorePos = false;

    protected String compareData(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getData(), sgroup2.getData())) {
            return DifferUtils.getAttributeDifferenceString("data S-group data", sgroup1.getData(), sgroup2.getData());
        }
        return null;
    }

    public void ignoreData(boolean ignoreState) {
        this.ignoreData = ignoreState;
    }

    protected String compareFieldName(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getFieldName(), sgroup2.getFieldName())) {
            return DifferUtils.getAttributeDifferenceString("data S-group field name", sgroup1.getFieldName(), sgroup2.getFieldName());
        }
        return null;
    }

    public void ignoreFieldName(boolean ignoreState) {
        this.ignoreFieldName = ignoreState;
    }

    protected String compareFieldType(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.getFieldType() != sgroup2.getFieldType()) {
            return DifferUtils.getAttributeDifferenceString("data S-group field type", sgroup1.getFieldType(), sgroup2.getFieldType());
        }
        return null;
    }

    public void ignoreFieldType(boolean ignoreState) {
        this.ignoreFieldType = ignoreState;
    }

    protected String compareUnits(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getUnits(), sgroup2.getUnits())) {
            return DifferUtils.getAttributeDifferenceString("data S-group units", sgroup1.getUnits(), sgroup2.getUnits());
        }
        return null;
    }

    public void ignoreUnits(boolean ignoreState) {
        this.ignoreUnits = ignoreState;
    }

    protected String compareTag(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.getTag() != sgroup2.getTag()) {
            return DifferUtils.getAttributeDifferenceString("data S-group tag", sgroup1.getTag(), sgroup2.getTag());
        }
        return null;
    }

    public void ignoreTag(boolean ignoreState) {
        this.ignoreTag = ignoreState;
    }

    protected String comparePosition(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!sgroup1.getAbsoluteXY().equals(sgroup2.getAbsoluteXY())) {
            return DifferUtils.getAttributeDifferenceString("data S-group position", sgroup1.getAbsoluteXY(), sgroup2.getAbsoluteXY());
        }
        return null;
    }

    public void ignorePosition(boolean ignoreState) {
        this.ignorePosition = ignoreState;
    }

    protected String compareAbsolutePlacement(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.isAbsolutePlacement() != sgroup2.isAbsolutePlacement()) {
            return DifferUtils.getAttributeDifferenceString("data S-group absolute placement", sgroup1.isAbsolutePlacement(), sgroup2.isAbsolutePlacement());
        }
        return null;
    }

    public void ignoreAbsolutePlacement(boolean ignoreState) {
        this.ignoreAbsolutePlacement = ignoreState;
    }

    protected String compareQuery(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getQueryCode(), sgroup2.getQueryCode())) {
            return DifferUtils.getAttributeDifferenceString("data S-group query code", sgroup1.getQueryCode(), sgroup2.getQueryCode());
        }
        if (!DifferUtils.equalsStrings(sgroup1.getQueryOp(), sgroup2.getQueryOp())) {
            return DifferUtils.getAttributeDifferenceString("data S-group query operator", sgroup1.getQueryOp(), sgroup2.getQueryOp());
        }
        return null;
    }

    public void ignoreQuery(boolean ignoreState) {
        this.ignoreQuery = ignoreState;
    }

    protected String compareDataDetached(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.isDataDetached() != sgroup2.isDataDetached()) {
            return DifferUtils.getAttributeDifferenceString("data S-group data detached", sgroup1.isDataDetached(), sgroup2.isDataDetached());
        }
        return null;
    }

    public void ignoreDataDetached(boolean ignoreState) {
        this.ignoreDataDetached = ignoreState;
    }

    protected String compareDisplayOptions(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.isUnitDisplayed() != sgroup2.isUnitDisplayed()) {
            return DifferUtils.getAttributeDifferenceString("data S-group unit displayed", sgroup1.isUnitDisplayed(), sgroup2.isUnitDisplayed());
        }
        if (sgroup1.getDisplayedChars() != sgroup2.getDisplayedChars()) {
            return DifferUtils.getAttributeDifferenceString("data S-group displayed characters", sgroup1.getDisplayedChars(), sgroup2.getDisplayedChars());
        }
        if (sgroup1.getDisplayedLines() != sgroup2.getDisplayedLines()) {
            return DifferUtils.getAttributeDifferenceString("data S-group displayed lines", sgroup1.getDisplayedLines(), sgroup2.getDisplayedLines());
        }
        return null;
    }

    public void ignoreDisplayOptions(boolean ignoreState) {
        this.ignoreDisplayOptions = ignoreState;
    }

    protected String compareContext(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (!DifferUtils.equalsStrings(sgroup1.getContext(), sgroup2.getContext())) {
            return DifferUtils.getAttributeDifferenceString("data S-group context", sgroup1.getContext(), sgroup2.getContext());
        }
        return null;
    }

    public void ignoreContext(boolean ignoreState) {
        this.ignoreContext = ignoreState;
    }

    protected String comparePos(DataSgroup sgroup1, DataSgroup sgroup2) {
        if (sgroup1.getPos() != sgroup2.getPos()) {
            return DifferUtils.getAttributeDifferenceString("data S-group DASP pos", sgroup1.getPos(), sgroup2.getPos());
        }
        return null;
    }

    public void ignorePos(boolean ignoreState) {
        this.ignorePos = ignoreState;
    }

    String compareAttributes(DataSgroup sgroup1, DataSgroup sgroup2) {
        String difference = super.compareAttributes(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        if (!this.ignoreData && (difference = this.compareData(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreFieldName && (difference = this.compareFieldName(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreFieldType && (difference = this.compareFieldType(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreUnits && (difference = this.compareUnits(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreTag && (difference = this.compareTag(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignorePosition && (difference = this.comparePosition(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreAbsolutePlacement && (difference = this.compareAbsolutePlacement(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreQuery && (difference = this.compareQuery(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreDataDetached && (difference = this.compareDataDetached(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreDisplayOptions && (difference = this.compareDisplayOptions(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreContext && (difference = this.compareContext(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignorePos && (difference = this.comparePos(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }
}

