/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.differ.AtomDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.sgroup.SgroupAtom;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class DefaultAtomDiffer
implements AtomDiffer {
    private static final double EPSILON = 1.0E-5;
    private boolean ignoreLeftName;
    private boolean ignoreRightName;
    private boolean ignoreLabelCenter;
    private boolean ignoreAtomicNumber;
    private boolean ignoreBicycloSteroDescriptors;
    private boolean ignoreProperties;
    private boolean ignoreImplicitHCount;
    private boolean ignoreCharge;
    private boolean ignoreRadicalCount;
    private boolean ignoreRadical;
    private double coordinateThreshold = 0.0;
    private boolean ignoreCoordinates;
    private boolean ignoreMassNumber;
    private boolean ignoreAtomMap;
    private boolean ignoreExtraLabel;
    private boolean ignoreParity;
    private boolean ignoreStereoGroupType;
    private boolean ignoreStereoGroupNumber;
    private boolean ignoreReactionStereo;
    private boolean ignoreValenceProperty;
    private boolean ignoreNonQueryImplicitHCount;
    private boolean ignoreQueryProperties;
    private boolean ignoreRgroupID;
    private boolean ignoreAttachmentPoint;
    private boolean ignoreMaxRepetition;
    private boolean ignoreMinRepetition;
    private boolean ignoreQueryString;
    private boolean ignoreAliasString;
    private boolean ignoreExtraLabelColor;
    private boolean ignoreList;
    private boolean ignoreResidueAtomId;
    private boolean ignoreElectronProperty;
    private boolean ignoreRgroupAttachmentPointOrder;
    private boolean ignoreHybridizationState;
    private boolean ignoreExtraLabelSetSeq;
    private boolean ignoreResidueType;
    private boolean ignoreResidueSequence;
    private boolean ignoreChirality;
    private boolean ignoreAtomStereo;
    private boolean ignoreSelection;

    public void ignoreLeftName(boolean ignoreLeftName) {
        this.ignoreLeftName = ignoreLeftName;
    }

    public void ignoreRightName(boolean ignoreRightName) {
        this.ignoreRightName = ignoreRightName;
    }

    public void ignoreLabelCenter(boolean ignoreLabelCenter) {
        this.ignoreLabelCenter = ignoreLabelCenter;
    }

    public void ignoreAtomicNumber(boolean ignoreAtomicNumber) {
        this.ignoreAtomicNumber = ignoreAtomicNumber;
    }

    public void ignoreBicycloStereoDescriptors(boolean ignoreBicycloSteroDescriptors) {
        this.ignoreBicycloSteroDescriptors = ignoreBicycloSteroDescriptors;
    }

    public void ignoreProperties(boolean ignoreProperties) {
        this.ignoreProperties = ignoreProperties;
    }

    public void ignoreImplicitHCount(boolean ignoreImplicitHCount) {
        this.ignoreImplicitHCount = ignoreImplicitHCount;
    }

    public void ignoreCharge(boolean ignoreCharge) {
        this.ignoreCharge = ignoreCharge;
    }

    public void ignoreRadicalCount(boolean ignoreRadicalCount) {
        this.ignoreRadicalCount = ignoreRadicalCount;
    }

    public void ignoreRadical(boolean ignoreRadical) {
        this.ignoreRadical = ignoreRadical;
    }

    public void setCoordinateThreshold(double threshold) {
        this.coordinateThreshold = threshold;
    }

    public void ignoreCoordinates(boolean ignoreCoordinates) {
        this.ignoreCoordinates = ignoreCoordinates;
    }

    public void ignoreMassNumber(boolean ignoreMassNumber) {
        this.ignoreMassNumber = ignoreMassNumber;
    }

    public void ignoreAtomMap(boolean ignoreAtomMap) {
        this.ignoreAtomMap = ignoreAtomMap;
    }

    public void ignoreExtraLabel(boolean ignoreExtraLabel) {
        this.ignoreExtraLabel = ignoreExtraLabel;
    }

    public void ignoreParity(boolean ignoreParity) {
        this.ignoreParity = ignoreParity;
    }

    public void ignoreStereoGroupType(boolean ignoreStereoGroupType) {
        this.ignoreStereoGroupType = ignoreStereoGroupType;
    }

    public void ignoreStereoGroupNumber(boolean ignoreStereoGroupNumber) {
        this.ignoreStereoGroupNumber = ignoreStereoGroupNumber;
    }

    public void ignoreReactionStereo(boolean ignoreReactionStereo) {
        this.ignoreReactionStereo = ignoreReactionStereo;
    }

    public void ignoreValenceProperty(boolean ignoreValenceProperty) {
        this.ignoreValenceProperty = ignoreValenceProperty;
    }

    public void ignoreNonQueryImplicitHCount(boolean ignoreNonQueryImplicitHCount) {
        this.ignoreNonQueryImplicitHCount = ignoreNonQueryImplicitHCount;
    }

    public void ignoreQueryProperties(boolean ignoreQueryProperty) {
        this.ignoreQueryProperties = ignoreQueryProperty;
    }

    public void ignoreRgroupId(boolean ignoreRgroupId) {
        this.ignoreRgroupID = ignoreRgroupId;
    }

    public void ignoreAttachmentPoint(boolean ignoreAttachmentPoint) {
        this.ignoreAttachmentPoint = ignoreAttachmentPoint;
    }

    public void ignoreMaxRepetition(boolean ignoreMaxRepetition) {
        this.ignoreMaxRepetition = ignoreMaxRepetition;
    }

    public void ignoreMinRepetition(boolean ignoreMinRepetition) {
        this.ignoreMinRepetition = ignoreMinRepetition;
    }

    public void ignoreQueryString(boolean ignoreQueryString) {
        this.ignoreQueryString = ignoreQueryString;
    }

    public void ignoreAliasString(boolean ignoreAliasString) {
        this.ignoreAliasString = ignoreAliasString;
    }

    public void ignoreExtraLabelColor(boolean ignoreExtraLabelColor) {
        this.ignoreExtraLabelColor = ignoreExtraLabelColor;
    }

    public void ignoreList(boolean ignoreList) {
        this.ignoreList = ignoreList;
    }

    public void ignoreResidueAtomId(boolean ignoreResidueAtomId) {
        this.ignoreResidueAtomId = ignoreResidueAtomId;
    }

    public void ignoreElectronProperty(boolean ignoreElectronProperty) {
        this.ignoreElectronProperty = ignoreElectronProperty;
    }

    public void ignoreRgroupAttachmentPointOrder(boolean ignoreRgroupAttachmentPointOrder) {
        this.ignoreRgroupAttachmentPointOrder = ignoreRgroupAttachmentPointOrder;
    }

    public void ignoreHybridizationState(boolean ignoreHybridizationState) {
        this.ignoreHybridizationState = ignoreHybridizationState;
    }

    public void ignoreExtraLabelSetSeq(boolean ignoreExtraLabelSetSeq) {
        this.ignoreExtraLabelSetSeq = ignoreExtraLabelSetSeq;
    }

    public void ignoreResidueType(boolean ignoreResidueType) {
        this.ignoreResidueType = ignoreResidueType;
    }

    public void ignoreResidueSequence(boolean ignoreResidueSequence) {
        this.ignoreResidueSequence = ignoreResidueSequence;
    }

    public void ignoreChirality(boolean ignoreChirality) {
        this.ignoreChirality = ignoreChirality;
    }

    public void ignoreAtomStereo(boolean ignoreAtomStereo) {
        this.ignoreAtomStereo = ignoreAtomStereo;
    }

    public void ignoreSelection(boolean ignoreSelection) {
        this.ignoreSelection = ignoreSelection;
    }

    @Override
    public boolean equals(MolAtom atom1, MolAtom atom2) {
        return this.diff(atom1, atom2) == null;
    }

    @Override
    public String diff(MolAtom atom1, MolAtom atom2) {
        if (atom1 == null && atom2 == null) {
            return null;
        }
        if (atom1 == null || atom2 == null) {
            return DifferUtils.getAttributeDifferenceString("atom reference", atom1 == null ? "null" : "not null", atom2 == null ? "null" : "not null");
        }
        String difference = null;
        if (!this.ignoreAliasString && (difference = this.compareAliasString(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreAtomicNumber && (difference = this.compareAtomicNumber(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreAtomMap && (difference = this.compareAtomMap(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreAtomStereo && (difference = this.compareAtomStereo(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreAttachmentPoint && (difference = this.compareAttachmentPoint(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreCharge && (difference = this.compareCharge(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreChirality && (difference = this.compareChirality(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreCoordinates && (difference = this.compareCoordinates(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreElectronProperty && (difference = this.compareElectronProperty(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreExtraLabel && (difference = this.compareExtraLabel(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreExtraLabelColor && (difference = this.compareExtraLabelColor(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreExtraLabelSetSeq && (difference = this.compareExtraLabelSetSeq(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreHybridizationState && (difference = this.compareHybridizationState(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreImplicitHCount && (difference = this.compareImplicitHCount(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreList && (difference = this.compareList(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreMassNumber && (difference = this.compareMassNumber(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreMaxRepetition && (difference = this.compareMaxRepetition(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreMinRepetition && (difference = this.compareMinRepetition(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreNonQueryImplicitHCount && (difference = this.compareNonQueryImplicitHCount(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreParity && (difference = this.compareParity(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreProperties && (difference = this.compareProperties(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreQueryProperties && (difference = this.compareQueryProperties(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreQueryString && (difference = this.compareQueryString(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreRadical && (difference = this.compareRadical(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreRadicalCount && (difference = this.compareRadicalCount(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreReactionStereo && (difference = this.compareReactionStereo(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreResidueAtomId && (difference = this.compareResidueAtomId(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreResidueSequence && (difference = this.compareResidueSequence(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreResidueType && (difference = this.compareResidueType(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreRgroupAttachmentPointOrder && (difference = this.compareRgroupAttachmentPointOrder(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreRgroupID && (difference = this.compareRgroupID(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreStereoGroupNumber && (difference = this.compareStereoGroupNumber(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreStereoGroupType && (difference = this.compareStereoGroupType(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreValenceProperty && (difference = this.compareValenceProperty(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreBicycloSteroDescriptors && (difference = this.compareBicycloStereoDescriptors(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreLeftName && (difference = this.compareLeftName(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreRightName && (difference = this.compareRightName(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreLabelCenter && (difference = this.compareLabelCenter(atom1, atom2)) != null) {
            return difference;
        }
        if (!this.ignoreSelection && (difference = this.compareSelection(atom1, atom2)) != null) {
            return difference;
        }
        return null;
    }

    protected String compareSelection(MolAtom atom1, MolAtom atom2) {
        if (atom1.isSelected() == atom2.isSelected()) {
            return null;
        }
        return DifferUtils.getAttributeDifferenceString("selection", atom1.isSelected(), atom2.isSelected());
    }

    protected String compareLabelCenter(MolAtom atom1, MolAtom atom2) {
        if (this.equalsLabelCenter(atom1, atom2)) {
            return null;
        }
        return this.diffLabelCenter(atom1, atom2);
    }

    protected String compareRightName(MolAtom atom1, MolAtom atom2) {
        if (this.equalsRightName(atom1, atom2)) {
            return null;
        }
        return this.diffRightName(atom1, atom2);
    }

    protected String compareLeftName(MolAtom atom1, MolAtom atom2) {
        if (this.equalsLeftName(atom1, atom2)) {
            return null;
        }
        return this.diffLeftName(atom1, atom2);
    }

    protected String compareBicycloStereoDescriptors(MolAtom atom1, MolAtom atom2) {
        if (this.equalsBicycloStereoDescriptors(atom1, atom2)) {
            return null;
        }
        return this.diffBicycloStereoDescriptors(atom1, atom2);
    }

    protected String compareValenceProperty(MolAtom atom1, MolAtom atom2) {
        if (this.equalsValenceProperty(atom1, atom2)) {
            return null;
        }
        return this.diffValenceProperty(atom1, atom2);
    }

    protected String compareStereoGroupType(MolAtom atom1, MolAtom atom2) {
        if (this.equalsStereoGroupType(atom1, atom2)) {
            return null;
        }
        return this.diffStereoGroupType(atom1, atom2);
    }

    protected String compareStereoGroupNumber(MolAtom atom1, MolAtom atom2) {
        if (this.equalsStereoGroupNumber(atom1, atom2)) {
            return null;
        }
        return this.diffStereoGroupNumber(atom1, atom2);
    }

    protected String compareRgroupID(MolAtom atom1, MolAtom atom2) {
        if (this.equalsRgroupID(atom1, atom2)) {
            return null;
        }
        return this.diffRgroupID(atom1, atom2);
    }

    protected String compareRgroupAttachmentPointOrder(MolAtom atom1, MolAtom atom2) {
        if (this.equalsRgroupAttachmentPointOrder(atom1, atom2)) {
            return null;
        }
        return this.diffRgroupAttachmentPointOrder(atom1, atom2);
    }

    protected String compareResidueType(MolAtom atom1, MolAtom atom2) {
        if (this.equalsResidueType(atom1, atom2)) {
            return null;
        }
        return this.diffResidueType(atom1, atom2);
    }

    protected String compareResidueSequence(MolAtom atom1, MolAtom atom2) {
        if (this.equalsResidueSequence(atom1, atom2)) {
            return null;
        }
        return this.diffResidueSequence(atom1, atom2);
    }

    protected String compareResidueAtomId(MolAtom atom1, MolAtom atom2) {
        if (this.equalsResidueAtomId(atom1, atom2)) {
            return null;
        }
        return this.diffResidueAtomId(atom1, atom2);
    }

    protected String compareReactionStereo(MolAtom atom1, MolAtom atom2) {
        if (this.equalsReactionStereo(atom1, atom2)) {
            return null;
        }
        return this.diffReactionStereo(atom1, atom2);
    }

    protected String compareRadicalCount(MolAtom atom1, MolAtom atom2) {
        if (this.equalsRadicalCount(atom1, atom2)) {
            return null;
        }
        return this.diffRadicalCount(atom1, atom2);
    }

    protected String compareRadical(MolAtom atom1, MolAtom atom2) {
        if (this.equalsRadical(atom1, atom2)) {
            return null;
        }
        return this.diffRadical(atom1, atom2);
    }

    protected String compareQueryString(MolAtom atom1, MolAtom atom2) {
        if (this.equalsQueryString(atom1, atom2)) {
            return null;
        }
        return this.diffQueryString(atom1, atom2);
    }

    protected String compareQueryProperties(MolAtom atom1, MolAtom atom2) {
        if (this.equalsQueryProperties(atom1, atom2)) {
            return null;
        }
        return this.diffQueryProperties(atom1, atom2);
    }

    protected String compareProperties(MolAtom atom1, MolAtom atom2) {
        if (this.equalsProperties(atom1, atom2)) {
            return null;
        }
        return this.diffProperties(atom1, atom2);
    }

    protected String compareParity(MolAtom atom1, MolAtom atom2) {
        if (this.equalsParity(atom1, atom2)) {
            return null;
        }
        return this.diffParity(atom1, atom2);
    }

    protected String compareNonQueryImplicitHCount(MolAtom atom1, MolAtom atom2) {
        if (this.equalsNonQueryImplicitHCount(atom1, atom2)) {
            return null;
        }
        return this.diffNonQueryImplicitHCount(atom1, atom2);
    }

    protected String compareMaxRepetition(MolAtom atom1, MolAtom atom2) {
        if (this.equalsMaxRepetition(atom1, atom2)) {
            return null;
        }
        return this.diffMaxRepetition(atom1, atom2);
    }

    protected String compareMinRepetition(MolAtom atom1, MolAtom atom2) {
        if (this.equalsMinRepetition(atom1, atom2)) {
            return null;
        }
        return this.diffMinRepetition(atom1, atom2);
    }

    protected String compareMassNumber(MolAtom atom1, MolAtom atom2) {
        if (this.equalsMassNumber(atom1, atom2)) {
            return null;
        }
        return this.diffMassNumber(atom1, atom2);
    }

    protected String compareList(MolAtom atom1, MolAtom atom2) {
        if (this.equalsList(atom1, atom2)) {
            return null;
        }
        return this.diffList(atom1, atom2);
    }

    protected String compareImplicitHCount(MolAtom atom1, MolAtom atom2) {
        if (this.equalsImplicitHCount(atom1, atom2)) {
            return null;
        }
        return this.diffImplicitHCount(atom1, atom2);
    }

    protected String compareHybridizationState(MolAtom atom1, MolAtom atom2) {
        if (this.equalsHybridizationState(atom1, atom2)) {
            return null;
        }
        return this.diffHybridizaitonState(atom1, atom2);
    }

    protected String compareExtraLabelSetSeq(MolAtom atom1, MolAtom atom2) {
        if (this.equalsExtraLabelSetSeq(atom1, atom2)) {
            return null;
        }
        return this.diffExtraLabelSetSeq(atom1, atom2);
    }

    protected String compareExtraLabelColor(MolAtom atom1, MolAtom atom2) {
        if (this.equalsExtraLabelColor(atom1, atom2)) {
            return null;
        }
        return this.diffExtraLabelColor(atom1, atom2);
    }

    protected String compareExtraLabel(MolAtom atom1, MolAtom atom2) {
        if (this.equalsExtraLabel(atom1, atom2)) {
            return null;
        }
        return this.diffExtraLabel(atom1, atom2);
    }

    protected String compareElectronProperty(MolAtom atom1, MolAtom atom2) {
        if (this.equalsElectronProperty(atom1, atom2)) {
            return null;
        }
        return this.diffElectronProperty(atom1, atom2);
    }

    protected String compareCoordinates(MolAtom atom1, MolAtom atom2) {
        if (this.equalsCoordinates(atom1, atom2)) {
            return null;
        }
        return this.diffCoordinates(atom1, atom2);
    }

    protected String compareChirality(MolAtom atom1, MolAtom atom2) {
        if (this.equalsChirality(atom1, atom2)) {
            return null;
        }
        return this.diffChiralilty(atom1, atom2);
    }

    protected String compareCharge(MolAtom atom1, MolAtom atom2) {
        if (this.equalsCharge(atom1, atom2)) {
            return null;
        }
        return this.diffCharge(atom1, atom2);
    }

    protected String compareAttachmentPoint(MolAtom atom1, MolAtom atom2) {
        if (this.equalsAttachmentPoint(atom1, atom2)) {
            return null;
        }
        return this.diffAttachmentPoint(atom1, atom2);
    }

    protected String compareAtomStereo(MolAtom atom1, MolAtom atom2) {
        if (this.equalsAtomStereo(atom1, atom2)) {
            return null;
        }
        return this.diffAtomStereo(atom1, atom2);
    }

    protected String compareAtomMap(MolAtom atom1, MolAtom atom2) {
        if (this.equalsAtomMap(atom1, atom2)) {
            return null;
        }
        return this.diffAtomMap(atom1, atom2);
    }

    protected String compareAtomicNumber(MolAtom atom1, MolAtom atom2) {
        if (this.equalsAtomicNumber(atom1, atom2)) {
            return null;
        }
        return this.diffAtomicNumber(atom1, atom2);
    }

    protected String compareAliasString(MolAtom atom1, MolAtom atom2) {
        if (this.equalsAliasString(atom1, atom2)) {
            return null;
        }
        return this.diffAliasString(atom1, atom2);
    }

    protected String diffLabelCenter(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(SgroupAtomAttributes.SGROUP_LABEL_CENTER.getName(), DifferUtils.getLabelCenter(atom1), DifferUtils.getLabelCenter(atom2));
    }

    protected String diffRightName(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(SgroupAtomAttributes.SGROUP_ATOM_RIGHT_NAME.getName(), DifferUtils.getRightName(atom1), DifferUtils.getRightName(atom2));
    }

    protected String diffLeftName(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(SgroupAtomAttributes.SGROUP_ATOM_LEFT_NAME.getName(), DifferUtils.getLeftName(atom1), DifferUtils.getLeftName(atom2));
    }

    protected String diffBicycloStereoDescriptors(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.BICYCLO_STEREO_DESCRIPTOR.getName(), Arrays.toString(atom1.getBicycloStereo()), Arrays.toString(atom2.getBicycloStereo()));
    }

    protected String diffValenceProperty(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.VALENCE_PROPERTY.getName(), atom1.getValenceProp(), atom2.getValenceProp());
    }

    protected String diffStereoGroupType(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.STEREO_GROUP_TYPE.getName(), atom1.getStereoGroupType(), atom2.getStereoGroupType());
    }

    protected String diffStereoGroupNumber(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.STEREO_GROUP_NUMBER.getName(), atom1.getStereoGroupNumber(), atom2.getStereoGroupNumber());
    }

    protected String diffRgroupID(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RGROUP_ID.getName(), atom1.getRgroup(), atom2.getRgroup());
    }

    protected String diffRgroupAttachmentPointOrder(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RGROUP_ATTACHMENT_POINT_ORDER.getName(), atom1.getRgroupAttachmentPointOrder(), atom2.getRgroupAttachmentPointOrder());
    }

    protected String diffResidueType(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RESIDUE_TYPE.getName(), atom1.getResidueType(), atom2.getResidueType());
    }

    protected String diffResidueSequence(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RESIDUE_SEQUENCE.getName(), atom1.getResidueSeq(), atom2.getResidueSeq());
    }

    protected String diffResidueAtomId(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RESIDUE_ATOM_ID.getName(), atom1.getResidueAtomId(), atom2.getResidueAtomId());
    }

    protected String diffReactionStereo(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.REACTION_STEREO.getName(), atom1.getReactionStereo(), atom2.getReactionStereo());
    }

    protected String diffRadicalCount(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RADICAL_COUNT.getName(), atom1.getRadicalCount(), atom2.getRadicalCount());
    }

    protected String diffRadical(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.RADICAL.getName(), atom1.getRadical(), atom2.getRadical());
    }

    protected String diffQueryString(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.QUERY_STRING.getName(), atom1.getQueryString() == null ? "" : atom1.getQueryString(), atom2.getQueryString() == null ? "" : atom2.getQueryString());
    }

    protected String diffQueryProperties(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.QUERY_PROPERTIES.getName(), DifferUtils.getQueryPropertyList(atom1), DifferUtils.getQueryPropertyList(atom2));
    }

    protected String diffProperties(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.PROPERTIES.getName(), atom1.propertySet().toString(), atom2.propertySet().toString());
    }

    protected String diffParity(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.PARITY.getName(), atom1.getFlags() & 7, atom2.getFlags() & 7);
    }

    protected String diffNonQueryImplicitHCount(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.NON_QUERY_IMPLICIT_H_COUNT.getName(), atom1.getNonQueryImplicitHcount(), atom2.getNonQueryImplicitHcount());
    }

    protected String diffMaxRepetition(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.MAX_REPETITION.getName(), atom1.getMaxRepetitions(), atom2.getMaxRepetitions());
    }

    protected String diffMinRepetition(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.MIN_REPETITION.getName(), atom1.getMinRepetitions(), atom2.getMinRepetitions());
    }

    protected String diffMassNumber(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.MASS_NUMBER.getName(), atom1.getMassno(), atom2.getMassno());
    }

    protected String diffList(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.LIST.getName(), Arrays.toString(atom1.getList()), Arrays.toString(atom2.getList()));
    }

    protected String diffImplicitHCount(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.IMPLICIT_H_COUNT.getName(), atom1.getImplicitHcount(), atom2.getImplicitHcount());
    }

    protected String diffHybridizaitonState(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.HYBRIDIZATION_STATE.getName(), atom1.getHybridizationState(), atom2.getHybridizationState());
    }

    protected String diffExtraLabelSetSeq(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ELECTRON_PROPERTY.getName(), atom1.getElectronProp(), atom2.getElectronProp());
    }

    protected String diffExtraLabelColor(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.EXTRA_LABEL_COLOR.getName(), Long.toString(atom1.getExtraLabelColor()), Long.toString(atom2.getExtraLabelColor()));
    }

    protected String diffExtraLabel(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.EXTRA_LABEL.getName(), atom1.getExtraLabel(), atom2.getExtraLabel());
    }

    protected String diffElectronProperty(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ELECTRON_PROPERTY.getName(), atom1.getElectronProp(), atom2.getElectronProp());
    }

    protected String diffCoordinates(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.COORDINATES.getName(), atom1.getLocation().toString(), atom2.getLocation().toString());
    }

    protected String diffChiralilty(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.CHIRALITY.getName(), atom1.getFlags() & 0x18, atom2.getFlags() & 0x18);
    }

    protected String diffCharge(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.CHARGE.getName(), atom1.getCharge(), atom2.getCharge());
    }

    protected String diffAttachmentPoint(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ATTACHMENT_POINT.getName(), atom1.getAttach(), atom2.getAttach());
    }

    protected String diffAtomMap(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ATOM_MAP.getName(), atom1.getAtomMap(), atom2.getAtomMap());
    }

    protected String diffAtomStereo(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ATOMSTEREO.getName(), atom1.getFlags() & 0x60, atom2.getFlags() & 0x60);
    }

    protected String diffAtomicNumber(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ATOMIC_NUMBER.getName(), atom1.getAtno(), atom2.getAtno());
    }

    protected String diffAliasString(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.getAttributeDifferenceString(MolAtomAttributes.ALIAS_STRING.getName(), atom1.getAliasstr(), atom2.getAliasstr());
    }

    protected boolean equalsRadicalCount(MolAtom atom1, MolAtom atom2) {
        return atom1.getRadicalCount() == atom2.getRadicalCount();
    }

    protected boolean equalsLabelCenter(MolAtom atom1, MolAtom atom2) {
        if (atom1.getAtno() == 135 && atom2.getAtno() == 135) {
            return ((SgroupAtom)atom1).getLabelCenter() == ((SgroupAtom)atom2).getLabelCenter();
        }
        return atom1.getAtno() != 135 && atom2.getAtno() != 135;
    }

    protected boolean equalsRightName(MolAtom atom1, MolAtom atom2) {
        if (atom1.getAtno() == 135 && atom2.getAtno() == 135) {
            return this.equalsName(((SgroupAtom)atom1).getRightName(), ((SgroupAtom)atom2).getRightName());
        }
        return atom1.getAtno() != 135 && atom2.getAtno() != 135;
    }

    private boolean equalsName(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return true;
        }
        if (name1 != null && name2 != null) {
            return name1.equals(name2);
        }
        return false;
    }

    protected boolean equalsLeftName(MolAtom atom1, MolAtom atom2) {
        if (atom1.getAtno() == 135 && atom2.getAtno() == 135) {
            return this.equalsName(((SgroupAtom)atom1).getLeftName(), ((SgroupAtom)atom2).getLeftName());
        }
        return atom1.getAtno() != 135 && atom2.getAtno() != 135;
    }

    protected boolean equalsBicycloStereoDescriptors(MolAtom atom1, MolAtom atom2) {
        BicycloStereoDescriptor[] descriptors1 = atom1.getBicycloStereo();
        BicycloStereoDescriptor[] descriptors2 = atom2.getBicycloStereo();
        if (descriptors1 == null && descriptors2 == null) {
            return true;
        }
        return descriptors1 != null && descriptors2 != null && descriptors1.length == descriptors2.length && this.contains(descriptors1, descriptors2) && this.contains(descriptors2, descriptors1);
    }

    private boolean contains(BicycloStereoDescriptor[] descriptors1, BicycloStereoDescriptor[] descriptors2) {
        for (BicycloStereoDescriptor descriptor : descriptors1) {
            if (this.contains(descriptor, descriptors2)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(BicycloStereoDescriptor descriptor, BicycloStereoDescriptor[] descriptors) {
        for (BicycloStereoDescriptor desc : descriptors) {
            if (!desc.compareTo(descriptor)) continue;
            return true;
        }
        return false;
    }

    protected boolean equalsImplicitHCount(MolAtom atom1, MolAtom atom2) {
        return atom1.getImplicitHcount() == atom2.getImplicitHcount();
    }

    protected boolean equalsValenceProperty(MolAtom atom1, MolAtom atom2) {
        return atom1.getValenceProp() == atom2.getValenceProp();
    }

    protected boolean equalsStereoGroupType(MolAtom atom1, MolAtom atom2) {
        return atom1.getStereoGroupType() == atom2.getStereoGroupType();
    }

    protected boolean equalsStereoGroupNumber(MolAtom atom1, MolAtom atom2) {
        return atom1.getStereoGroupNumber() == atom2.getStereoGroupNumber();
    }

    protected boolean equalsRgroupID(MolAtom atom1, MolAtom atom2) {
        return atom1.getRgroup() == atom2.getRgroup();
    }

    protected boolean equalsRgroupAttachmentPointOrder(MolAtom atom1, MolAtom atom2) {
        return atom1.getRgroupAttachmentPointOrder() == atom2.getRgroupAttachmentPointOrder();
    }

    protected boolean equalsResidueType(MolAtom atom1, MolAtom atom2) {
        return atom1.getResidueType() == atom2.getResidueType();
    }

    protected boolean equalsResidueSequence(MolAtom atom1, MolAtom atom2) {
        return atom1.getResidueSeq() == atom2.getResidueSeq();
    }

    protected boolean equalsResidueAtomId(MolAtom atom1, MolAtom atom2) {
        return atom1.getResidueAtomId() == atom2.getResidueAtomId();
    }

    protected boolean equalsReactionStereo(MolAtom atom1, MolAtom atom2) {
        return atom1.getReactionStereo() == atom2.getReactionStereo();
    }

    protected boolean equalsRadical(MolAtom atom1, MolAtom atom2) {
        return atom1.getRadical() == atom2.getRadical();
    }

    protected boolean equalsQueryString(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.equalsStrings(atom1.getQueryString(), atom2.getQueryString());
    }

    protected boolean equalsQueryProperties(MolAtom atom1, MolAtom atom2) {
        Set<String> names1 = atom1.getQPropNameSet();
        Set<String> names2 = atom2.getQPropNameSet();
        if (names1 == null && names2 == null) {
            return true;
        }
        if (names1 == null || names2 == null) {
            return false;
        }
        if (names1.size() == names2.size()) {
            return this.equalsQuerySet(atom1, atom2, names1, names2);
        }
        return false;
    }

    private boolean equalsQuerySet(MolAtom atom1, MolAtom atom2, Set<String> names1, Set<String> names2) {
        for (String name : names1) {
            if (!names2.contains(name)) {
                return false;
            }
            if (atom1.getQProp(name).equals(atom2.getQProp(name))) continue;
            return false;
        }
        return true;
    }

    protected boolean equalsProperties(MolAtom atom1, MolAtom atom2) {
        Set<Map.Entry<String, Object>> properties1 = atom1.propertySet();
        Set<Map.Entry<String, Object>> properties2 = atom2.propertySet();
        return ((Object)properties1).equals(properties2);
    }

    protected boolean equalsParity(MolAtom atom1, MolAtom atom2) {
        return (atom1.getFlags() & 7) == (atom2.getFlags() & 7);
    }

    protected boolean equalsNonQueryImplicitHCount(MolAtom atom1, MolAtom atom2) {
        return atom1.getNonQueryImplicitHcount() == atom2.getNonQueryImplicitHcount();
    }

    protected boolean equalsMaxRepetition(MolAtom atom1, MolAtom atom2) {
        return atom1.getMaxRepetitions() == atom2.getMaxRepetitions();
    }

    protected boolean equalsMinRepetition(MolAtom atom1, MolAtom atom2) {
        return atom1.getMinRepetitions() == atom2.getMinRepetitions();
    }

    protected boolean equalsMassNumber(MolAtom atom1, MolAtom atom2) {
        return atom1.getMassno() == atom2.getMassno();
    }

    protected boolean equalsList(MolAtom atom1, MolAtom atom2) {
        if (atom1.getList() != null && atom2.getList() != null) {
            return ArrayTools.equalsArrays(atom1.getList(), atom2.getList());
        }
        return atom1.getList() == null && atom2.getList() == null;
    }

    protected boolean equalsHybridizationState(MolAtom atom1, MolAtom atom2) {
        return atom1.getHybridizationState() == atom2.getHybridizationState();
    }

    protected boolean equalsExtraLabelSetSeq(MolAtom atom1, MolAtom atom2) {
        return atom1.getExtraLabelSetSeq() == atom2.getExtraLabelSetSeq();
    }

    protected boolean equalsExtraLabelColor(MolAtom atom1, MolAtom atom2) {
        return atom1.getExtraLabelColor() == atom2.getExtraLabelColor();
    }

    protected boolean equalsExtraLabel(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.equalsStrings(atom1.getExtraLabel(), atom2.getExtraLabel());
    }

    protected boolean equalsElectronProperty(MolAtom atom1, MolAtom atom2) {
        return atom1.getElectronProp() == atom2.getElectronProp();
    }

    protected boolean equalsCoordinates(MolAtom atom1, MolAtom atom2) {
        if (this.coordinateThreshold == 0.0) {
            return atom1.getX() == atom2.getX() && atom1.getY() == atom2.getY() && atom1.getZ() == atom2.getZ();
        }
        return Math.abs(atom1.getX() - atom2.getX()) <= this.coordinateThreshold + 1.0E-5 && Math.abs(atom1.getY() - atom2.getY()) <= this.coordinateThreshold + 1.0E-5 && Math.abs(atom1.getZ() - atom2.getZ()) <= this.coordinateThreshold + 1.0E-5;
    }

    protected boolean equalsChirality(MolAtom atom1, MolAtom atom2) {
        return (atom1.getFlags() & 0x18) == (atom2.getFlags() & 0x18);
    }

    protected boolean equalsCharge(MolAtom atom1, MolAtom atom2) {
        return atom1.getCharge() == atom2.getCharge();
    }

    protected boolean equalsAttachmentPoint(MolAtom atom1, MolAtom atom2) {
        return atom1.getAttach() == atom2.getAttach();
    }

    protected boolean equalsAtomStereo(MolAtom atom1, MolAtom atom2) {
        return (atom1.getFlags() & 0x60) == (atom2.getFlags() & 0x60);
    }

    protected boolean equalsAtomMap(MolAtom atom1, MolAtom atom2) {
        return atom1.getAtomMap() == atom2.getAtomMap();
    }

    protected boolean equalsAtomicNumber(MolAtom atom1, MolAtom atom2) {
        return atom1.getAtno() == atom2.getAtno();
    }

    protected boolean equalsAliasString(MolAtom atom1, MolAtom atom2) {
        return DifferUtils.equalsStrings(atom1.getAliasstr(), atom2.getAliasstr());
    }

    public static enum SgroupAtomAttributes {
        SGROUP_ATOM_LEFT_NAME("sgroup atom left name"),
        SGROUP_ATOM_RIGHT_NAME("sgroup atom right name"),
        SGROUP_LABEL_CENTER("sgroup atom label center");

        private final String name;

        private SgroupAtomAttributes(String attributeName) {
            this.name = attributeName;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum MolAtomAttributes {
        ALIAS_STRING("alias string"),
        ATOMIC_NUMBER("atomic number"),
        ATOMSTEREO("atom stereo"),
        ATOM_MAP("atom map"),
        ATTACHMENT_POINT("attachment point"),
        BICYCLO_STEREO_DESCRIPTOR("bicyclo stereo descriptor"),
        CHARGE("charge"),
        CHIRALITY("chirality  (R/S, 2 bits)"),
        COORDINATES("coordinates"),
        ELECTRON_PROPERTY("electron property"),
        EXTRA_LABEL("extra label"),
        EXTRA_LABEL_COLOR("extra label"),
        EXTRA_LABEL_SET_SEQ("extra label set sequence"),
        HYBRIDIZATION_STATE("hybridization state"),
        IMPLICIT_H_COUNT("implicit hydrogen count"),
        LIST("atom list"),
        MASS_NUMBER("mass number"),
        MAX_REPETITION("maximal repetition"),
        MIN_REPETITION("minimal repetition"),
        NON_QUERY_IMPLICIT_H_COUNT("non query implicit hydrogen count"),
        PARITY("stereo parity information"),
        PROPERTIES("properties"),
        QUERY_PROPERTIES("query property"),
        QUERY_STRING("query string"),
        RADICAL("radical value"),
        RADICAL_COUNT("radical count"),
        REACTION_STEREO("stereo group number information"),
        RESIDUE_ATOM_ID("reisdue atom identifier"),
        RESIDUE_SEQUENCE("residue sequence"),
        RESIDUE_TYPE("residue type"),
        RGROUP_ATTACHMENT_POINT_ORDER("rgroup attachment point order"),
        RGROUP_ID("rgroup identifier"),
        STEREO_GROUP_NUMBER("stereo group number information"),
        STEREO_GROUP_TYPE("stereo group type information"),
        VALENCE_PROPERTY("valence property");

        private final String name;

        private MolAtomAttributes(String attributeName) {
            this.name = attributeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

