/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BondDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.MolBond;
import chemaxon.struc.QueryBond;

public class DefaultBondDiffer
implements BondDiffer {
    private boolean ignoreDynamicType = false;
    private boolean ignoreStereoQueryProperties = false;
    private boolean ignoreTopologyProperties = false;
    private boolean ignoreReactingCenterProperties = false;
    private boolean ignoreBoldProperty = false;
    private boolean ignoreHashedProperty = false;
    private boolean ignoreQueryStringProperties = false;
    private boolean ignoreStereo2Properties = false;
    private boolean ignoreStereo1Properties = false;
    private boolean ignoreType = false;

    @Override
    public String diff(MolBond bond1, MolBond bond2) {
        String difference;
        if (bond1 == null && bond2 == null) {
            return null;
        }
        if (bond1 == null || bond2 == null) {
            return bond1 == null ? DifferUtils.getAttributeDifferenceString("bond", "null", "not null") : DifferUtils.getAttributeDifferenceString("bond", "not null", "null");
        }
        if (!this.ignoreType && (difference = this.compareType(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreStereo1Properties && (difference = this.compareStereo1(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreStereo2Properties && (difference = this.compareStereo2(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreStereoQueryProperties && (difference = this.compareStereoQueryProperties(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreTopologyProperties && (difference = this.compareTopologyProperties(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreReactingCenterProperties && (difference = this.compareReactingCenterProperties(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreHashedProperty && (difference = this.compareHashedProperty(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreBoldProperty && (difference = this.compareBoldProperty(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreQueryStringProperties && (difference = this.compareQueryString(bond1, bond2)) != null) {
            return difference;
        }
        if (!this.ignoreDynamicType && (difference = this.compareDynamicType(bond1, bond2)) != null) {
            return difference;
        }
        return null;
    }

    @Override
    public boolean equals(MolBond bond1, MolBond bond2) {
        return this.diff(bond1, bond2) == null;
    }

    protected String compareDynamicType(MolBond bond1, MolBond bond2) {
        if (bond1 instanceof QueryBond && !(bond2 instanceof QueryBond) || !(bond1 instanceof QueryBond) && bond2 instanceof QueryBond) {
            return DifferUtils.getAttributeDifferenceString("bond dynamic type", bond1.getClass().getName(), bond2.getClass().getName());
        }
        return null;
    }

    public void ignoreDynamicType(boolean ignore) {
        this.ignoreDynamicType = ignore;
    }

    protected String compareStereoQueryProperties(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & 0x100) != (bond2.getFlags() & 0x100)) {
            return DifferUtils.getAttributeDifferenceString("bond stereo query property", bond1.getFlags() & 0x100, bond2.getFlags() & 0x100);
        }
        if ((bond1.getFlags() & 0x200) != (bond2.getFlags() & 0x200)) {
            return DifferUtils.getAttributeDifferenceString("bond stereo query property", bond1.getFlags() & 0x200, bond2.getFlags() & 0x200);
        }
        return null;
    }

    public void ignoreStereoQueryProperties(boolean ignore) {
        this.ignoreStereoQueryProperties = ignore;
    }

    protected String compareTopologyProperties(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & 0xC00) != (bond2.getFlags() & 0xC00)) {
            return DifferUtils.getAttributeDifferenceString("bond topology property", bond1.getFlags() & 0xC00, bond2.getFlags() & 0xC00);
        }
        return null;
    }

    public void ignoreTopologyProperties(boolean ignore) {
        this.ignoreTopologyProperties = ignore;
    }

    protected String compareReactingCenterProperties(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & 0xF000) != (bond2.getFlags() & 0xF000)) {
            return DifferUtils.getAttributeDifferenceString("bond reacting center property", bond1.getFlags() & 0xF000, bond2.getFlags() & 0xF000);
        }
        return null;
    }

    public void ignoreReactingCenterProperties(boolean ignore) {
        this.ignoreReactingCenterProperties = ignore;
    }

    protected String compareBoldProperty(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & 0x40000000) != (bond2.getFlags() & 0x40000000)) {
            return DifferUtils.getAttributeDifferenceString("bond bold property", bond1.getFlags() & 0x40000000, bond2.getFlags() & 0x40000000);
        }
        return null;
    }

    public void ignoreBoldProperty(boolean ignore) {
        this.ignoreBoldProperty = ignore;
    }

    protected String compareHashedProperty(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & Integer.MIN_VALUE) != (bond2.getFlags() & Integer.MIN_VALUE)) {
            return DifferUtils.getAttributeDifferenceString("bond hashed property", bond1.getFlags() & Integer.MIN_VALUE, bond2.getFlags() & Integer.MIN_VALUE);
        }
        return null;
    }

    public void ignoreHashedProperty(boolean ignore) {
        this.ignoreHashedProperty = ignore;
    }

    protected String compareQueryString(MolBond bond1, MolBond bond2) {
        if (bond1.getQuerystr() == null && bond2.getQuerystr() == null) {
            return null;
        }
        if (bond1.getQuerystr() == null || bond2.getQuerystr() == null) {
            return DifferUtils.getAttributeDifferenceString("bond query string", bond1.getQuerystr(), bond2.getQuerystr());
        }
        if (!bond1.getQuerystr().equals(bond2.getQuerystr())) {
            return DifferUtils.getAttributeDifferenceString("bond query string", bond1.getQuerystr(), bond2.getQuerystr());
        }
        return null;
    }

    public void ignoreQueryStringProperties(boolean ignore) {
        this.ignoreQueryStringProperties = ignore;
    }

    protected String compareStereo2(MolBond bond1, MolBond bond2) {
        if (bond1.getType() == 2 || bond1.getType() == 4 || bond1.getType() == 7) {
            if ((bond1.getFlags() & 0xC0) != (bond2.getFlags() & 0xC0)) {
                return DifferUtils.getAttributeDifferenceString("bond CIS|TRANS flags", bond1.getFlags() & 0xC0, bond2.getFlags() & 0xC0);
            }
            if (bond1.calcStereo2() != bond2.calcStereo2()) {
                return DifferUtils.getAttributeDifferenceString("bond calculated CIS|TRANS information", bond1.calcStereo2(), bond2.calcStereo2());
            }
        }
        return null;
    }

    public void ignoreStereo2Properties(boolean ignore) {
        this.ignoreStereo2Properties = ignore;
    }

    protected String compareStereo1(MolBond bond1, MolBond bond2) {
        if ((bond1.getFlags() & 0x30) != (bond2.getFlags() & 0x30)) {
            return DifferUtils.getAttributeDifferenceString("bond UP|DOWN information", bond1.getFlags() & 0x30, bond2.getFlags() & 0x30);
        }
        return null;
    }

    public void ignoreStereo1Properties(boolean ignore) {
        this.ignoreStereo1Properties = ignore;
    }

    protected String compareType(MolBond bond1, MolBond bond2) {
        if (bond1.getType() != bond2.getType()) {
            return DifferUtils.getAttributeDifferenceString("bond type", bond1.getType(), bond2.getType());
        }
        return null;
    }

    public void ignoreType(boolean ignore) {
        this.ignoreType = ignore;
    }
}

