/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.DataSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.MulticenterSgroupDiffer;
import chemaxon.core.util.differ.MultipleSgroupDiffer;
import chemaxon.core.util.differ.RepeatingUnitSgroupDiffer;
import chemaxon.core.util.differ.SgroupDiffer;
import chemaxon.core.util.differ.SuperatomSgroupDiffer;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;

public class DefaultSgroupDiffer
implements SgroupDiffer {
    protected BasicSgroupDiffer basicDiffer = new BasicSgroupDiffer();
    protected MulticenterSgroupDiffer multicenterDiffer = new MulticenterSgroupDiffer();
    protected SuperatomSgroupDiffer superatomDiffer = new SuperatomSgroupDiffer();
    protected MultipleSgroupDiffer multipleDiffer = new MultipleSgroupDiffer();
    protected RepeatingUnitSgroupDiffer repeatingUnitDiffer;
    protected DataSgroupDiffer dataDiffer = new DataSgroupDiffer();
    private boolean ignoreDynamicType = false;

    public DefaultSgroupDiffer() {
        this.repeatingUnitDiffer = new RepeatingUnitSgroupDiffer();
    }

    @Override
    public String diff(Sgroup sgroup1, Sgroup sgroup2) {
        String difference;
        if (sgroup1 == null && sgroup2 == null) {
            return null;
        }
        if (sgroup1 == null) {
            return DifferUtils.getAttributeDifferenceString("S-group", "null", "not null");
        }
        if (sgroup2 == null) {
            return DifferUtils.getAttributeDifferenceString("S-group", "not null", "null");
        }
        if (!this.ignoreDynamicType && (difference = this.compareDynamicType(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreDynamicType) {
            if (sgroup1 instanceof MulticenterSgroup) {
                return this.multicenterDiffer.compareAttributes((MulticenterSgroup)sgroup1, (MulticenterSgroup)sgroup2);
            }
            if (sgroup1 instanceof SuperatomSgroup) {
                return this.superatomDiffer.compareAttributes((SuperatomSgroup)sgroup1, (SuperatomSgroup)sgroup2);
            }
            if (sgroup1 instanceof MultipleSgroup) {
                return this.multipleDiffer.compareAttributes((MultipleSgroup)sgroup1, (MultipleSgroup)sgroup2);
            }
            if (sgroup1 instanceof RepeatingUnitSgroup) {
                return this.repeatingUnitDiffer.compareAttributes((RepeatingUnitSgroup)sgroup1, (RepeatingUnitSgroup)sgroup2);
            }
            if (sgroup1 instanceof DataSgroup) {
                return this.dataDiffer.compareAttributes((DataSgroup)sgroup1, (DataSgroup)sgroup2);
            }
        }
        return this.basicDiffer.compareAttributes(sgroup1, sgroup2);
    }

    @Override
    public boolean equals(Sgroup sgroup1, Sgroup sgroup2) {
        return this.diff(sgroup1, sgroup2) == null;
    }

    protected String compareDynamicType(Sgroup sgroup1, Sgroup sgroup2) {
        if (sgroup1.getClass() != sgroup2.getClass()) {
            return DifferUtils.getAttributeDifferenceString("S-group dynamic type", sgroup1.getClass().getName(), sgroup2.getClass().getName());
        }
        return null;
    }

    public void ignoreDynamicType(boolean ignoreState) {
        this.ignoreDynamicType = ignoreState;
    }

    public void ignoreType(boolean ignoreState) {
        this.basicDiffer.ignoreType(ignoreState);
        this.multicenterDiffer.ignoreType(ignoreState);
        this.superatomDiffer.ignoreType(ignoreState);
        this.multipleDiffer.ignoreType(ignoreState);
        this.repeatingUnitDiffer.ignoreType(ignoreState);
        this.dataDiffer.ignoreType(ignoreState);
    }

    public void ignoreSubtype(boolean ignoreState) {
        this.basicDiffer.ignoreSubtype(ignoreState);
        this.multicenterDiffer.ignoreSubtype(ignoreState);
        this.superatomDiffer.ignoreSubtype(ignoreState);
        this.multipleDiffer.ignoreSubtype(ignoreState);
        this.repeatingUnitDiffer.ignoreSubtype(ignoreState);
        this.dataDiffer.ignoreSubtype(ignoreState);
    }

    public void ignoreSubscript(boolean ignoreState) {
        this.basicDiffer.ignoreSubscript(ignoreState);
        this.multicenterDiffer.ignoreSubscript(ignoreState);
        this.superatomDiffer.ignoreSubscript(ignoreState);
        this.multipleDiffer.ignoreSubscript(ignoreState);
        this.repeatingUnitDiffer.ignoreSubscript(ignoreState);
        this.dataDiffer.ignoreSubscript(ignoreState);
    }

    public void ignoreConnectivity(boolean ignoreState) {
        this.basicDiffer.ignoreConnectivity(ignoreState);
        this.multicenterDiffer.ignoreConnectivity(ignoreState);
        this.superatomDiffer.ignoreConnectivity(ignoreState);
        this.multipleDiffer.ignoreConnectivity(ignoreState);
        this.repeatingUnitDiffer.ignoreConnectivity(ignoreState);
        this.dataDiffer.ignoreConnectivity(ignoreState);
    }

    public void ignoreChargeLocation(boolean ignoreState) {
        this.basicDiffer.ignoreChargeLocation(ignoreState);
        this.multicenterDiffer.ignoreChargeLocation(ignoreState);
        this.superatomDiffer.ignoreChargeLocation(ignoreState);
        this.multipleDiffer.ignoreChargeLocation(ignoreState);
        this.repeatingUnitDiffer.ignoreChargeLocation(ignoreState);
        this.dataDiffer.ignoreChargeLocation(ignoreState);
    }

    public void ignoreBrackets(boolean ignoreState) {
        this.basicDiffer.ignoreBrackets(ignoreState);
        this.multicenterDiffer.ignoreBrackets(ignoreState);
        this.superatomDiffer.ignoreBrackets(ignoreState);
        this.multipleDiffer.ignoreBrackets(ignoreState);
        this.repeatingUnitDiffer.ignoreBrackets(ignoreState);
        this.dataDiffer.ignoreBrackets(ignoreState);
    }

    public void ignoreParentSgroup(boolean ignoreState) {
        this.basicDiffer.ignoreParentSgroup(ignoreState);
        this.multicenterDiffer.ignoreParentSgroup(ignoreState);
        this.superatomDiffer.ignoreParentSgroup(ignoreState);
        this.multipleDiffer.ignoreParentSgroup(ignoreState);
        this.repeatingUnitDiffer.ignoreParentSgroup(ignoreState);
        this.dataDiffer.ignoreParentSgroup(ignoreState);
    }

    public void ignoreChildrenSgroups(boolean ignoreState) {
        this.basicDiffer.ignoreChildrenSgroups(ignoreState);
        this.multicenterDiffer.ignoreChildrenSgroups(ignoreState);
        this.superatomDiffer.ignoreChildrenSgroups(ignoreState);
        this.multipleDiffer.ignoreChildrenSgroups(ignoreState);
        this.repeatingUnitDiffer.ignoreChildrenSgroups(ignoreState);
        this.dataDiffer.ignoreChildrenSgroups(ignoreState);
    }

    public BasicSgroupDiffer getBasicSgroupDiffer() {
        return this.basicDiffer;
    }

    public MulticenterSgroupDiffer getMulticenterSgroupDiffer() {
        return this.multicenterDiffer;
    }

    public SuperatomSgroupDiffer getSuperatomSgroupDiffer() {
        return this.superatomDiffer;
    }

    public MultipleSgroupDiffer getMultipleSgroupDiffer() {
        return this.multipleDiffer;
    }

    public DataSgroupDiffer getDataSgroupDiffer() {
        return this.dataDiffer;
    }

    public RepeatingUnitSgroupDiffer getRepeatingUnitSgroupDiffer() {
        return this.repeatingUnitDiffer;
    }

    public void setBasicSgroupDiffer(BasicSgroupDiffer differ) {
        this.basicDiffer = differ;
    }

    public void setMulticenterSgroupDiffer(MulticenterSgroupDiffer differ) {
        this.multicenterDiffer = differ;
    }

    public void setSuperatomSgroupDiffer(SuperatomSgroupDiffer differ) {
        this.superatomDiffer = differ;
    }

    public void setMultipleSgroupDiffer(MultipleSgroupDiffer differ) {
        this.multipleDiffer = differ;
    }

    public void setDataSgroupDiffer(DataSgroupDiffer differ) {
        this.dataDiffer = differ;
    }

    public void setRepeatingUnitSgroupDiffer(RepeatingUnitSgroupDiffer differ) {
        this.repeatingUnitDiffer = differ;
    }
}

