/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.MObjectDifferFactory;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MFont;

class MDocumentDiffer {
    private boolean ignoreAtomSetColorMode = false;
    private boolean ignoreAtomSetColors = false;
    private boolean ignoreAtomSetFonts = false;
    private boolean ignoreBondSetColorMode = false;
    private boolean ignoreBondSetColors = false;
    private boolean ignoreBondSetThickness = false;

    MDocumentDiffer() {
    }

    String diff(MDocument mdoc1, MDocument mdoc2) {
        String result;
        int i;
        if (mdoc1 == null && mdoc2 == null) {
            return null;
        }
        if (mdoc1 == null || mdoc2 == null) {
            return mdoc1 == null ? DifferUtils.getAttributeDifferenceString("document", "null", "not null") : DifferUtils.getAttributeDifferenceString("document", "not null", "null");
        }
        MoleculeGraph mg1 = mdoc1.getMainMoleculeGraph();
        MoleculeGraph mg2 = mdoc2.getMainMoleculeGraph();
        for (i = 0; i < mg1.getAtomCount(); ++i) {
            if (!this.ignoreAtomSetColorMode && (result = this.compareAtomSetColorMode(mdoc1, mdoc2, mg1.getAtom(i), mg2.getAtom(i))) != null) {
                return result;
            }
            if (!this.ignoreAtomSetColors && (result = this.compareAtomSetColors(mdoc1, mdoc2, mg1.getAtom(i), mg2.getAtom(i))) != null) {
                return result;
            }
            if (this.ignoreAtomSetFonts || (result = this.compareAtomSetFonts(mdoc1, mdoc2, mg1.getAtom(i), mg2.getAtom(i))) == null) continue;
            return result;
        }
        for (i = 0; i < mg1.getBondCount(); ++i) {
            if (!this.ignoreBondSetColorMode && (result = this.compareBondSetColorMode(mdoc1, mdoc2, mg1.getBond(i), mg2.getBond(i))) != null) {
                return result;
            }
            if (!this.ignoreBondSetColors && (result = this.compareBondSetColors(mdoc1, mdoc2, mg1.getBond(i), mg2.getBond(i))) != null) {
                return result;
            }
            if (this.ignoreBondSetThickness || (result = this.compareBondSetThickness(mdoc1, mdoc2, mg1.getBond(i), mg2.getBond(i))) == null) continue;
            return result;
        }
        if (mdoc1.getObjectCount() != mdoc2.getObjectCount()) {
            DifferUtils.getAttributeDifferenceString("number of MObjects", mdoc1.getObjectCount(), mdoc2.getObjectCount());
        }
        for (i = 0; i < mdoc1.getObjectCount(); ++i) {
            String diff = new MObjectDifferFactory().diff(mdoc1.getObject(i), mdoc2.getObject(i));
            if (diff == null) continue;
            return diff;
        }
        return null;
    }

    boolean equals(MDocument mdoc1, MDocument mdoc2) {
        return this.diff(mdoc1, mdoc2) == null;
    }

    private String compareAtomSetFonts(MDocument mdoc1, MDocument mdoc2, MolAtom atom1, MolAtom atom2) {
        MFont fontOfAtom1 = mdoc1.getAtomSetFont(atom1.getSetSeq());
        MFont fontOfAtom2 = mdoc2.getAtomSetFont(atom2.getSetSeq());
        if (fontOfAtom1 == null && fontOfAtom2 == null) {
            return null;
        }
        if (fontOfAtom1 == null || fontOfAtom2 == null) {
            return DifferUtils.getAttributeDifferenceString("document atomSetFonts", fontOfAtom1, fontOfAtom2);
        }
        if (!fontOfAtom1.equals(fontOfAtom2)) {
            return DifferUtils.getAttributeDifferenceString("document atomSetFonts", fontOfAtom1, fontOfAtom2);
        }
        return null;
    }

    void ignoreAtomSetFonts(boolean ignore) {
        this.ignoreAtomSetFonts = ignore;
    }

    private String compareAtomSetColors(MDocument mdoc1, MDocument mdoc2, MolAtom atom1, MolAtom atom2) {
        if ((mdoc1.getAtomSetRGB(atom1.getSetSeq()) & 0xFFFFFF) != (mdoc2.getAtomSetRGB(atom2.getSetSeq()) & 0xFFFFFF)) {
            return DifferUtils.getAttributeDifferenceString("document atomSetColor", mdoc1.getAtomSetRGB(atom1.getSetSeq()), mdoc2.getAtomSetRGB(atom2.getSetSeq()));
        }
        return null;
    }

    void ignoreAtomSetColors(boolean ignore) {
        this.ignoreAtomSetColors = ignore;
    }

    protected String compareAtomSetColorMode(MDocument mdoc1, MDocument mdoc2, MolAtom atom1, MolAtom atom2) {
        if (mdoc1.getAtomSetColorMode(atom1.getSetSeq()) != mdoc2.getAtomSetColorMode(atom2.getSetSeq())) {
            return DifferUtils.getAttributeDifferenceString("document atomSetColorMode", mdoc1.getAtomSetColorMode(atom1.getSetSeq()), mdoc2.getAtomSetColorMode(atom2.getSetSeq()));
        }
        return null;
    }

    void ignoreAtomSetColorMode(boolean ignore) {
        this.ignoreAtomSetColorMode = ignore;
    }

    protected String compareBondSetColorMode(MDocument mdoc1, MDocument mdoc2, MolBond bond1, MolBond bond2) {
        if (mdoc1.getBondSetColorMode(bond1.getSetSeq()) != mdoc2.getBondSetColorMode(bond2.getSetSeq())) {
            return DifferUtils.getAttributeDifferenceString("document bondSetColorMode", mdoc1.getBondSetColorMode(bond1.getSetSeq()), mdoc2.getBondSetColorMode(bond2.getSetSeq()));
        }
        return null;
    }

    void ignoreBondSetColorMode(boolean ignore) {
        this.ignoreBondSetColorMode = ignore;
    }

    private String compareBondSetColors(MDocument mdoc1, MDocument mdoc2, MolBond bond1, MolBond bond2) {
        if ((mdoc1.getBondSetRGB(bond1.getSetSeq()) & 0xFFFFFF) != (mdoc2.getBondSetRGB(bond2.getSetSeq()) & 0xFFFFFF)) {
            return DifferUtils.getAttributeDifferenceString("document bondSetColor", mdoc1.getBondSetRGB(bond1.getSetSeq()), mdoc2.getBondSetRGB(bond2.getSetSeq()));
        }
        return null;
    }

    void ignoreBondSetColors(boolean ignore) {
        this.ignoreBondSetColors = ignore;
    }

    private String compareBondSetThickness(MDocument mdoc1, MDocument mdoc2, MolBond bond1, MolBond bond2) {
        if (mdoc1.getBondSetThickness(bond1.getSetSeq()) != mdoc2.getBondSetThickness(bond2.getSetSeq())) {
            return DifferUtils.getAttributeDifferenceString("document bondSetThickness", mdoc1.getBondSetThickness(bond1.getSetSeq()), mdoc2.getBondSetThickness(bond2.getSetSeq()));
        }
        return null;
    }

    void ignoreBondSetThickness(boolean ignore) {
        this.ignoreBondSetThickness = ignore;
    }
}

