/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.SgroupAtomBondDiffer;
import chemaxon.struc.sgroup.MulticenterSgroup;

public class MulticenterSgroupDiffer
extends BasicSgroupDiffer {
    private boolean ignoreCentralAtom = false;

    protected String compareCentralAtom(MulticenterSgroup sgroup1, MulticenterSgroup sgroup2) {
        if (sgroup1.getCentralAtom() == null && sgroup2.getCentralAtom() == null) {
            return null;
        }
        return SgroupAtomBondDiffer.compareAtoms(sgroup1.getCentralAtom(), sgroup2.getCentralAtom(), "multicenter S-group central atom");
    }

    String compareAttributes(MulticenterSgroup sgroup1, MulticenterSgroup sgroup2) {
        String difference = super.compareAttributes(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        if (!this.ignoreCentralAtom && (difference = this.compareCentralAtom(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }

    public void ignoreCentralAtom(boolean ignoreState) {
        this.ignoreCentralAtom = ignoreState;
    }
}

