/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.SgroupAtomBondDiffer;
import chemaxon.struc.sgroup.MultipleSgroup;

public class MultipleSgroupDiffer
extends BasicSgroupDiffer {
    private boolean ignoreMultiplier = false;
    private boolean ignoreRepeatingUnitAtoms = false;

    protected String compareMultiplier(MultipleSgroup sgroup1, MultipleSgroup sgroup2) {
        if (sgroup1.getMultiplier() != sgroup2.getMultiplier()) {
            return DifferUtils.getAttributeDifferenceString("multiple S-group multiplier", sgroup1.getMultiplier(), sgroup2.getMultiplier());
        }
        return null;
    }

    public void ignoreMultiplier(boolean ignoreState) {
        this.ignoreMultiplier = ignoreState;
    }

    protected String compareExpansionState(MultipleSgroup sgroup1, MultipleSgroup sgroup2) {
        if (sgroup1.isExpanded() != sgroup2.isExpanded()) {
            return DifferUtils.getAttributeDifferenceString("multiple S-group expansion state", sgroup1.isExpanded(), sgroup2.isExpanded());
        }
        return null;
    }

    protected String compareRepeatingUnitAtoms(MultipleSgroup sgroup1, MultipleSgroup sgroup2) {
        return SgroupAtomBondDiffer.compareAtomArrays(sgroup1.getRepeatingUnitAtoms(), sgroup2.getRepeatingUnitAtoms(), "multiple S-group repeating unit atoms");
    }

    public void ignoreRepeatingUnitAtoms(boolean ignoreState) {
        this.ignoreRepeatingUnitAtoms = ignoreState;
    }

    String compareAttributes(MultipleSgroup sgroup1, MultipleSgroup sgroup2) {
        String difference = this.compareExpansionState(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        difference = super.compareAttributes(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        if (!this.ignoreMultiplier && (difference = this.compareMultiplier(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreRepeatingUnitAtoms && (difference = this.compareRepeatingUnitAtoms(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }
}

