/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.SgroupAtomBondDiffer;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;

public class RepeatingUnitSgroupDiffer
extends BasicSgroupDiffer {
    private boolean ignoreFlipped = false;
    private boolean ignoreHeadCrossingBonds = false;
    private boolean ignoreTailCrossingBonds = false;

    protected String compareFlipped(RepeatingUnitSgroup sgroup1, RepeatingUnitSgroup sgroup2) {
        if (sgroup1.isFlipped() != sgroup2.isFlipped()) {
            return DifferUtils.getAttributeDifferenceString("data S-group flipped", sgroup1.isFlipped(), sgroup2.isFlipped());
        }
        return null;
    }

    public void ignoreFlipped(boolean ignoreState) {
        this.ignoreFlipped = ignoreState;
    }

    protected String compareHeadCrossingBonds(RepeatingUnitSgroup sgroup1, RepeatingUnitSgroup sgroup2) {
        return SgroupAtomBondDiffer.compareBondArrays(sgroup1.getHeadCrossingBonds(), sgroup2.getHeadCrossingBonds(), "repeating unit S-group head crossing bonds");
    }

    public void ignoreHeadCrossingBonds(boolean ignoreState) {
        this.ignoreHeadCrossingBonds = ignoreState;
    }

    protected String compareTailCrossingBonds(RepeatingUnitSgroup sgroup1, RepeatingUnitSgroup sgroup2) {
        return SgroupAtomBondDiffer.compareBondArrays(sgroup1.getTailCrossingBonds(), sgroup2.getTailCrossingBonds(), "repeating unit S-group tail crossing bonds");
    }

    public void ignoreTailCrossingBonds(boolean ignoreState) {
        this.ignoreTailCrossingBonds = ignoreState;
    }

    String compareAttributes(RepeatingUnitSgroup sgroup1, RepeatingUnitSgroup sgroup2) {
        String difference = super.compareAttributes(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        if (!this.ignoreFlipped && (difference = this.compareFlipped(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreHeadCrossingBonds && (difference = this.compareHeadCrossingBonds(sgroup1, sgroup2)) != null) {
            return difference;
        }
        if (!this.ignoreTailCrossingBonds && (difference = this.compareTailCrossingBonds(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }
}

