/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.core.util.differ.DifferUtils;
import chemaxon.core.util.differ.DifferenceObject;
import chemaxon.core.util.differ.MObjectDifferFactory;
import chemaxon.core.util.differ.MoleculeDiffer;
import chemaxon.core.util.differ.SimpleDifference;
import chemaxon.core.util.differ.StructureDiffer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MRArrow;
import java.util.Map;
import java.util.Set;

class RxnMoleculeDiffer
extends MoleculeDiffer {
    private boolean checkMSLogic = true;
    private boolean checkReactionArrow = true;
    private StructureDiffer differ = null;

    RxnMoleculeDiffer() {
    }

    protected RxnMoleculeDiffer(RxnMoleculeDiffer differ) {
        super(differ);
        this.checkMSLogic = differ.checkMSLogic;
        this.checkReactionArrow = differ.checkReactionArrow;
    }

    RxnMoleculeDiffer(StructureDiffer d) {
        this.differ = d;
    }

    protected void setStructureDiffer(StructureDiffer sdiffer) {
        this.differ = sdiffer;
    }

    protected StructureDiffer getStructureDiffer() {
        if (this.differ == null) {
            this.differ = new StructureDiffer(this.getAtomDiffer(), this.getBondDiffer(), this.getSgroupDiffer(), StructureDiffer.ComparisonDirection.SAME_CLASS);
        }
        return this.differ;
    }

    protected void ignoreMultiStepReaction(boolean b) {
        this.checkMSLogic = !b;
    }

    protected void ignoreReactionArrow(boolean b) {
        this.checkReactionArrow = !b;
    }

    @Override
    public DifferenceObject diffStopFirst(MoleculeGraph mg1, MoleculeGraph mg2) {
        DifferenceObject result = super.diffStopFirst(mg1, mg2);
        if (result != null) {
            return result;
        }
        if (!(mg1 instanceof RxnMolecule) || !(mg2 instanceof RxnMolecule)) {
            String mg1Str = mg1 instanceof RgMolecule ? "RgMolecule" : "not RgMolecule";
            String mg2Str = mg2 instanceof RgMolecule ? "RgMolecule" : "not RgMolecule";
            return new SimpleDifference(mg1, mg2, DifferUtils.getAttributeDifferenceString("data type", mg1Str, mg2Str));
        }
        RxnMolecule m1 = (RxnMolecule)mg1;
        RxnMolecule m2 = (RxnMolecule)mg2;
        result = this.compareSubStructures(m1, m2);
        if (result != null) {
            return result;
        }
        if (this.checkMSLogic && (result = this.compareMSLogic(m1, m2)) != null) {
            return result;
        }
        if (this.checkReactionArrow && (result = this.compareReactionArrow(m1, m2)) != null) {
            return result;
        }
        return null;
    }

    private DifferenceObject compareReactionArrow(RxnMolecule m1, RxnMolecule m2) {
        MRArrow arrow1 = m1.getReactionArrow(false);
        MRArrow arrow2 = m2.getReactionArrow(false);
        if (arrow1 == null && arrow2 == null) {
            return null;
        }
        if (arrow1 != null && arrow2 != null) {
            String difference = new MObjectDifferFactory().diff(arrow1, arrow2);
            if (difference != null) {
                return new SimpleDifference(m1, m2, "Different reaction arrows: " + difference);
            }
            return null;
        }
        String arrow1Str = arrow1 == null ? "null" : "not null";
        String arrow2Str = arrow2 == null ? "null" : "not null";
        return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("reaction arrows", arrow1Str, arrow2Str));
    }

    private DifferenceObject compareMSLogic(RxnMolecule m1, RxnMolecule m2) {
        Set<MRArrow> keys2;
        Map<MRArrow, RxnMolecule> logic1 = m1.getMSLogic();
        Map<MRArrow, RxnMolecule> logic2 = m2.getMSLogic();
        if (logic1 == null && logic2 == null) {
            return null;
        }
        if (logic1 == null || logic2 == null) {
            String logic1Str = logic1 == null ? "null" : "not null";
            String logic2Str = logic2 == null ? "null" : "not null";
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("multi step reaction logic", logic1Str, logic2Str));
        }
        Set<MRArrow> keys1 = logic1.keySet();
        if (!((Object)keys1).equals(keys2 = logic2.keySet())) {
            return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("multi step reaction logic", "", ""));
        }
        for (MRArrow mrArrow : keys1) {
            RxnMolecule r2;
            RxnMolecule r1 = logic1.get(mrArrow);
            DifferenceObject result = this.diffStopFirst(r1, r2 = logic2.get(mrArrow));
            if (result == null) continue;
            return new SimpleDifference(r1, r2, "Different molecules in MSLogic at key (" + mrArrow.toString() + "): " + ((Object)result).toString());
        }
        return null;
    }

    private DifferenceObject compareSubStructures(RxnMolecule m1, RxnMolecule m2) {
        for (int type = 0; type < 3; ++type) {
            if (m1.getComponentCount(type) != m2.getComponentCount(type)) {
                return new SimpleDifference(m1, m2, DifferUtils.getAttributeDifferenceString("component count at " + type, m1.getComponentCount(type), m2.getComponentCount(type)));
            }
            for (int i = 0; i < m1.getComponentCount(type); ++i) {
                Molecule mol1 = m1.getComponent(type, i);
                Molecule mol2 = m2.getComponent(type, i);
                DifferenceObject result = this.getStructureDiffer().diffStopFirst(mol1, mol2);
                if (result == null) continue;
                return new SimpleDifference(mol1, mol2, "Different substructures at component index (" + i + "): " + ((Object)result).toString());
            }
        }
        return null;
    }
}

