/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.core.util.differ;

import chemaxon.common.util.ArrayTools;
import chemaxon.core.util.differ.BasicSgroupDiffer;
import chemaxon.core.util.differ.DifferUtils;
import chemaxon.struc.MolAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.Arrays;

public class SuperatomSgroupDiffer
extends BasicSgroupDiffer {
    private boolean ignoreAttachAtoms = false;

    protected String compareExpansionState(SuperatomSgroup sgroup1, SuperatomSgroup sgroup2) {
        if (sgroup1.isExpanded() != sgroup2.isExpanded()) {
            return DifferUtils.getAttributeDifferenceString("superatom S-group expansion state", sgroup1.isExpanded(), sgroup2.isExpanded());
        }
        return null;
    }

    protected String compareAttachAtoms(SuperatomSgroup sgroup1, SuperatomSgroup sgroup2) {
        if (sgroup1.isExpanded() && sgroup2.isExpanded()) {
            return null;
        }
        if (sgroup1.isExpanded() || sgroup2.isExpanded()) {
            throw new RuntimeException("Superatom S-groups are in different expansion state which must have been recognized earlier.");
        }
        MolAtom[] attach1 = sgroup1.getAttachAtoms();
        MolAtom[] attach2 = sgroup2.getAttachAtoms();
        assert (attach1 != null && attach2 != null);
        if (attach1.length != attach2.length) {
            return DifferUtils.getAttributeDifferenceString("superatom S-group attach atoms length", attach1.length, attach2.length);
        }
        int[] atomIndexes1 = new int[attach1.length];
        int[] atomIndexes2 = new int[attach2.length];
        for (int i = 0; i < attach1.length; ++i) {
            atomIndexes1[i] = sgroup1.indexOf(attach1[i]);
            atomIndexes2[i] = sgroup2.indexOf(attach2[i]);
        }
        if (!ArrayTools.equalsArrays(atomIndexes1, atomIndexes2)) {
            return DifferUtils.getAttributeDifferenceString("superatom S-group attach atoms", Arrays.toString(atomIndexes1), Arrays.toString(atomIndexes2));
        }
        return null;
    }

    public void ignoreAttachAtoms(boolean ignoreState) {
        this.ignoreAttachAtoms = ignoreState;
    }

    String compareAttributes(SuperatomSgroup sgroup1, SuperatomSgroup sgroup2) {
        String difference = this.compareExpansionState(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        difference = super.compareAttributes(sgroup1, sgroup2);
        if (difference != null) {
            return difference;
        }
        if (!this.ignoreAttachAtoms && (difference = this.compareAttachAtoms(sgroup1, sgroup2)) != null) {
            return difference;
        }
        return null;
    }
}

