/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.BCUT;
import chemaxon.descriptors.BCUTGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.struc.Molecule;
import java.io.File;
import org.dom4j.Element;

public class BCUTParameters
extends MDParameters {
    private static final String DEFAULT_XML_CONFIG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<BCUTDescriptorsConfiguration Version=\"\" schemaLocation=\"\">\n    <BCUTDescriptors>\n        <BCUT Type=\"Burden\" Lowest=\"2\" Highest=\"2\" />\n    </BCUTDescriptors>\n    <ScreeningConfiguration>\n        <ParametrizedMetrics>\n            <ParametrizedMetric Name=\"Euclidean\" ActiveFamily=\"Generic\"\n                Metric=\"Euclidean\" Threshold=\"1500\" />\n        </ParametrizedMetrics>\n    </ScreeningConfiguration>\n</BCUTDescriptorsConfiguration>\n";
    private Element bcutNode = null;
    private int lowestCount;
    private int highestCount;
    private String type;
    private BCUTGenerator generator = null;

    public BCUTParameters() {
        this.md = new BCUT();
    }

    public BCUTParameters(File configFile) throws MDParametersException {
        this.md = new BCUT();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
    }

    public BCUTParameters(String XMLconfig) throws MDParametersException {
        this.md = new BCUT();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
    }

    @Override
    public String toString() {
        try {
            return super.toString();
        }
        catch (MDParametersException p) {
            return null;
        }
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
    }

    public int getLowestEigenvaluesCount() {
        return this.lowestCount;
    }

    public int getHighestEigenvaluesCount() {
        return this.highestCount;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getDefaultDocumentFrame() {
        return DEFAULT_XML_CONFIG;
    }

    @Override
    protected void initParameters() {
        super.initParameters();
        this.setLength(this.lowestCount + this.highestCount);
        this.data = new byte[this.getLength() * 4 + 1];
        this.generator = new BCUTGenerator();
    }

    protected String[] generate(Molecule m, MolecularDescriptor bc) throws MDGeneratorException {
        return this.generator.generate(m, bc);
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: {
                return this.getLength();
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        this.bcutNode = (Element)this.document.selectSingleNode("//BCUTDescriptorsConfiguration/BCUTDescriptors/BCUT");
        if (this.bcutNode == null) {
            this.bcutNode = (Element)this.document.selectSingleNode("//BCUTConfiguration/BCUTDescriptors/BCUT");
        }
        if (this.bcutNode != null) {
            String highest;
            this.type = this.bcutNode.attributeValue("Type");
            String lowest = this.bcutNode.attributeValue("Lowest");
            if (lowest != null) {
                this.lowestCount = Integer.parseInt(lowest);
            }
            if ((highest = this.bcutNode.attributeValue("Highest")) != null) {
                this.highestCount = Integer.parseInt(highest);
            }
        } else {
            throw new MDParametersException("Parameter configuration error. ");
        }
        this.readMetricParameters();
    }
}

