/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CustomDescriptor;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.jchem.version.VersionInfo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;

public class CDParameters
extends MDParameters {
    public static final int BINARY_DESCRIPTOR = 0;
    public static final int INTEGER_DESCRIPTOR = 1;
    public static final int FLOAT_DESCRIPTOR = 2;
    protected int descrType = 0;
    protected Element parameters = null;
    private static Logger logger = Logger.getLogger(CDParameters.class.getName());

    public CDParameters() {
        this.init();
    }

    public CDParameters(int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("Invalid CustomDescriptor type: " + type);
        }
        this.descrType = type;
        this.init();
    }

    public CDParameters(File configFile) throws MDParametersException {
        this.init();
        this.readFromXmlFile(configFile, false, true);
        this.initParameters();
        this.initGenerator();
    }

    public CDParameters(String XMLconfig) throws MDParametersException {
        this.init();
        this.readFromXmlString(XMLconfig, false, true);
        this.initParameters();
        this.initGenerator();
    }

    @Override
    public void fromString(String parameterString) throws MDParametersException {
        super.fromString(parameterString);
        this.initGenerator();
    }

    @Override
    public void fromFile(File parameterFile) throws MDParametersException {
        super.fromFile(parameterFile);
        this.initGenerator();
    }

    @Override
    public void setLength(int length) throws MDParametersException {
        if (this.descrType == 0 && length % 32 != 0) {
            throw new MDParametersException("Fingerprint length should be multiple of 32.");
        }
        super.setLength(length);
    }

    protected void initGenerator() throws MDParametersException {
        this.generator = null;
    }

    protected void init() {
        this.md = new CustomDescriptor();
    }

    @Override
    protected void initParameters() {
        if (logger.getLevel() == Level.FINEST) {
            logger.finest("initParameters length: \n" + this.length);
        }
        if (this.descrType == 0) {
            this.internalSize = this.length / 32;
        }
        this.data = new byte[this.internalSize * 4 + 1];
        super.initParameters();
    }

    public int getDescrType() {
        return this.descrType;
    }

    @Override
    protected int getNumberOfWeights(int parametrizedMetricIndex) throws IllegalArgumentException {
        int dissimilarityMetricIndex = (Integer)this.metricIndexes.get(this.currentMetricIndex);
        switch (dissimilarityMetricIndex) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.getLength();
            }
        }
        throw new IllegalArgumentException("Invalid metric index " + dissimilarityMetricIndex);
    }

    @Override
    public String getDefaultDocumentFrame() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<CustomDescriptorConfiguration Version =\"0.3\" >\n<Parameters Length=\"\" Type=\"\"/>\n</CustomDescriptorConfiguration>\n";
    }

    @Override
    protected void processDocument(boolean all) throws MDParametersException {
        this.checkDocumentVersion("CustomDescriptorConfiguration", VersionInfo.JCHEM_VERSION);
        if (all) {
            this.parameters = (Element)this.document.selectSingleNode("//*/Parameters");
        }
        super.processDocument(all);
    }

    @Override
    protected void readValues(boolean all) throws MDParametersException {
        if (all) {
            String p = this.parameters.attributeValue("Length");
            if (p == null) {
                throw new MDParametersException("Length parameter is mandatory.");
            }
            this.setLength(Integer.parseInt(p));
            p = this.parameters.attributeValue("Type");
            if (p != null) {
                if (p.equals("FLOAT")) {
                    this.descrType = 2;
                } else if (p.equals("INTEGER")) {
                    this.descrType = 1;
                } else if (p.equals("BINARY")) {
                    this.descrType = 0;
                } else {
                    throw new MDParametersException("Type attribute has an invalid value: " + p);
                }
            }
        }
        this.readMetricParameters();
    }
}

