/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CFParameters;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.MDGenerator;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.screen.ScreenMol;
import chemaxon.struc.Molecule;

public class CFGenerator
extends MDGenerator {
    public CFGenerator() {
    }

    public CFGenerator(Standardizer s, int length) {
    }

    public CFGenerator(int length) {
    }

    @Override
    public String[] generate(Molecule m, MolecularDescriptor d) throws MDGeneratorException {
        return this.generate(m, null, d);
    }

    public String[] generate(Molecule m, int[] aidxs, MolecularDescriptor d) throws MDGeneratorException {
        CFParameters params = (CFParameters)d.getParameters();
        Molecule stdMol = params.standardize(m);
        ChemicalFingerprint fp = (ChemicalFingerprint)d;
        fp.clear();
        byte[] fpr = null;
        fpr = aidxs == null ? ScreenMol.fingerprint(stdMol, params.getLength() / 8, params.getBondCount(), params.getBitCount(), -1, true) : ScreenMol.fingerprint(stdMol, aidxs, params.getLength() / 8, params.getBondCount(), params.getBitCount(), -1, true);
        fp.fromData(fpr);
        if (this.createStatistics) {
            this.updateStatistics(d);
        }
        return null;
    }

    @Override
    protected int calcFreqCount(MolecularDescriptor d) {
        ChemicalFingerprint cf = (ChemicalFingerprint)d;
        for (int i = 0; i < cf.fp.length; ++i) {
            int bi = 1;
            for (int b = 31; b >= 0; --b) {
                if ((cf.fp[i] & bi) != 0) {
                    int n = 32 * i + b;
                    this.freqCount[n] = this.freqCount[n] + 1;
                }
                bi <<= 1;
            }
        }
        return cf.getBrightness();
    }
}

