/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.CDParameters;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.Metrics;
import chemaxon.descriptors.MolecularDescriptor;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class CustomDescriptor
extends MolecularDescriptor {
    protected float[] floatDescr = null;
    protected int[] intDescr = null;
    private static final String[] metrics = new String[]{"Tanimoto", "Euclidean", "Tversky"};
    private static final float[] defaultThresholds = new float[]{0.2f, 20.0f, 0.2f};

    public CustomDescriptor() {
    }

    public CustomDescriptor(int type, int length) {
        this.params = new CDParameters(type);
        this.params.setLength(length);
        int descrType = ((CDParameters)this.params).getDescrType();
        if (descrType == 2) {
            this.floatDescr = new float[length];
        } else if (descrType == 0) {
            this.intDescr = new int[length / 32];
        } else if (descrType == 1) {
            this.intDescr = new int[length];
        } else {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
    }

    public CustomDescriptor(CDParameters params) {
        this.params = params;
        int descrType = params.getDescrType();
        if (descrType == 2) {
            this.floatDescr = new float[params.getLength()];
        } else if (descrType == 0) {
            this.intDescr = new int[params.getInternalSize()];
        } else if (descrType == 1) {
            this.intDescr = new int[params.getLength()];
        }
    }

    public CustomDescriptor(String params) {
        this.params = new CDParameters(params);
        int descrType = ((CDParameters)this.params).getDescrType();
        if (descrType == 2) {
            this.floatDescr = new float[this.params.getLength()];
        } else if (descrType == 0) {
            this.intDescr = new int[this.params.getInternalSize()];
        } else if (descrType == 1) {
            this.intDescr = new int[this.params.getLength()];
        }
    }

    public CustomDescriptor(CustomDescriptor cd) {
        this.params = cd.params;
        if (cd.floatDescr != null) {
            this.floatDescr = new float[this.params.getLength()];
            System.arraycopy(cd.floatDescr, 0, this.floatDescr, 0, this.params.getLength());
        } else if (cd.intDescr != null) {
            this.intDescr = new int[this.params.getInternalSize()];
            System.arraycopy(cd.intDescr, 0, this.intDescr, 0, this.params.getInternalSize());
        } else {
            this.intDescr = null;
            this.floatDescr = null;
        }
    }

    @Override
    public CustomDescriptor clone() {
        return new CustomDescriptor(this);
    }

    @Override
    public String getName() {
        return "Custom or third party molecular descriptor";
    }

    @Override
    public String getShortName() {
        return "CD";
    }

    @Override
    public String getParametersClassName() {
        return "chemaxon.descriptors.CDParameters";
    }

    public void setParameters(CDParameters parameters) {
        this.params = parameters;
        if (parameters.getDescrType() == 2) {
            if (this.floatDescr == null || this.floatDescr.length < this.params.getLength()) {
                this.floatDescr = new float[this.params.getLength()];
            }
        } else if (this.intDescr == null || this.intDescr.length < this.params.getInternalSize()) {
            this.intDescr = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    @Override
    public void setParameters(String parameters) throws MDParametersException {
        if (this.params == null) {
            this.params = new CDParameters();
            this.params.fromString(parameters);
        } else {
            this.params.fromString(parameters);
        }
        if (((CDParameters)this.params).getDescrType() == 2) {
            if (this.floatDescr == null || this.floatDescr.length < this.params.getLength()) {
                this.floatDescr = new float[this.params.getLength()];
            }
        } else if (this.intDescr == null || this.intDescr.length < this.params.getInternalSize()) {
            this.intDescr = new int[this.params.getInternalSize()];
        }
        this.clear();
    }

    @Override
    public byte[] toData() {
        byte[] d = this.params.getData();
        if (((CDParameters)this.params).getDescrType() == 2) {
            for (int i = 0; i < this.floatDescr.length; ++i) {
                int v = Float.floatToIntBits(this.floatDescr[i]);
                for (int j = 3; j >= 0; --j) {
                    d[i * 4 + j + 1] = (byte)(v & 0xFF);
                    v >>>= 8;
                }
            }
        } else {
            for (int i = 0; i < this.intDescr.length; ++i) {
                int v = this.intDescr[i];
                for (int j = 3; j >= 0; --j) {
                    d[i * 4 + j + 1] = (byte)(v & 0xFF);
                    v >>>= 8;
                }
            }
        }
        return d;
    }

    @Override
    public void fromData(byte[] dbRepr) {
        if (((CDParameters)this.params).getDescrType() == 2) {
            for (int i = 0; i < this.floatDescr.length; ++i) {
                int v = 0;
                for (int j = 0; j < 4; ++j) {
                    v <<= 8;
                    v += (dbRepr[i * 4 + j + 1] + 256) % 256;
                }
                this.floatDescr[i] = Float.intBitsToFloat(v);
            }
        } else {
            for (int i = 0; i < this.intDescr.length; ++i) {
                int v = 0;
                for (int j = 0; j < 4; ++j) {
                    v <<= 8;
                    v += (dbRepr[i * 4 + j + 1] + 256) % 256;
                }
                this.intDescr[i] = v;
            }
        }
    }

    public void set(int cell, float[] values) {
        System.arraycopy(values, 0, this.floatDescr, cell, values.length);
    }

    public void set(int cell, float value) {
        this.floatDescr[cell] = value;
    }

    public void set(int cell, int[] values) {
        System.arraycopy(values, 0, this.intDescr, cell, values.length);
    }

    public void set(int cell, int value) {
        if (((CDParameters)this.params).getDescrType() == 1) {
            this.intDescr[cell] = value;
        } else {
            int n = cell / 32;
            this.intDescr[n] = this.intDescr[n] | 1 << 31 - cell % 32;
        }
    }

    public int getBit(int cell) {
        return (this.intDescr[cell / 32] & 1 << 31 - cell % 32) == 0 ? 0 : 1;
    }

    public int getInt(int cell) {
        return this.intDescr[cell];
    }

    public float getFloat(int cell) {
        return this.floatDescr[cell];
    }

    public void clear() {
        if (this.floatDescr != null) {
            Arrays.fill(this.floatDescr, 0.0f);
        }
        if (this.intDescr != null) {
            Arrays.fill(this.intDescr, 0);
        }
    }

    @Override
    public String toString() {
        return this.toDecimalString();
    }

    @Override
    public String toDecimalString() {
        DecimalFormat df = this.params.getDecForm();
        StringBuffer sb = new StringBuffer();
        if (this.floatDescr != null) {
            for (int i = 0; i < this.floatDescr.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('\t');
                }
                sb.append(df.format(this.floatDescr[i]));
            }
        } else {
            for (int i = 0; i < this.intDescr.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('\t');
                }
                sb.append(df.format(this.intDescr[i]));
            }
        }
        return sb.toString();
    }

    @Override
    public void fromString(String descr) throws ParseException {
        this.clear();
        try {
            StringTokenizer st = new StringTokenizer(descr, "\t ");
            if (((CDParameters)this.params).getDescrType() == 2) {
                for (int i = 0; i < this.floatDescr.length; ++i) {
                    this.floatDescr[i] = Float.parseFloat(st.nextToken());
                }
            } else {
                for (int i = 0; i < this.floatDescr.length; ++i) {
                    this.intDescr[i] = Integer.parseInt(st.nextToken());
                }
            }
        }
        catch (NullPointerException npe) {
            throw new ParseException(descr + " too short", 0);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(descr + " contains invalid numbers", 0);
        }
    }

    @Override
    public float[] toFloatArray() {
        if (((CDParameters)this.params).getDescrType() == 2) {
            return (float[])this.floatDescr.clone();
        }
        float[] descr = new float[this.intDescr.length];
        for (int i = 0; i < descr.length; ++i) {
            descr[i] = this.intDescr[i];
        }
        return descr;
    }

    @Override
    public void fromFloatArray(float[] descr) {
        if (((CDParameters)this.params).getDescrType() == 2) {
            System.arraycopy(descr, 0, this.floatDescr, 0, this.floatDescr.length);
        } else {
            for (int i = 0; i < descr.length; ++i) {
                this.intDescr[i] = (int)descr[i];
            }
        }
    }

    @Override
    public String[] getDissimilarityMetrics() {
        return metrics;
    }

    @Override
    public float[] getDefaultDissimilarityMetricThresholds() {
        return defaultThresholds;
    }

    public float getTanimoto(CustomDescriptor f) {
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isAsymmetric() ? Metrics.asymmetricTanimoto(this.floatDescr, f.floatDescr, this.params.getAsymmetryFactor()) : Metrics.tanimoto(this.floatDescr, f.floatDescr);
            }
            case 1: {
                return this.params.isAsymmetric() ? Metrics.asymmetricTanimoto(this.intDescr, f.intDescr, this.params.getAsymmetryFactor()) : Metrics.tanimoto(this.intDescr, f.intDescr);
            }
            case 0: {
                return this.params.isAsymmetric() ? Metrics.binaryAsymmetricTanimoto(this.intDescr, f.intDescr, this.params.getAsymmetryFactor()) : Metrics.binaryTanimoto(this.intDescr, f.intDescr);
            }
        }
        return 0.0f;
    }

    public float getScaledTanimoto(CustomDescriptor f) {
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isAsymmetric() ? Metrics.scaledAsymmetricTanimoto(this.floatDescr, f.floatDescr, this.params.getScalingHypothesis().toFloatArray(), this.params.getScaleFactor(), this.params.getAsymmetryFactor()) : Metrics.scaledTanimoto(this.floatDescr, f.floatDescr, this.params.getScalingHypothesis().toFloatArray(), this.params.getScaleFactor());
            }
            case 1: {
                return this.params.isAsymmetric() ? Metrics.scaledAsymmetricTanimoto(this.intDescr, f.intDescr, this.params.getScalingHypothesis().toFloatArray(), this.params.getScaleFactor(), this.params.getAsymmetryFactor()) : Metrics.scaledTanimoto(this.intDescr, f.intDescr, this.params.getScalingHypothesis().toFloatArray(), this.params.getScaleFactor());
            }
        }
        return 0.0f;
    }

    public float getEuclidean(CustomDescriptor f) {
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isNormalized() ? Metrics.normalizedEuclidean(this.floatDescr, f.floatDescr) : Metrics.euclidean(this.floatDescr, f.floatDescr);
            }
            case 1: {
                return this.params.isNormalized() ? Metrics.normalizedEuclidean(this.intDescr, f.intDescr) : Metrics.euclidean(this.intDescr, f.intDescr);
            }
            case 0: {
                return this.params.isNormalized() ? Metrics.binaryNormalizedEuclidean(this.intDescr, f.intDescr) : Metrics.binaryEuclidean(this.intDescr, f.intDescr);
            }
        }
        return 0.0f;
    }

    public float getAsymmetricEuclidean(CustomDescriptor f) {
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isNormalized() ? Metrics.asymmetricNormalizedEuclidean(this.floatDescr, f.floatDescr, (double)this.params.getAsymmetryFactor()) : Metrics.asymmetricEuclidean(this.floatDescr, f.floatDescr, (double)this.params.getAsymmetryFactor());
            }
            case 1: {
                return this.params.isNormalized() ? Metrics.asymmetricNormalizedEuclidean(this.intDescr, f.intDescr, (double)this.params.getAsymmetryFactor()) : Metrics.asymmetricEuclidean(this.intDescr, f.intDescr, (double)this.params.getAsymmetryFactor());
            }
            case 0: {
                return this.params.isNormalized() ? Metrics.binaryAsymmetricNormalizedEuclidean(this.intDescr, f.intDescr, this.params.getAsymmetryFactor()) : Metrics.binaryAsymmetricEuclidean(this.intDescr, f.intDescr, this.params.getAsymmetryFactor());
            }
        }
        return 0.0f;
    }

    public float getWeightedEuclidean(CustomDescriptor f) {
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isNormalized() ? Metrics.weightedNormalizedEuclidean(this.floatDescr, f.floatDescr, this.params.getWeights()) : Metrics.weightedEuclidean(this.floatDescr, f.floatDescr, this.params.getWeights());
            }
            case 1: {
                return this.params.isNormalized() ? Metrics.weightedNormalizedEuclidean(this.intDescr, f.intDescr, this.params.getWeights()) : Metrics.weightedEuclidean(this.intDescr, f.intDescr, this.params.getWeights());
            }
            case 0: {
                return this.params.isNormalized() ? Metrics.binaryWeightedNormalizedEuclidean(this.intDescr, f.intDescr, this.params.getWeights()) : Metrics.binaryWeightedEuclidean(this.intDescr, f.intDescr, this.params.getWeights());
            }
        }
        return 0.0f;
    }

    public float getWeightedAsymmetricEuclidean(CustomDescriptor f) {
        boolean norm = this.params.isNormalized();
        double k1 = this.params.getAsymmetryFactor();
        switch (((CDParameters)this.params).getDescrType()) {
            case 2: {
                return this.params.isNormalized() ? Metrics.weightedAsymmetricNormalizedEuclidean(this.floatDescr, f.floatDescr, this.params.getWeights(), this.params.getAsymmetryFactor()) : Metrics.weightedAsymmetricEuclidean(this.floatDescr, f.floatDescr, this.params.getWeights(), this.params.getAsymmetryFactor());
            }
            case 1: {
                return this.params.isNormalized() ? Metrics.weightedAsymmetricNormalizedEuclidean(this.intDescr, f.intDescr, this.params.getWeights(), this.params.getAsymmetryFactor()) : Metrics.weightedAsymmetricEuclidean(this.intDescr, f.intDescr, this.params.getWeights(), this.params.getAsymmetryFactor());
            }
            case 0: {
                return this.params.isNormalized() ? Metrics.binaryWeightedAsymmetricNormalizedEuclidean(this.intDescr, f.intDescr, this.params.getWeights(), this.params.getAsymmetryFactor()) : Metrics.binaryWeightedAsymmetricEuclidean(this.intDescr, f.intDescr, this.params.getWeights(), this.params.getAsymmetryFactor());
            }
        }
        return 0.0f;
    }

    @Override
    public float getDissimilarity(MolecularDescriptor descr) {
        return this.getDissimilarity(descr, this.params.getCurrentMetricIndex());
    }

    @Override
    public float getDissimilarity(MolecularDescriptor descr, int metricIndex) {
        this.params.setCurrentParametrizedMetric(metricIndex);
        int mi = this.params.getInternalMetricIndex();
        MDParameters p = this.params;
        boolean as = p.isAsymmetric();
        switch (mi) {
            case 0: {
                return p.isScaled() ? this.getScaledTanimoto((CustomDescriptor)descr) : this.getTanimoto((CustomDescriptor)descr);
            }
            case 1: {
                boolean w = p.isWeighted();
                if (!as && !w) {
                    return this.getEuclidean((CustomDescriptor)descr);
                }
                if (as && !w) {
                    return this.getAsymmetricEuclidean((CustomDescriptor)descr);
                }
                if (!as && w) {
                    return this.getWeightedEuclidean((CustomDescriptor)descr);
                }
                return this.getWeightedAsymmetricEuclidean((CustomDescriptor)descr);
            }
        }
        throw new IllegalArgumentException("Invalid metricIndex (" + metricIndex + ") passed to CustomDescriptor.getDissimilarity()");
    }
}

