/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.descriptors;

import chemaxon.descriptors.BCUT;
import chemaxon.descriptors.CFGenerator;
import chemaxon.descriptors.ChemicalFingerprint;
import chemaxon.descriptors.ECFP;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParametersException;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.descriptors.PharmacophoreFingerprint;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.reaction.Standardizer;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import org.dom4j.Document;
import org.dom4j.Element;

public class DescriptorGenerator {
    private static final String[] descrShortNames = new String[]{"ECFP", "Shape", "CF", "PF", "RF", "BCUT"};
    private static final String[] descrLongNames = new String[]{"ECFP fingerprint", "Shape descriptor", "Chemical Fingerprint", "Pharmacophore Fingerprint", "Reaction Fingerprint", "BCUT descriptor"};
    MolecularDescriptor md = null;

    public static String[] getDescriptorTypes() {
        return descrShortNames;
    }

    public static String getDescriptorLongName(String descrType) {
        for (int i = 0; i != descrShortNames.length; ++i) {
            if (!descrShortNames[i].equals(descrType)) continue;
            return descrLongNames[i];
        }
        throw new IllegalArgumentException("Unknown descriptor type");
    }

    public DescriptorGenerator(String descrType) {
        this.md = MolecularDescriptor.newInstance(descrType);
        this.md.setParameters((String)null);
    }

    public DescriptorGenerator(String descrType, String configString) throws MDParametersException {
        this.md = MolecularDescriptor.newInstance(descrType);
        this.md.setParameters(configString);
    }

    public void setParameter(String paramName, String paramValue) {
        Document doc = this.md.getParameters().document;
        Element paramsNode = null;
        if (this.md instanceof ECFP) {
            paramsNode = (Element)doc.selectSingleNode("//ECFPConfiguration/Parameters");
        }
        if (this.md instanceof ChemicalFingerprint) {
            paramsNode = (Element)doc.selectSingleNode("//ChemicalFingerprintConfiguration/Parameters");
        }
        if (this.md instanceof PharmacophoreFingerprint) {
            paramsNode = (Element)doc.selectSingleNode("//PharmacophoreFingerprintConfiguration/PharmacophoreDefinition/PharmacophoreFingerprintParameters");
        }
        if (this.md instanceof ReactionFingerprint) {
            paramsNode = (Element)doc.selectSingleNode("//ReactionFingerprintConfiguration/Parameters");
        }
        if (this.md instanceof BCUT) {
            paramsNode = (Element)doc.selectSingleNode("//BCUTConfiguration/BCUTDescriptors/BCUT");
        }
        if (paramsNode != null) {
            paramsNode.addAttribute(paramName, paramValue);
            this.md.setParameters(doc.asXML());
        }
    }

    public void setStandardizer(Standardizer standardizer) {
        this.md.getParameters().standardizer = standardizer;
        this.md.getParameters().standardizerConfigurationNode = null;
    }

    public void generate(Molecule mol) throws MDGeneratorException {
        this.md.generate(mol);
    }

    public void generate(Molecule mol, int[] atoms) throws MDGeneratorException {
        if (!(this.md instanceof ChemicalFingerprint)) {
            throw new UnsupportedOperationException("Partial generation is not supported by this descriptor type");
        }
        CFGenerator gen = (CFGenerator)this.md.getParameters().getGenerator();
        gen.generate(mol, atoms, this.md);
    }

    public String getAsString() {
        return this.md.toString();
    }

    public float[] getAsFloatArray() throws UnsupportedOperationException {
        return this.md.toFloatArray();
    }

    public int[] getAsIntArray() throws UnsupportedOperationException {
        if (this.md instanceof ECFP) {
            return (int[])((ECFP)this.md).ids.clone();
        }
        if (this.md instanceof ChemicalFingerprint) {
            return (int[])((ChemicalFingerprint)this.md).fp.clone();
        }
        if (this.md instanceof ReactionFingerprint) {
            return (int[])((ReactionFingerprint)this.md).fp.clone();
        }
        if (this.md instanceof PharmacophoreFingerprint) {
            float[] floatArray = this.md.toFloatArray();
            int[] intArray = new int[floatArray.length];
            for (int i = 0; i != floatArray.length; ++i) {
                intArray[i] = (int)floatArray[i];
            }
            return intArray;
        }
        throw new UnsupportedOperationException("Int array representation is not supported by this descriptor type");
    }

    public BitSet getAsBitSet() throws UnsupportedOperationException {
        int[] intArray = null;
        if (this.md instanceof ECFP) {
            ((ECFP)this.md).requireBinaryVector();
            intArray = ((ECFP)this.md).fp;
        }
        if (this.md instanceof ChemicalFingerprint) {
            intArray = ((ChemicalFingerprint)this.md).fp;
        }
        if (this.md instanceof ReactionFingerprint) {
            intArray = ((ReactionFingerprint)this.md).fp;
        }
        if (intArray == null) {
            throw new UnsupportedOperationException("BitSet representation is not supported by this descriptor type");
        }
        BitSet bitSet = new BitSet(intArray.length * 32);
        for (int i = 0; i != intArray.length; ++i) {
            int x = intArray[i];
            for (int j = 31; j >= 0; --j) {
                if ((x & 1) != 0) {
                    bitSet.set(i * 32 + j);
                }
                x >>= 1;
            }
        }
        return bitSet;
    }
}

